/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityManagerNative;
import android.app.IActivityContainer;
import android.app.IActivityContainerCallback;
import android.app.PendingIntent;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.graphics.SurfaceTexture;
import android.os.IBinder;
import android.os.OperationCanceledException;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.InputEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.android.internal.annotations.GuardedBy;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ActivityView
extends ViewGroup {
    private static final String TAG = "ActivityView";
    private static final boolean DEBUG = false;
    private static final int MSG_SET_SURFACE = 1;
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int MINIMUM_POOL_SIZE = 1;
    private static final int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final int KEEP_ALIVE = 1;
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "ActivityView #" + this.mCount.getAndIncrement());
        }
    };
    private static final BlockingQueue<Runnable> sPoolWorkQueue = new LinkedBlockingQueue<Runnable>(128);
    private static final Executor sExecutor = new ThreadPoolExecutor(1, MAXIMUM_POOL_SIZE, 1L, TimeUnit.SECONDS, sPoolWorkQueue, sThreadFactory);
    private final SerialExecutor mExecutor = new SerialExecutor();
    private final int mDensityDpi;
    private final TextureView mTextureView;
    @GuardedBy(value="mActivityContainerLock")
    private ActivityContainerWrapper mActivityContainer;
    private Object mActivityContainerLock = new Object();
    private Activity mActivity;
    private int mWidth;
    private int mHeight;
    private Surface mSurface;
    private int mLastVisibility;
    private ActivityViewCallback mActivityViewCallback;

    public ActivityView(Context context) {
        this(context, null);
    }

    public ActivityView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ActivityView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                this.mActivity = (Activity)context;
                break;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (this.mActivity == null) {
            throw new IllegalStateException("The ActivityView's Context is not an Activity.");
        }
        try {
            this.mActivityContainer = new ActivityContainerWrapper(ActivityManagerNative.getDefault().createVirtualActivityContainer(this.mActivity.getActivityToken(), new ActivityContainerCallback(this)));
        }
        catch (RemoteException e) {
            throw new RuntimeException("ActivityView: Unable to create ActivityContainer. " + e);
        }
        this.mTextureView = new TextureView(context);
        this.mTextureView.setSurfaceTextureListener(new ActivityViewSurfaceTextureListener());
        this.addView(this.mTextureView);
        WindowManager wm = (WindowManager)this.mActivity.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        this.mDensityDpi = metrics.densityDpi;
        this.mLastVisibility = this.getVisibility();
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mTextureView.layout(0, 0, r - l, b - t);
    }

    @Override
    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.mSurface != null && (visibility == 8 || this.mLastVisibility == 8)) {
            Surface surface = visibility == 8 ? null : this.mSurface;
            this.setSurfaceAsync(surface, this.mWidth, this.mHeight, this.mDensityDpi, false);
        }
        this.mLastVisibility = visibility;
    }

    private boolean injectInputEvent(InputEvent event) {
        return this.mActivityContainer != null && this.mActivityContainer.injectEvent(event);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        return this.injectInputEvent(event) || super.onTouchEvent(event);
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent event) {
        if (event.isFromSource(2) && this.injectInputEvent(event)) {
            return true;
        }
        return super.onGenericMotionEvent(event);
    }

    @Override
    public void onAttachedToWindow() {
    }

    @Override
    public void onDetachedFromWindow() {
    }

    public boolean isAttachedToDisplay() {
        return this.mSurface != null;
    }

    public void startActivity(Intent intent) {
        if (this.mActivityContainer == null) {
            throw new IllegalStateException("Attempt to call startActivity after release");
        }
        if (this.mSurface == null) {
            throw new IllegalStateException("Surface not yet created.");
        }
        if (this.mActivityContainer.startActivity(intent) == -6) {
            throw new OperationCanceledException();
        }
    }

    public void startActivity(IntentSender intentSender) {
        if (this.mActivityContainer == null) {
            throw new IllegalStateException("Attempt to call startActivity after release");
        }
        if (this.mSurface == null) {
            throw new IllegalStateException("Surface not yet created.");
        }
        IIntentSender iIntentSender = intentSender.getTarget();
        if (this.mActivityContainer.startActivityIntentSender(iIntentSender) == -6) {
            throw new OperationCanceledException();
        }
    }

    public void startActivity(PendingIntent pendingIntent) {
        if (this.mActivityContainer == null) {
            throw new IllegalStateException("Attempt to call startActivity after release");
        }
        if (this.mSurface == null) {
            throw new IllegalStateException("Surface not yet created.");
        }
        IIntentSender iIntentSender = pendingIntent.getTarget();
        if (this.mActivityContainer.startActivityIntentSender(iIntentSender) == -6) {
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.mActivityContainer == null) {
            Log.e(TAG, "Duplicate call to release");
            return;
        }
        Object object = this.mActivityContainerLock;
        synchronized (object) {
            this.mActivityContainer.release();
            this.mActivityContainer = null;
        }
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        this.mTextureView.setSurfaceTextureListener(null);
    }

    private void setSurfaceAsync(final Surface surface, final int width, final int height, final int densityDpi, final boolean callback) {
        this.mExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = ActivityView.this.mActivityContainerLock;
                    synchronized (object) {
                        if (ActivityView.this.mActivityContainer != null) {
                            ActivityView.this.mActivityContainer.setSurface(surface, width, height, densityDpi);
                        }
                    }
                }
                catch (RemoteException e) {
                    throw new RuntimeException("ActivityView: Unable to set surface of ActivityContainer. ", e);
                }
                if (callback) {
                    ActivityView.this.post(new Runnable(){

                        @Override
                        public void run() {
                            if (ActivityView.this.mActivityViewCallback != null) {
                                if (surface != null) {
                                    ActivityView.this.mActivityViewCallback.onSurfaceAvailable(ActivityView.this);
                                } else {
                                    ActivityView.this.mActivityViewCallback.onSurfaceDestroyed(ActivityView.this);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public void setCallback(ActivityViewCallback callback) {
        this.mActivityViewCallback = callback;
        if (this.mSurface != null) {
            this.mActivityViewCallback.onSurfaceAvailable(this);
        }
    }

    private static class ActivityContainerWrapper {
        private final IActivityContainer mIActivityContainer;
        private final CloseGuard mGuard = CloseGuard.get();
        boolean mOpened;

        ActivityContainerWrapper(IActivityContainer container) {
            this.mIActivityContainer = container;
            this.mOpened = true;
            this.mGuard.open("release");
        }

        void attachToDisplay(int displayId) {
            try {
                this.mIActivityContainer.attachToDisplay(displayId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        void setSurface(Surface surface, int width, int height, int density) throws RemoteException {
            this.mIActivityContainer.setSurface(surface, width, height, density);
        }

        int startActivity(Intent intent) {
            try {
                return this.mIActivityContainer.startActivity(intent);
            }
            catch (RemoteException e) {
                throw new RuntimeException("ActivityView: Unable to startActivity. " + e);
            }
        }

        int startActivityIntentSender(IIntentSender intentSender) {
            try {
                return this.mIActivityContainer.startActivityIntentSender(intentSender);
            }
            catch (RemoteException e) {
                throw new RuntimeException("ActivityView: Unable to startActivity from IntentSender. " + e);
            }
        }

        int getDisplayId() {
            try {
                return this.mIActivityContainer.getDisplayId();
            }
            catch (RemoteException e) {
                return -1;
            }
        }

        boolean injectEvent(InputEvent event) {
            try {
                return this.mIActivityContainer.injectEvent(event);
            }
            catch (RemoteException e) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release() {
            CloseGuard closeGuard = this.mGuard;
            synchronized (closeGuard) {
                if (this.mOpened) {
                    try {
                        this.mIActivityContainer.release();
                        this.mGuard.close();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    this.mOpened = false;
                }
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (this.mGuard != null) {
                    this.mGuard.warnIfOpen();
                    this.release();
                }
            }
            finally {
                super.finalize();
            }
        }
    }

    private static class ActivityContainerCallback
    extends IActivityContainerCallback.Stub {
        private final WeakReference<ActivityView> mActivityViewWeakReference;

        ActivityContainerCallback(ActivityView activityView) {
            this.mActivityViewWeakReference = new WeakReference<ActivityView>(activityView);
        }

        @Override
        public void setVisible(IBinder container, boolean visible) {
        }

        @Override
        public void onAllActivitiesComplete(IBinder container) {
            ActivityViewCallback callback;
            final ActivityView activityView = (ActivityView)this.mActivityViewWeakReference.get();
            if (activityView != null && (callback = activityView.mActivityViewCallback) != null) {
                final WeakReference<ActivityViewCallback> callbackRef = new WeakReference<ActivityViewCallback>(callback);
                activityView.post(new Runnable(){

                    @Override
                    public void run() {
                        ActivityViewCallback callback = (ActivityViewCallback)callbackRef.get();
                        if (callback != null) {
                            callback.onAllActivitiesComplete(activityView);
                        }
                    }
                });
            }
        }
    }

    private class ActivityViewSurfaceTextureListener
    implements TextureView.SurfaceTextureListener {
        private ActivityViewSurfaceTextureListener() {
        }

        @Override
        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            if (ActivityView.this.mActivityContainer == null) {
                return;
            }
            ActivityView.this.mWidth = width;
            ActivityView.this.mHeight = height;
            ActivityView.this.mSurface = new Surface(surfaceTexture);
            ActivityView.this.setSurfaceAsync(ActivityView.this.mSurface, ActivityView.this.mWidth, ActivityView.this.mHeight, ActivityView.this.mDensityDpi, true);
        }

        @Override
        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
            if (ActivityView.this.mActivityContainer == null) {
                return;
            }
        }

        @Override
        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            if (ActivityView.this.mActivityContainer == null) {
                return true;
            }
            ActivityView.this.mSurface.release();
            ActivityView.this.mSurface = null;
            ActivityView.this.setSurfaceAsync(null, ActivityView.this.mWidth, ActivityView.this.mHeight, ActivityView.this.mDensityDpi, true);
            return true;
        }

        @Override
        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }
    }

    public static abstract class ActivityViewCallback {
        public abstract void onAllActivitiesComplete(ActivityView var1);

        public abstract void onSurfaceAvailable(ActivityView var1);

        public abstract void onSurfaceDestroyed(ActivityView var1);
    }

    private static class SerialExecutor
    implements Executor {
        private final ArrayDeque<Runnable> mTasks = new ArrayDeque();
        private Runnable mActive;

        private SerialExecutor() {
        }

        @Override
        public synchronized void execute(final Runnable r) {
            this.mTasks.offer(new Runnable(){

                @Override
                public void run() {
                    try {
                        r.run();
                    }
                    finally {
                        this.scheduleNext();
                    }
                }
            });
            if (this.mActive == null) {
                this.scheduleNext();
            }
        }

        protected synchronized void scheduleNext() {
            this.mActive = this.mTasks.poll();
            if (this.mActive != null) {
                sExecutor.execute(this.mActive);
            }
        }
    }
}

