/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.ActivityOptions;
import android.app.Application;
import android.app.ApplicationPackageManager;
import android.app.ApplicationThreadNative;
import android.app.ContextImpl;
import android.app.IActivityManager;
import android.app.IInstrumentationWatcher;
import android.app.IUiAutomationConnection;
import android.app.Instrumentation;
import android.app.LoadedApk;
import android.app.OnActivityPausedListener;
import android.app.ProfilerInfo;
import android.app.QueuedWork;
import android.app.RemoteServiceException;
import android.app.ResourcesManager;
import android.app.ResultInfo;
import android.app.Service;
import android.app.assist.AssistContent;
import android.app.assist.AssistStructure;
import android.app.backup.BackupAgent;
import android.content.BroadcastReceiver;
import android.content.ComponentCallbacks2;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.Context;
import android.content.IContentProvider;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.ServiceInfo;
import android.content.res.AssetManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDebug;
import android.ddm.DdmHandleAppName;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.hardware.display.DisplayManagerGlobal;
import android.icu.text.DateFormat;
import android.net.ConnectivityManager;
import android.net.IConnectivityManager;
import android.net.Network;
import android.net.Proxy;
import android.net.ProxyInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.DropBoxManager;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.LocaleList;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.TransactionTooLargeException;
import android.os.UserHandle;
import android.renderscript.RenderScriptCacheDir;
import android.security.NetworkSecurityPolicy;
import android.security.net.config.NetworkSecurityConfigProvider;
import android.util.ArrayMap;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import android.util.PrintWriterPrinter;
import android.util.Slog;
import android.util.SparseIntArray;
import android.util.SuperNotCalledException;
import android.view.ContextThemeWrapper;
import android.view.Display;
import android.view.ThreadedRenderer;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewRootImpl;
import android.view.Window;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.content.ReferrerIntent;
import com.android.internal.os.BinderInternal;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.SamplingProfilerIntegration;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastPrintWriter;
import com.android.org.conscrypt.OpenSSLSocketImpl;
import com.android.org.conscrypt.TrustedCertificateStore;
import com.android.tools.layoutlib.create.OverrideMethod;
import com.google.android.collect.Lists;
import dalvik.system.CloseGuard;
import dalvik.system.VMDebug;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import libcore.io.DropBox;
import libcore.io.EventLogger;
import libcore.io.IoUtils;
import libcore.net.event.NetworkEventDispatcher;
import org.apache.harmony.dalvik.ddmc.DdmVmInternal;

public class ActivityThread {
    public static final String TAG = "ActivityThread";
    private static final Bitmap.Config THUMBNAIL_FORMAT = Bitmap.Config.RGB_565;
    static final boolean localLOGV = false;
    static final boolean DEBUG_MESSAGES = false;
    public static final boolean DEBUG_BROADCAST = false;
    private static final boolean DEBUG_RESULTS = false;
    private static final boolean DEBUG_BACKUP = false;
    public static final boolean DEBUG_CONFIGURATION = false;
    private static final boolean DEBUG_SERVICE = false;
    private static final boolean DEBUG_MEMORY_TRIM = false;
    private static final boolean DEBUG_PROVIDER = false;
    private static final boolean DEBUG_ORDER = false;
    private static final long MIN_TIME_BETWEEN_GCS = 5000L;
    private static final int SQLITE_MEM_RELEASED_EVENT_LOG_TAG = 75003;
    private static final int LOG_AM_ON_PAUSE_CALLED = 30021;
    private static final int LOG_AM_ON_RESUME_CALLED = 30022;
    private static final int LOG_AM_ON_STOP_CALLED = 30049;
    public static final int SERVICE_DONE_EXECUTING_ANON = 0;
    public static final int SERVICE_DONE_EXECUTING_START = 1;
    public static final int SERVICE_DONE_EXECUTING_STOP = 2;
    private static final int USER_LEAVING = 1;
    private static final int DONT_REPORT = 2;
    private static final boolean REPORT_TO_ACTIVITY = true;
    private ContextImpl mSystemContext;
    static volatile IPackageManager sPackageManager;
    final ApplicationThread mAppThread = new ApplicationThread();
    final Looper mLooper = Looper.myLooper();
    final H mH = new H();
    final ArrayMap<IBinder, ActivityClientRecord> mActivities = new ArrayMap();
    ActivityClientRecord mNewActivities = null;
    int mNumVisibleActivities = 0;
    ArrayList<WeakReference<AssistStructure>> mLastAssistStructures = new ArrayList();
    private int mLastSessionId;
    final ArrayMap<IBinder, Service> mServices = new ArrayMap();
    AppBindData mBoundApplication;
    Profiler mProfiler;
    int mCurDefaultDisplayDpi;
    boolean mDensityCompatMode;
    Configuration mConfiguration;
    Configuration mCompatConfiguration;
    Application mInitialApplication;
    final ArrayList<Application> mAllApplications = new ArrayList();
    final ArrayMap<String, BackupAgent> mBackupAgents = new ArrayMap();
    private static volatile ActivityThread sCurrentActivityThread;
    Instrumentation mInstrumentation;
    String mInstrumentationPackageName = null;
    String mInstrumentationAppDir = null;
    String[] mInstrumentationSplitAppDirs = null;
    String mInstrumentationLibDir = null;
    String mInstrumentedAppDir = null;
    String[] mInstrumentedSplitAppDirs = null;
    String mInstrumentedLibDir = null;
    boolean mSystemThread = false;
    boolean mJitEnabled = false;
    boolean mSomeActivitiesChanged = false;
    final ArrayMap<String, WeakReference<LoadedApk>> mPackages = new ArrayMap();
    final ArrayMap<String, WeakReference<LoadedApk>> mResourcePackages = new ArrayMap();
    final ArrayList<ActivityClientRecord> mRelaunchingActivities = new ArrayList();
    Configuration mPendingConfiguration = null;
    @GuardedBy(value="mResourcesManager")
    int mLifecycleSeq = 0;
    private final ResourcesManager mResourcesManager;
    final ArrayMap<ProviderKey, ProviderClientRecord> mProviderMap = new ArrayMap();
    final ArrayMap<IBinder, ProviderRefCount> mProviderRefCountMap = new ArrayMap();
    final ArrayMap<IBinder, ProviderClientRecord> mLocalProviders = new ArrayMap();
    final ArrayMap<ComponentName, ProviderClientRecord> mLocalProvidersByName = new ArrayMap();
    final ArrayMap<Activity, ArrayList<OnActivityPausedListener>> mOnPauseListeners = new ArrayMap();
    final GcIdler mGcIdler = new GcIdler();
    boolean mGcIdlerScheduled = false;
    static volatile Handler sMainThreadHandler;
    Bundle mCoreSettings = null;
    private Configuration mMainThreadConfig = new Configuration();
    private static final String HEAP_FULL_COLUMN = "%13s %8s %8s %8s %8s %8s %8s %8s %8s %8s %8s";
    private static final String HEAP_COLUMN = "%13s %8s %8s %8s %8s %8s %8s %8s";
    private static final String ONE_COUNT_COLUMN = "%21s %8d";
    private static final String TWO_COUNT_COLUMNS = "%21s %8d %21s %8d";
    private static final String ONE_COUNT_COLUMN_HEADER = "%21s %8s";
    private static final int ACTIVITY_THREAD_CHECKIN_VERSION = 4;
    private static final ThreadLocal<Intent> sCurrentBroadcastIntent;
    private int mThumbnailWidth = -1;
    private int mThumbnailHeight = -1;
    private Bitmap mAvailThumbnailBitmap = null;
    private Canvas mThumbnailCanvas = null;

    private void dumpGraphicsInfo(FileDescriptor fileDescriptor) {
        OverrideMethod.invokeV("android.app.ActivityThread#dumpGraphicsInfo(Ljava/io/FileDescriptor;)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLifecycleSeq() {
        ResourcesManager resourcesManager = this.mResourcesManager;
        synchronized (resourcesManager) {
            return this.mLifecycleSeq++;
        }
    }

    public static ActivityThread currentActivityThread() {
        return sCurrentActivityThread;
    }

    public static boolean isSystem() {
        return sCurrentActivityThread != null ? ActivityThread.sCurrentActivityThread.mSystemThread : false;
    }

    public static String currentOpPackageName() {
        ActivityThread am = ActivityThread.currentActivityThread();
        return am != null && am.getApplication() != null ? am.getApplication().getOpPackageName() : null;
    }

    public static String currentPackageName() {
        ActivityThread am = ActivityThread.currentActivityThread();
        return am != null && am.mBoundApplication != null ? am.mBoundApplication.appInfo.packageName : null;
    }

    public static String currentProcessName() {
        ActivityThread am = ActivityThread.currentActivityThread();
        return am != null && am.mBoundApplication != null ? am.mBoundApplication.processName : null;
    }

    public static Application currentApplication() {
        ActivityThread am = ActivityThread.currentActivityThread();
        return am != null ? am.mInitialApplication : null;
    }

    public static IPackageManager getPackageManager() {
        if (sPackageManager != null) {
            return sPackageManager;
        }
        IBinder b = ServiceManager.getService("package");
        sPackageManager = IPackageManager.Stub.asInterface(b);
        return sPackageManager;
    }

    Configuration applyConfigCompatMainThread(int displayDensity, Configuration config, CompatibilityInfo compat) {
        if (config == null) {
            return null;
        }
        if (!compat.supportsScreen()) {
            this.mMainThreadConfig.setTo(config);
            config = this.mMainThreadConfig;
            compat.applyToConfiguration(displayDensity, config);
        }
        return config;
    }

    Resources getTopLevelResources(String resDir, String[] splitResDirs, String[] overlayDirs, String[] libDirs, int displayId, LoadedApk pkgInfo) {
        return this.mResourcesManager.getResources(null, resDir, splitResDirs, overlayDirs, libDirs, displayId, null, pkgInfo.getCompatibilityInfo(), pkgInfo.getClassLoader());
    }

    Handler getHandler() {
        return this.mH;
    }

    public LoadedApk getPackageInfo(String packageName, CompatibilityInfo compatInfo, int flags) {
        return this.getPackageInfo(packageName, compatInfo, flags, UserHandle.myUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedApk getPackageInfo(String packageName, CompatibilityInfo compatInfo, int flags, int userId) {
        boolean differentUser = UserHandle.myUserId() != userId;
        ResourcesManager resourcesManager = this.mResourcesManager;
        synchronized (resourcesManager) {
            LoadedApk packageInfo;
            WeakReference<LoadedApk> ref = differentUser ? null : ((flags & 1) != 0 ? this.mPackages.get(packageName) : this.mResourcePackages.get(packageName));
            LoadedApk loadedApk = packageInfo = ref != null ? (LoadedApk)ref.get() : null;
            if (packageInfo != null && (packageInfo.mResources == null || packageInfo.mResources.getAssets().isUpToDate())) {
                if (packageInfo.isSecurityViolation() && (flags & 2) == 0) {
                    throw new SecurityException("Requesting code from " + packageName + " to be run in process " + this.mBoundApplication.processName + "/" + this.mBoundApplication.appInfo.uid);
                }
                return packageInfo;
            }
        }
        ApplicationInfo ai = null;
        try {
            ai = ActivityThread.getPackageManager().getApplicationInfo(packageName, 0x10000400, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (ai != null) {
            return this.getPackageInfo(ai, compatInfo, flags);
        }
        return null;
    }

    public LoadedApk getPackageInfo(ApplicationInfo ai, CompatibilityInfo compatInfo, int flags) {
        boolean registerPackage;
        boolean includeCode = (flags & 1) != 0;
        boolean securityViolation = includeCode && ai.uid != 0 && ai.uid != 1000 && (this.mBoundApplication == null || !UserHandle.isSameApp(ai.uid, this.mBoundApplication.appInfo.uid));
        boolean bl = registerPackage = includeCode && (flags & 0x40000000) != 0;
        if ((flags & 3) == 1 && securityViolation) {
            String msg = "Requesting code from " + ai.packageName + " (with uid " + ai.uid + ")";
            if (this.mBoundApplication != null) {
                msg = msg + " to be run in process " + this.mBoundApplication.processName + " (with uid " + this.mBoundApplication.appInfo.uid + ")";
            }
            throw new SecurityException(msg);
        }
        return this.getPackageInfo(ai, compatInfo, null, securityViolation, includeCode, registerPackage);
    }

    public LoadedApk getPackageInfoNoCheck(ApplicationInfo ai, CompatibilityInfo compatInfo) {
        return this.getPackageInfo(ai, compatInfo, null, false, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedApk peekPackageInfo(String packageName, boolean includeCode) {
        ResourcesManager resourcesManager = this.mResourcesManager;
        synchronized (resourcesManager) {
            WeakReference<LoadedApk> ref = includeCode ? this.mPackages.get(packageName) : this.mResourcePackages.get(packageName);
            return ref != null ? (LoadedApk)ref.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadedApk getPackageInfo(ApplicationInfo aInfo, CompatibilityInfo compatInfo, ClassLoader baseLoader, boolean securityViolation, boolean includeCode, boolean registerPackage) {
        boolean differentUser = UserHandle.myUserId() != UserHandle.getUserId(aInfo.uid);
        ResourcesManager resourcesManager = this.mResourcesManager;
        synchronized (resourcesManager) {
            LoadedApk packageInfo;
            WeakReference<LoadedApk> ref = differentUser ? null : (includeCode ? this.mPackages.get(aInfo.packageName) : this.mResourcePackages.get(aInfo.packageName));
            LoadedApk loadedApk = packageInfo = ref != null ? (LoadedApk)ref.get() : null;
            if (packageInfo == null || packageInfo.mResources != null && !packageInfo.mResources.getAssets().isUpToDate()) {
                packageInfo = new LoadedApk(this, aInfo, compatInfo, baseLoader, securityViolation, includeCode && (aInfo.flags & 4) != 0, registerPackage);
                if (this.mSystemThread && "android".equals(aInfo.packageName)) {
                    packageInfo.installSystemApplicationInfo(aInfo, this.getSystemContext().mPackageInfo.getClassLoader());
                }
                if (!differentUser) {
                    if (includeCode) {
                        this.mPackages.put(aInfo.packageName, new WeakReference<LoadedApk>(packageInfo));
                    } else {
                        this.mResourcePackages.put(aInfo.packageName, new WeakReference<LoadedApk>(packageInfo));
                    }
                }
            }
            return packageInfo;
        }
    }

    ActivityThread() {
        this.mResourcesManager = ResourcesManager.getInstance();
    }

    public ApplicationThread getApplicationThread() {
        return this.mAppThread;
    }

    public Instrumentation getInstrumentation() {
        return this.mInstrumentation;
    }

    public boolean isProfiling() {
        return this.mProfiler != null && this.mProfiler.profileFile != null && this.mProfiler.profileFd == null;
    }

    public String getProfileFilePath() {
        return this.mProfiler.profileFile;
    }

    public Looper getLooper() {
        return this.mLooper;
    }

    public Application getApplication() {
        return this.mInitialApplication;
    }

    public String getProcessName() {
        return this.mBoundApplication.processName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextImpl getSystemContext() {
        ActivityThread activityThread = this;
        synchronized (activityThread) {
            if (this.mSystemContext == null) {
                this.mSystemContext = ContextImpl.createSystemContext(this);
            }
            return this.mSystemContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installSystemApplicationInfo(ApplicationInfo info, ClassLoader classLoader) {
        ActivityThread activityThread = this;
        synchronized (activityThread) {
            this.getSystemContext().installSystemApplicationInfo(info, classLoader);
            this.mProfiler = new Profiler();
        }
    }

    void ensureJitEnabled() {
        if (!this.mJitEnabled) {
            this.mJitEnabled = true;
            VMRuntime.getRuntime().startJitCompilation();
        }
    }

    void scheduleGcIdler() {
        if (!this.mGcIdlerScheduled) {
            this.mGcIdlerScheduled = true;
            Looper.myQueue().addIdleHandler(this.mGcIdler);
        }
        this.mH.removeMessages(120);
    }

    void unscheduleGcIdler() {
        if (this.mGcIdlerScheduled) {
            this.mGcIdlerScheduled = false;
            Looper.myQueue().removeIdleHandler(this.mGcIdler);
        }
        this.mH.removeMessages(120);
    }

    void doGcIfNeeded() {
        this.mGcIdlerScheduled = false;
        long now = SystemClock.uptimeMillis();
        if (BinderInternal.getLastGcTime() + 5000L < now) {
            BinderInternal.forceGc("bg");
        }
    }

    static void printRow(PrintWriter pw, String format, Object ... objs) {
        pw.println(String.format(format, objs));
    }

    public static void dumpMemInfoTable(PrintWriter pw, Debug.MemoryInfo memInfo, boolean checkin, boolean dumpFullInfo, boolean dumpDalvik, boolean dumpSummaryOnly, int pid, String processName, long nativeMax, long nativeAllocated, long nativeFree, long dalvikMax, long dalvikAllocated, long dalvikFree) {
        if (checkin) {
            pw.print(4);
            pw.print(',');
            pw.print(pid);
            pw.print(',');
            pw.print(processName);
            pw.print(',');
            pw.print(nativeMax);
            pw.print(',');
            pw.print(dalvikMax);
            pw.print(',');
            pw.print("N/A,");
            pw.print(nativeMax + dalvikMax);
            pw.print(',');
            pw.print(nativeAllocated);
            pw.print(',');
            pw.print(dalvikAllocated);
            pw.print(',');
            pw.print("N/A,");
            pw.print(nativeAllocated + dalvikAllocated);
            pw.print(',');
            pw.print(nativeFree);
            pw.print(',');
            pw.print(dalvikFree);
            pw.print(',');
            pw.print("N/A,");
            pw.print(nativeFree + dalvikFree);
            pw.print(',');
            pw.print(memInfo.nativePss);
            pw.print(',');
            pw.print(memInfo.dalvikPss);
            pw.print(',');
            pw.print(memInfo.otherPss);
            pw.print(',');
            pw.print(memInfo.getTotalPss());
            pw.print(',');
            pw.print(memInfo.nativeSwappablePss);
            pw.print(',');
            pw.print(memInfo.dalvikSwappablePss);
            pw.print(',');
            pw.print(memInfo.otherSwappablePss);
            pw.print(',');
            pw.print(memInfo.getTotalSwappablePss());
            pw.print(',');
            pw.print(memInfo.nativeSharedDirty);
            pw.print(',');
            pw.print(memInfo.dalvikSharedDirty);
            pw.print(',');
            pw.print(memInfo.otherSharedDirty);
            pw.print(',');
            pw.print(memInfo.getTotalSharedDirty());
            pw.print(',');
            pw.print(memInfo.nativeSharedClean);
            pw.print(',');
            pw.print(memInfo.dalvikSharedClean);
            pw.print(',');
            pw.print(memInfo.otherSharedClean);
            pw.print(',');
            pw.print(memInfo.getTotalSharedClean());
            pw.print(',');
            pw.print(memInfo.nativePrivateDirty);
            pw.print(',');
            pw.print(memInfo.dalvikPrivateDirty);
            pw.print(',');
            pw.print(memInfo.otherPrivateDirty);
            pw.print(',');
            pw.print(memInfo.getTotalPrivateDirty());
            pw.print(',');
            pw.print(memInfo.nativePrivateClean);
            pw.print(',');
            pw.print(memInfo.dalvikPrivateClean);
            pw.print(',');
            pw.print(memInfo.otherPrivateClean);
            pw.print(',');
            pw.print(memInfo.getTotalPrivateClean());
            pw.print(',');
            pw.print(memInfo.nativeSwappedOut);
            pw.print(',');
            pw.print(memInfo.dalvikSwappedOut);
            pw.print(',');
            pw.print(memInfo.otherSwappedOut);
            pw.print(',');
            pw.print(memInfo.getTotalSwappedOut());
            pw.print(',');
            if (memInfo.hasSwappedOutPss) {
                pw.print(memInfo.nativeSwappedOutPss);
                pw.print(',');
                pw.print(memInfo.dalvikSwappedOutPss);
                pw.print(',');
                pw.print(memInfo.otherSwappedOutPss);
                pw.print(',');
                pw.print(memInfo.getTotalSwappedOutPss());
                pw.print(',');
            } else {
                pw.print("N/A,");
                pw.print("N/A,");
                pw.print("N/A,");
                pw.print("N/A,");
            }
            for (int i = 0; i < 17; ++i) {
                pw.print(Debug.MemoryInfo.getOtherLabel(i));
                pw.print(',');
                pw.print(memInfo.getOtherPss(i));
                pw.print(',');
                pw.print(memInfo.getOtherSwappablePss(i));
                pw.print(',');
                pw.print(memInfo.getOtherSharedDirty(i));
                pw.print(',');
                pw.print(memInfo.getOtherSharedClean(i));
                pw.print(',');
                pw.print(memInfo.getOtherPrivateDirty(i));
                pw.print(',');
                pw.print(memInfo.getOtherPrivateClean(i));
                pw.print(',');
                pw.print(memInfo.getOtherSwappedOut(i));
                pw.print(',');
                if (memInfo.hasSwappedOutPss) {
                    pw.print(memInfo.getOtherSwappedOutPss(i));
                    pw.print(',');
                    continue;
                }
                pw.print("N/A,");
            }
            return;
        }
        if (!dumpSummaryOnly) {
            int mySwappedOutPss;
            int mySwappedOut;
            int myPrivateClean;
            int mySharedClean;
            int myPrivateDirty;
            int mySharedDirty;
            int mySwappablePss;
            int myPss;
            int i;
            if (dumpFullInfo) {
                ActivityThread.printRow(pw, HEAP_FULL_COLUMN, "", "Pss", "Pss", "Shared", "Private", "Shared", "Private", memInfo.hasSwappedOutPss ? "SwapPss" : "Swap", "Heap", "Heap", "Heap");
                ActivityThread.printRow(pw, HEAP_FULL_COLUMN, "", "Total", "Clean", "Dirty", "Dirty", "Clean", "Clean", "Dirty", "Size", "Alloc", "Free");
                ActivityThread.printRow(pw, HEAP_FULL_COLUMN, "", "------", "------", "------", "------", "------", "------", "------", "------", "------", "------");
                ActivityThread.printRow(pw, HEAP_FULL_COLUMN, "Native Heap", memInfo.nativePss, memInfo.nativeSwappablePss, memInfo.nativeSharedDirty, memInfo.nativePrivateDirty, memInfo.nativeSharedClean, memInfo.nativePrivateClean, memInfo.hasSwappedOutPss ? memInfo.nativeSwappedOut : memInfo.nativeSwappedOutPss, nativeMax, nativeAllocated, nativeFree);
                ActivityThread.printRow(pw, HEAP_FULL_COLUMN, "Dalvik Heap", memInfo.dalvikPss, memInfo.dalvikSwappablePss, memInfo.dalvikSharedDirty, memInfo.dalvikPrivateDirty, memInfo.dalvikSharedClean, memInfo.dalvikPrivateClean, memInfo.hasSwappedOutPss ? memInfo.dalvikSwappedOut : memInfo.dalvikSwappedOutPss, dalvikMax, dalvikAllocated, dalvikFree);
            } else {
                ActivityThread.printRow(pw, HEAP_COLUMN, "", "Pss", "Private", "Private", memInfo.hasSwappedOutPss ? "SwapPss" : "Swap", "Heap", "Heap", "Heap");
                ActivityThread.printRow(pw, HEAP_COLUMN, "", "Total", "Dirty", "Clean", "Dirty", "Size", "Alloc", "Free");
                ActivityThread.printRow(pw, HEAP_COLUMN, "", "------", "------", "------", "------", "------", "------", "------", "------");
                ActivityThread.printRow(pw, HEAP_COLUMN, "Native Heap", memInfo.nativePss, memInfo.nativePrivateDirty, memInfo.nativePrivateClean, memInfo.hasSwappedOutPss ? memInfo.nativeSwappedOutPss : memInfo.nativeSwappedOut, nativeMax, nativeAllocated, nativeFree);
                ActivityThread.printRow(pw, HEAP_COLUMN, "Dalvik Heap", memInfo.dalvikPss, memInfo.dalvikPrivateDirty, memInfo.dalvikPrivateClean, memInfo.hasSwappedOutPss ? memInfo.dalvikSwappedOutPss : memInfo.dalvikSwappedOut, dalvikMax, dalvikAllocated, dalvikFree);
            }
            int otherPss = memInfo.otherPss;
            int otherSwappablePss = memInfo.otherSwappablePss;
            int otherSharedDirty = memInfo.otherSharedDirty;
            int otherPrivateDirty = memInfo.otherPrivateDirty;
            int otherSharedClean = memInfo.otherSharedClean;
            int otherPrivateClean = memInfo.otherPrivateClean;
            int otherSwappedOut = memInfo.otherSwappedOut;
            int otherSwappedOutPss = memInfo.otherSwappedOutPss;
            for (i = 0; i < 17; ++i) {
                myPss = memInfo.getOtherPss(i);
                mySwappablePss = memInfo.getOtherSwappablePss(i);
                mySharedDirty = memInfo.getOtherSharedDirty(i);
                myPrivateDirty = memInfo.getOtherPrivateDirty(i);
                mySharedClean = memInfo.getOtherSharedClean(i);
                myPrivateClean = memInfo.getOtherPrivateClean(i);
                mySwappedOut = memInfo.getOtherSwappedOut(i);
                mySwappedOutPss = memInfo.getOtherSwappedOutPss(i);
                if (myPss == 0 && mySharedDirty == 0 && myPrivateDirty == 0 && mySharedClean == 0 && myPrivateClean == 0 && (memInfo.hasSwappedOutPss ? mySwappedOutPss : mySwappedOut) == 0) continue;
                if (dumpFullInfo) {
                    ActivityThread.printRow(pw, HEAP_FULL_COLUMN, Debug.MemoryInfo.getOtherLabel(i), myPss, mySwappablePss, mySharedDirty, myPrivateDirty, mySharedClean, myPrivateClean, memInfo.hasSwappedOutPss ? mySwappedOutPss : mySwappedOut, "", "", "");
                } else {
                    ActivityThread.printRow(pw, HEAP_COLUMN, Debug.MemoryInfo.getOtherLabel(i), myPss, myPrivateDirty, myPrivateClean, memInfo.hasSwappedOutPss ? mySwappedOutPss : mySwappedOut, "", "", "");
                }
                otherPss -= myPss;
                otherSwappablePss -= mySwappablePss;
                otherSharedDirty -= mySharedDirty;
                otherPrivateDirty -= myPrivateDirty;
                otherSharedClean -= mySharedClean;
                otherPrivateClean -= myPrivateClean;
                otherSwappedOut -= mySwappedOut;
                otherSwappedOutPss -= mySwappedOutPss;
            }
            if (dumpFullInfo) {
                ActivityThread.printRow(pw, HEAP_FULL_COLUMN, "Unknown", otherPss, otherSwappablePss, otherSharedDirty, otherPrivateDirty, otherSharedClean, otherPrivateClean, memInfo.hasSwappedOutPss ? otherSwappedOutPss : otherSwappedOut, "", "", "");
                ActivityThread.printRow(pw, HEAP_FULL_COLUMN, "TOTAL", memInfo.getTotalPss(), memInfo.getTotalSwappablePss(), memInfo.getTotalSharedDirty(), memInfo.getTotalPrivateDirty(), memInfo.getTotalSharedClean(), memInfo.getTotalPrivateClean(), memInfo.hasSwappedOutPss ? memInfo.getTotalSwappedOutPss() : memInfo.getTotalSwappedOut(), nativeMax + dalvikMax, nativeAllocated + dalvikAllocated, nativeFree + dalvikFree);
            } else {
                ActivityThread.printRow(pw, HEAP_COLUMN, "Unknown", otherPss, otherPrivateDirty, otherPrivateClean, memInfo.hasSwappedOutPss ? otherSwappedOutPss : otherSwappedOut, "", "", "");
                ActivityThread.printRow(pw, HEAP_COLUMN, "TOTAL", memInfo.getTotalPss(), memInfo.getTotalPrivateDirty(), memInfo.getTotalPrivateClean(), memInfo.hasSwappedOutPss ? memInfo.getTotalSwappedOutPss() : memInfo.getTotalSwappedOut(), nativeMax + dalvikMax, nativeAllocated + dalvikAllocated, nativeFree + dalvikFree);
            }
            if (dumpDalvik) {
                pw.println(" ");
                pw.println(" Dalvik Details");
                for (i = 17; i < 25; ++i) {
                    myPss = memInfo.getOtherPss(i);
                    mySwappablePss = memInfo.getOtherSwappablePss(i);
                    mySharedDirty = memInfo.getOtherSharedDirty(i);
                    myPrivateDirty = memInfo.getOtherPrivateDirty(i);
                    mySharedClean = memInfo.getOtherSharedClean(i);
                    myPrivateClean = memInfo.getOtherPrivateClean(i);
                    mySwappedOut = memInfo.getOtherSwappedOut(i);
                    mySwappedOutPss = memInfo.getOtherSwappedOutPss(i);
                    if (myPss == 0 && mySharedDirty == 0 && myPrivateDirty == 0 && mySharedClean == 0 && myPrivateClean == 0 && (memInfo.hasSwappedOutPss ? mySwappedOutPss : mySwappedOut) == 0) continue;
                    if (dumpFullInfo) {
                        ActivityThread.printRow(pw, HEAP_FULL_COLUMN, Debug.MemoryInfo.getOtherLabel(i), myPss, mySwappablePss, mySharedDirty, myPrivateDirty, mySharedClean, myPrivateClean, memInfo.hasSwappedOutPss ? mySwappedOutPss : mySwappedOut, "", "", "");
                        continue;
                    }
                    ActivityThread.printRow(pw, HEAP_COLUMN, Debug.MemoryInfo.getOtherLabel(i), myPss, myPrivateDirty, myPrivateClean, memInfo.hasSwappedOutPss ? mySwappedOutPss : mySwappedOut, "", "", "");
                }
            }
        }
        pw.println(" ");
        pw.println(" App Summary");
        ActivityThread.printRow(pw, ONE_COUNT_COLUMN_HEADER, "", "Pss(KB)");
        ActivityThread.printRow(pw, ONE_COUNT_COLUMN_HEADER, "", "------");
        ActivityThread.printRow(pw, ONE_COUNT_COLUMN, "Java Heap:", memInfo.getSummaryJavaHeap());
        ActivityThread.printRow(pw, ONE_COUNT_COLUMN, "Native Heap:", memInfo.getSummaryNativeHeap());
        ActivityThread.printRow(pw, ONE_COUNT_COLUMN, "Code:", memInfo.getSummaryCode());
        ActivityThread.printRow(pw, ONE_COUNT_COLUMN, "Stack:", memInfo.getSummaryStack());
        ActivityThread.printRow(pw, ONE_COUNT_COLUMN, "Graphics:", memInfo.getSummaryGraphics());
        ActivityThread.printRow(pw, ONE_COUNT_COLUMN, "Private Other:", memInfo.getSummaryPrivateOther());
        ActivityThread.printRow(pw, ONE_COUNT_COLUMN, "System:", memInfo.getSummarySystem());
        pw.println(" ");
        if (memInfo.hasSwappedOutPss) {
            ActivityThread.printRow(pw, TWO_COUNT_COLUMNS, "TOTAL:", memInfo.getSummaryTotalPss(), "TOTAL SWAP PSS:", memInfo.getSummaryTotalSwapPss());
        } else {
            ActivityThread.printRow(pw, TWO_COUNT_COLUMNS, "TOTAL:", memInfo.getSummaryTotalPss(), "TOTAL SWAP (KB):", memInfo.getSummaryTotalSwap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnActivityPausedListener(Activity activity, OnActivityPausedListener listener) {
        ArrayMap<Activity, ArrayList<OnActivityPausedListener>> arrayMap = this.mOnPauseListeners;
        synchronized (arrayMap) {
            ArrayList<OnActivityPausedListener> list = this.mOnPauseListeners.get(activity);
            if (list == null) {
                list = new ArrayList();
                this.mOnPauseListeners.put(activity, list);
            }
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnActivityPausedListener(Activity activity, OnActivityPausedListener listener) {
        ArrayMap<Activity, ArrayList<OnActivityPausedListener>> arrayMap = this.mOnPauseListeners;
        synchronized (arrayMap) {
            ArrayList<OnActivityPausedListener> list = this.mOnPauseListeners.get(activity);
            if (list != null) {
                list.remove(listener);
            }
        }
    }

    public ActivityInfo resolveActivityInfo(Intent intent) {
        ActivityInfo aInfo = intent.resolveActivityInfo(this.mInitialApplication.getPackageManager(), 1024);
        if (aInfo == null) {
            Instrumentation.checkStartActivityResult(-2, intent);
        }
        return aInfo;
    }

    public Activity startActivityNow(Activity parent, String id2, Intent intent, ActivityInfo activityInfo, IBinder token, Bundle state, Activity.NonConfigurationInstances lastNonConfigurationInstances) {
        ActivityClientRecord r = new ActivityClientRecord();
        r.token = token;
        r.ident = 0;
        r.intent = intent;
        r.state = state;
        r.parent = parent;
        r.embeddedID = id2;
        r.activityInfo = activityInfo;
        r.lastNonConfigurationInstances = lastNonConfigurationInstances;
        return this.performLaunchActivity(r, null);
    }

    public Activity getActivity(IBinder token) {
        return this.mActivities.get((Object)token).activity;
    }

    public void sendActivityResult(IBinder token, String id2, int requestCode, int resultCode, Intent data) {
        ArrayList<ResultInfo> list = new ArrayList<ResultInfo>();
        list.add(new ResultInfo(id2, requestCode, resultCode, data));
        this.mAppThread.scheduleSendResult(token, list);
    }

    private void sendMessage(int what, Object obj) {
        this.sendMessage(what, obj, 0, 0, false);
    }

    private void sendMessage(int what, Object obj, int arg1) {
        this.sendMessage(what, obj, arg1, 0, false);
    }

    private void sendMessage(int what, Object obj, int arg1, int arg2) {
        this.sendMessage(what, obj, arg1, arg2, false);
    }

    private void sendMessage(int what, Object obj, int arg1, int arg2, boolean async) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.obj = obj;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        if (async) {
            msg.setAsynchronous(true);
        }
        this.mH.sendMessage(msg);
    }

    private void sendMessage(int what, Object obj, int arg1, int arg2, int seq) {
        Message msg = Message.obtain();
        msg.what = what;
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = obj;
        args.argi1 = arg1;
        args.argi2 = arg2;
        args.argi3 = seq;
        msg.obj = args;
        this.mH.sendMessage(msg);
    }

    void scheduleContextCleanup(ContextImpl context, String who, String what) {
        ContextCleanupInfo cci = new ContextCleanupInfo();
        cci.context = context;
        cci.who = who;
        cci.what = what;
        this.sendMessage(119, cci);
    }

    private Activity performLaunchActivity(ActivityClientRecord r, Intent customIntent) {
        Activity activity;
        block28: {
            ComponentName component;
            block27: {
                ActivityInfo aInfo = r.activityInfo;
                if (r.packageInfo == null) {
                    r.packageInfo = this.getPackageInfo(aInfo.applicationInfo, r.compatInfo, 1);
                }
                if ((component = r.intent.getComponent()) == null) {
                    component = r.intent.resolveActivity(this.mInitialApplication.getPackageManager());
                    r.intent.setComponent(component);
                }
                if (r.activityInfo.targetActivity != null) {
                    component = new ComponentName(r.activityInfo.packageName, r.activityInfo.targetActivity);
                }
                activity = null;
                try {
                    ClassLoader cl = r.packageInfo.getClassLoader();
                    activity = this.mInstrumentation.newActivity(cl, component.getClassName(), r.intent);
                    StrictMode.incrementExpectedActivityCount(activity.getClass());
                    r.intent.setExtrasClassLoader(cl);
                    r.intent.prepareToEnterProcess();
                    if (r.state != null) {
                        r.state.setClassLoader(cl);
                    }
                }
                catch (Exception e) {
                    if (this.mInstrumentation.onException(activity, e)) break block27;
                    throw new RuntimeException("Unable to instantiate activity " + component + ": " + e.toString(), e);
                }
            }
            try {
                Application app = r.packageInfo.makeApplication(false, this.mInstrumentation);
                if (activity != null) {
                    Context appContext = this.createBaseContextForActivity(r, activity);
                    CharSequence title = r.activityInfo.loadLabel(appContext.getPackageManager());
                    Configuration config = new Configuration(this.mCompatConfiguration);
                    if (r.overrideConfig != null) {
                        config.updateFrom(r.overrideConfig);
                    }
                    Window window = null;
                    if (r.mPendingRemoveWindow != null && r.mPreserveWindow) {
                        window = r.mPendingRemoveWindow;
                        r.mPendingRemoveWindow = null;
                        r.mPendingRemoveWindowManager = null;
                    }
                    activity.attach(appContext, this, this.getInstrumentation(), r.token, r.ident, app, r.intent, r.activityInfo, title, r.parent, r.embeddedID, r.lastNonConfigurationInstances, config, r.referrer, r.voiceInteractor, window);
                    if (customIntent != null) {
                        activity.mIntent = customIntent;
                    }
                    r.lastNonConfigurationInstances = null;
                    activity.mStartedActivity = false;
                    int theme = r.activityInfo.getThemeResource();
                    if (theme != 0) {
                        activity.setTheme(theme);
                    }
                    activity.mCalled = false;
                    if (r.isPersistable()) {
                        this.mInstrumentation.callActivityOnCreate(activity, r.state, r.persistentState);
                    } else {
                        this.mInstrumentation.callActivityOnCreate(activity, r.state);
                    }
                    if (!activity.mCalled) {
                        throw new SuperNotCalledException("Activity " + r.intent.getComponent().toShortString() + " did not call through to super.onCreate()");
                    }
                    r.activity = activity;
                    r.stopped = true;
                    if (!r.activity.mFinished) {
                        activity.performStart();
                        r.stopped = false;
                    }
                    if (!r.activity.mFinished) {
                        if (r.isPersistable()) {
                            if (r.state != null || r.persistentState != null) {
                                this.mInstrumentation.callActivityOnRestoreInstanceState(activity, r.state, r.persistentState);
                            }
                        } else if (r.state != null) {
                            this.mInstrumentation.callActivityOnRestoreInstanceState(activity, r.state);
                        }
                    }
                    if (!r.activity.mFinished) {
                        activity.mCalled = false;
                        if (r.isPersistable()) {
                            this.mInstrumentation.callActivityOnPostCreate(activity, r.state, r.persistentState);
                        } else {
                            this.mInstrumentation.callActivityOnPostCreate(activity, r.state);
                        }
                        if (!activity.mCalled) {
                            throw new SuperNotCalledException("Activity " + r.intent.getComponent().toShortString() + " did not call through to super.onPostCreate()");
                        }
                    }
                }
                r.paused = true;
                this.mActivities.put(r.token, r);
            }
            catch (SuperNotCalledException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.mInstrumentation.onException(activity, e)) break block28;
                throw new RuntimeException("Unable to start activity " + component + ": " + e.toString(), e);
            }
        }
        return activity;
    }

    private Context createBaseContextForActivity(ActivityClientRecord r, Activity activity) {
        int displayId = 0;
        try {
            displayId = ActivityManagerNative.getDefault().getActivityDisplayId(r.token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        ContextImpl appContext = ContextImpl.createActivityContext(this, r.packageInfo, r.token, displayId, r.overrideConfig);
        appContext.setOuterContext(activity);
        Context baseContext = appContext;
        DisplayManagerGlobal dm = DisplayManagerGlobal.getInstance();
        String pkgName = SystemProperties.get("debug.second-display.pkg");
        if (pkgName != null && !pkgName.isEmpty() && r.packageInfo.mPackageName.contains(pkgName)) {
            for (int id2 : dm.getDisplayIds()) {
                if (id2 == 0) continue;
                Display display = dm.getCompatibleDisplay(id2, appContext.getDisplayAdjustments(id2));
                baseContext = appContext.createDisplayContext(display);
                break;
            }
        }
        return baseContext;
    }

    private void handleLaunchActivity(ActivityClientRecord r, Intent customIntent, String reason) {
        this.unscheduleGcIdler();
        this.mSomeActivitiesChanged = true;
        if (r.profilerInfo != null) {
            this.mProfiler.setProfiler(r.profilerInfo);
            this.mProfiler.startProfiling();
        }
        this.handleConfigurationChanged(null, null);
        WindowManagerGlobal.initialize();
        Activity a = this.performLaunchActivity(r, customIntent);
        if (a != null) {
            r.createdConfig = new Configuration(this.mConfiguration);
            this.reportSizeConfigurations(r);
            Bundle oldState = r.state;
            this.handleResumeActivity(r.token, false, r.isForward, !r.activity.mFinished && !r.startsNotResumed, r.lastProcessedSeq, reason);
            if (!r.activity.mFinished && r.startsNotResumed) {
                this.performPauseActivityIfNeeded(r, reason);
                if (r.isPreHoneycomb()) {
                    r.state = oldState;
                }
            }
        } else {
            try {
                ActivityManagerNative.getDefault().finishActivity(r.token, 0, null, 0);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }
    }

    private void reportSizeConfigurations(ActivityClientRecord r) {
        Configuration[] configurations = r.activity.getResources().getSizeConfigurations();
        if (configurations == null) {
            return;
        }
        SparseIntArray horizontal = new SparseIntArray();
        SparseIntArray vertical = new SparseIntArray();
        SparseIntArray smallest = new SparseIntArray();
        for (int i = configurations.length - 1; i >= 0; --i) {
            Configuration config = configurations[i];
            if (config.screenHeightDp != 0) {
                vertical.put(config.screenHeightDp, 0);
            }
            if (config.screenWidthDp != 0) {
                horizontal.put(config.screenWidthDp, 0);
            }
            if (config.smallestScreenWidthDp == 0) continue;
            smallest.put(config.smallestScreenWidthDp, 0);
        }
        try {
            ActivityManagerNative.getDefault().reportSizeConfigurations(r.token, horizontal.copyKeys(), vertical.copyKeys(), smallest.copyKeys());
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private void deliverNewIntents(ActivityClientRecord r, List<ReferrerIntent> intents) {
        int N = intents.size();
        for (int i = 0; i < N; ++i) {
            ReferrerIntent intent = intents.get(i);
            intent.setExtrasClassLoader(r.activity.getClassLoader());
            intent.prepareToEnterProcess();
            r.activity.mFragments.noteStateNotSaved();
            this.mInstrumentation.callActivityOnNewIntent(r.activity, intent);
        }
    }

    public void performNewIntents(IBinder token, List<ReferrerIntent> intents) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r != null) {
            boolean resumed;
            boolean bl = resumed = !r.paused;
            if (resumed) {
                r.activity.mTemporaryPause = true;
                this.mInstrumentation.callActivityOnPause(r.activity);
            }
            this.deliverNewIntents(r, intents);
            if (resumed) {
                r.activity.performResume();
                r.activity.mTemporaryPause = false;
            }
        }
    }

    private void handleNewIntent(NewIntentData data) {
        this.performNewIntents(data.token, data.intents);
    }

    public void handleRequestAssistContextExtras(RequestAssistContextExtras cmd) {
        AssistStructure structure;
        if (this.mLastSessionId != cmd.sessionId) {
            this.mLastSessionId = cmd.sessionId;
            for (int i = this.mLastAssistStructures.size() - 1; i >= 0; --i) {
                structure = (AssistStructure)this.mLastAssistStructures.get(i).get();
                if (structure != null) {
                    structure.clearSendChannel();
                }
                this.mLastAssistStructures.remove(i);
            }
        }
        Bundle data = new Bundle();
        structure = null;
        AssistContent content = new AssistContent();
        ActivityClientRecord r = this.mActivities.get(cmd.activityToken);
        Uri referrer = null;
        if (r != null) {
            r.activity.getApplication().dispatchOnProvideAssistData(r.activity, data);
            r.activity.onProvideAssistData(data);
            referrer = r.activity.onProvideReferrer();
            if (cmd.requestType == 1) {
                structure = new AssistStructure(r.activity);
                Intent activityIntent = r.activity.getIntent();
                if (activityIntent != null && (r.window == null || (r.window.getAttributes().flags & 0x2000) == 0)) {
                    Intent intent = new Intent(activityIntent);
                    intent.setFlags(intent.getFlags() & 0xFFFFFFBD);
                    intent.removeUnsafeExtras();
                    content.setDefaultIntent(intent);
                } else {
                    content.setDefaultIntent(new Intent());
                }
                r.activity.onProvideAssistContent(content);
            }
        }
        if (structure == null) {
            structure = new AssistStructure();
        }
        this.mLastAssistStructures.add(new WeakReference<AssistStructure>(structure));
        IActivityManager mgr = ActivityManagerNative.getDefault();
        try {
            mgr.reportAssistContextExtras(cmd.requestToken, data, structure, content, referrer);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void handleTranslucentConversionComplete(IBinder token, boolean drawComplete) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r != null) {
            r.activity.onTranslucentConversionComplete(drawComplete);
        }
    }

    public void onNewActivityOptions(IBinder token, ActivityOptions options) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r != null) {
            r.activity.onNewActivityOptions(options);
        }
    }

    public void handleCancelVisibleBehind(IBinder token) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r != null) {
            this.mSomeActivitiesChanged = true;
            Activity activity = r.activity;
            if (activity.mVisibleBehind) {
                activity.mCalled = false;
                activity.onVisibleBehindCanceled();
                if (!activity.mCalled) {
                    throw new SuperNotCalledException("Activity " + activity.getLocalClassName() + " did not call through to super.onVisibleBehindCanceled()");
                }
                activity.mVisibleBehind = false;
            }
        }
        try {
            ActivityManagerNative.getDefault().backgroundResourcesReleased(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void handleOnBackgroundVisibleBehindChanged(IBinder token, boolean visible) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r != null) {
            r.activity.onBackgroundVisibleBehindChanged(visible);
        }
    }

    public void handleInstallProvider(ProviderInfo info) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            this.installContentProviders(this.mInitialApplication, Lists.newArrayList(info));
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
    }

    private void handleEnterAnimationComplete(IBinder token) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r != null) {
            r.activity.dispatchEnterAnimationComplete();
        }
    }

    private void handleStartBinderTracking() {
        Binder.enableTracing();
    }

    private void handleStopBinderTrackingAndDump(ParcelFileDescriptor fd) {
        try {
            Binder.disableTracing();
            Binder.getTransactionTracker().writeTracesToFile(fd);
        }
        finally {
            IoUtils.closeQuietly(fd);
            Binder.getTransactionTracker().clearTraces();
        }
    }

    private void handleMultiWindowModeChanged(IBinder token, boolean isInMultiWindowMode) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r != null) {
            r.activity.dispatchMultiWindowModeChanged(isInMultiWindowMode);
        }
    }

    private void handlePictureInPictureModeChanged(IBinder token, boolean isInPipMode) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r != null) {
            r.activity.dispatchPictureInPictureModeChanged(isInPipMode);
        }
    }

    private void handleLocalVoiceInteractionStarted(IBinder token, IVoiceInteractor interactor) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r != null) {
            r.voiceInteractor = interactor;
            r.activity.setVoiceInteractor(interactor);
            if (interactor == null) {
                r.activity.onLocalVoiceInteractionStopped();
            } else {
                r.activity.onLocalVoiceInteractionStarted();
            }
        }
    }

    public static Intent getIntentBeingBroadcast() {
        return sCurrentBroadcastIntent.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReceiver(ReceiverData data) {
        BroadcastReceiver receiver;
        this.unscheduleGcIdler();
        String component = data.intent.getComponent().getClassName();
        LoadedApk packageInfo = this.getPackageInfoNoCheck(data.info.applicationInfo, data.compatInfo);
        IActivityManager mgr = ActivityManagerNative.getDefault();
        try {
            ClassLoader cl = packageInfo.getClassLoader();
            data.intent.setExtrasClassLoader(cl);
            data.intent.prepareToEnterProcess();
            data.setExtrasClassLoader(cl);
            receiver = (BroadcastReceiver)cl.loadClass(component).newInstance();
        }
        catch (Exception e) {
            data.sendFinished(mgr);
            throw new RuntimeException("Unable to instantiate receiver " + component + ": " + e.toString(), e);
        }
        try {
            Application app = packageInfo.makeApplication(false, this.mInstrumentation);
            ContextImpl context = (ContextImpl)app.getBaseContext();
            sCurrentBroadcastIntent.set(data.intent);
            receiver.setPendingResult(data);
            receiver.onReceive(context.getReceiverRestrictedContext(), data.intent);
        }
        catch (Exception e) {
            data.sendFinished(mgr);
            if (!this.mInstrumentation.onException(receiver, e)) {
                throw new RuntimeException("Unable to start receiver " + component + ": " + e.toString(), e);
            }
        }
        finally {
            sCurrentBroadcastIntent.set(null);
        }
        if (receiver.getPendingResult() != null) {
            data.finish();
        }
    }

    private void handleCreateBackupAgent(CreateBackupAgentData data) {
        try {
            PackageInfo requestedPackage = ActivityThread.getPackageManager().getPackageInfo(data.appInfo.packageName, 0, UserHandle.myUserId());
            if (requestedPackage.applicationInfo.uid != Process.myUid()) {
                Slog.w(TAG, "Asked to instantiate non-matching package " + data.appInfo.packageName);
                return;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.unscheduleGcIdler();
        LoadedApk packageInfo = this.getPackageInfoNoCheck(data.appInfo, data.compatInfo);
        String packageName = packageInfo.mPackageName;
        if (packageName == null) {
            Slog.d(TAG, "Asked to create backup agent for nonexistent package");
            return;
        }
        String classname = data.appInfo.backupAgentName;
        if (classname == null && (data.backupMode == 1 || data.backupMode == 3)) {
            classname = "android.app.backup.FullBackupAgent";
        }
        try {
            IBinder binder;
            block13: {
                binder = null;
                BackupAgent agent = this.mBackupAgents.get(packageName);
                if (agent != null) {
                    binder = agent.onBind();
                } else {
                    try {
                        ClassLoader cl = packageInfo.getClassLoader();
                        agent = (BackupAgent)cl.loadClass(classname).newInstance();
                        ContextImpl context = ContextImpl.createAppContext(this, packageInfo);
                        context.setOuterContext(agent);
                        agent.attach(context);
                        agent.onCreate();
                        binder = agent.onBind();
                        this.mBackupAgents.put(packageName, agent);
                    }
                    catch (Exception e) {
                        Slog.e(TAG, "Agent threw during creation: " + e);
                        if (data.backupMode == 2 || data.backupMode == 3) break block13;
                        throw e;
                    }
                }
            }
            try {
                ActivityManagerNative.getDefault().backupAgentCreated(packageName, binder);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create BackupAgent " + classname + ": " + e.toString(), e);
        }
    }

    private void handleDestroyBackupAgent(CreateBackupAgentData data) {
        LoadedApk packageInfo = this.getPackageInfoNoCheck(data.appInfo, data.compatInfo);
        String packageName = packageInfo.mPackageName;
        BackupAgent agent = this.mBackupAgents.get(packageName);
        if (agent != null) {
            try {
                agent.onDestroy();
            }
            catch (Exception e) {
                Slog.w(TAG, "Exception thrown in onDestroy by backup agent of " + data.appInfo);
                e.printStackTrace();
            }
            this.mBackupAgents.remove(packageName);
        } else {
            Slog.w(TAG, "Attempt to destroy unknown backup agent " + data);
        }
    }

    private void handleCreateService(CreateServiceData data) {
        block7: {
            Service service;
            LoadedApk packageInfo;
            block6: {
                this.unscheduleGcIdler();
                packageInfo = this.getPackageInfoNoCheck(data.info.applicationInfo, data.compatInfo);
                service = null;
                try {
                    ClassLoader cl = packageInfo.getClassLoader();
                    service = (Service)cl.loadClass(data.info.name).newInstance();
                }
                catch (Exception e) {
                    if (this.mInstrumentation.onException(service, e)) break block6;
                    throw new RuntimeException("Unable to instantiate service " + data.info.name + ": " + e.toString(), e);
                }
            }
            try {
                ContextImpl context = ContextImpl.createAppContext(this, packageInfo);
                context.setOuterContext(service);
                Application app = packageInfo.makeApplication(false, this.mInstrumentation);
                service.attach(context, this, data.info.name, data.token, app, ActivityManagerNative.getDefault());
                service.onCreate();
                this.mServices.put(data.token, service);
                try {
                    ActivityManagerNative.getDefault().serviceDoneExecuting(data.token, 0, 0, 0);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            catch (Exception e) {
                if (this.mInstrumentation.onException(service, e)) break block7;
                throw new RuntimeException("Unable to create service " + data.info.name + ": " + e.toString(), e);
            }
        }
    }

    private void handleBindService(BindServiceData data) {
        block7: {
            Service s = this.mServices.get(data.token);
            if (s != null) {
                try {
                    data.intent.setExtrasClassLoader(s.getClassLoader());
                    data.intent.prepareToEnterProcess();
                    try {
                        if (!data.rebind) {
                            IBinder binder = s.onBind(data.intent);
                            ActivityManagerNative.getDefault().publishService(data.token, data.intent, binder);
                        } else {
                            s.onRebind(data.intent);
                            ActivityManagerNative.getDefault().serviceDoneExecuting(data.token, 0, 0, 0);
                        }
                        this.ensureJitEnabled();
                    }
                    catch (RemoteException ex) {
                        throw ex.rethrowFromSystemServer();
                    }
                }
                catch (Exception e) {
                    if (this.mInstrumentation.onException(s, e)) break block7;
                    throw new RuntimeException("Unable to bind to service " + s + " with " + data.intent + ": " + e.toString(), e);
                }
            }
        }
    }

    private void handleUnbindService(BindServiceData data) {
        block7: {
            Service s = this.mServices.get(data.token);
            if (s != null) {
                try {
                    data.intent.setExtrasClassLoader(s.getClassLoader());
                    data.intent.prepareToEnterProcess();
                    boolean doRebind = s.onUnbind(data.intent);
                    try {
                        if (doRebind) {
                            ActivityManagerNative.getDefault().unbindFinished(data.token, data.intent, doRebind);
                        } else {
                            ActivityManagerNative.getDefault().serviceDoneExecuting(data.token, 0, 0, 0);
                        }
                    }
                    catch (RemoteException ex) {
                        throw ex.rethrowFromSystemServer();
                    }
                }
                catch (Exception e) {
                    if (this.mInstrumentation.onException(s, e)) break block7;
                    throw new RuntimeException("Unable to unbind to service " + s + " with " + data.intent + ": " + e.toString(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDumpService(DumpComponentInfo info) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            Service s = this.mServices.get(info.token);
            if (s != null) {
                FastPrintWriter pw = new FastPrintWriter(new FileOutputStream(info.fd.getFileDescriptor()));
                s.dump(info.fd.getFileDescriptor(), pw, info.args);
                ((PrintWriter)pw).flush();
            }
        }
        finally {
            IoUtils.closeQuietly(info.fd);
            StrictMode.setThreadPolicy(oldPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDumpActivity(DumpComponentInfo info) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            ActivityClientRecord r = this.mActivities.get(info.token);
            if (r != null && r.activity != null) {
                FastPrintWriter pw = new FastPrintWriter(new FileOutputStream(info.fd.getFileDescriptor()));
                r.activity.dump(info.prefix, info.fd.getFileDescriptor(), pw, info.args);
                ((PrintWriter)pw).flush();
            }
        }
        finally {
            IoUtils.closeQuietly(info.fd);
            StrictMode.setThreadPolicy(oldPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDumpProvider(DumpComponentInfo info) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            ProviderClientRecord r = this.mLocalProviders.get(info.token);
            if (r != null && r.mLocalProvider != null) {
                FastPrintWriter pw = new FastPrintWriter(new FileOutputStream(info.fd.getFileDescriptor()));
                r.mLocalProvider.dump(info.fd.getFileDescriptor(), pw, info.args);
                ((PrintWriter)pw).flush();
            }
        }
        finally {
            IoUtils.closeQuietly(info.fd);
            StrictMode.setThreadPolicy(oldPolicy);
        }
    }

    private void handleServiceArgs(ServiceArgsData data) {
        block8: {
            Service s = this.mServices.get(data.token);
            if (s != null) {
                try {
                    int res;
                    if (data.args != null) {
                        data.args.setExtrasClassLoader(s.getClassLoader());
                        data.args.prepareToEnterProcess();
                    }
                    if (!data.taskRemoved) {
                        res = s.onStartCommand(data.args, data.flags, data.startId);
                    } else {
                        s.onTaskRemoved(data.args);
                        res = 1000;
                    }
                    QueuedWork.waitToFinish();
                    try {
                        ActivityManagerNative.getDefault().serviceDoneExecuting(data.token, 1, data.startId, res);
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                    this.ensureJitEnabled();
                }
                catch (Exception e) {
                    if (this.mInstrumentation.onException(s, e)) break block8;
                    throw new RuntimeException("Unable to start service " + s + " with " + data.args + ": " + e.toString(), e);
                }
            }
        }
    }

    private void handleStopService(IBinder token) {
        Service s = this.mServices.remove(token);
        if (s != null) {
            try {
                s.onDestroy();
                Context context = s.getBaseContext();
                if (context instanceof ContextImpl) {
                    String who = s.getClassName();
                    ((ContextImpl)context).scheduleFinalCleanup(who, "Service");
                }
                QueuedWork.waitToFinish();
                try {
                    ActivityManagerNative.getDefault().serviceDoneExecuting(token, 2, 0, 0);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            catch (Exception e) {
                if (!this.mInstrumentation.onException(s, e)) {
                    throw new RuntimeException("Unable to stop service " + s + ": " + e.toString(), e);
                }
                Slog.i(TAG, "handleStopService: exception for " + token, e);
            }
        } else {
            Slog.i(TAG, "handleStopService: token=" + token + " not found.");
        }
    }

    public ActivityClientRecord performResumeActivity(IBinder token, boolean clearHide, String reason) {
        ActivityClientRecord r;
        block7: {
            r = this.mActivities.get(token);
            if (r != null && !r.activity.mFinished) {
                if (clearHide) {
                    r.hideForNow = false;
                    r.activity.mStartedActivity = false;
                }
                try {
                    r.activity.onStateNotSaved();
                    r.activity.mFragments.noteStateNotSaved();
                    if (r.pendingIntents != null) {
                        this.deliverNewIntents(r, r.pendingIntents);
                        r.pendingIntents = null;
                    }
                    if (r.pendingResults != null) {
                        this.deliverResults(r, r.pendingResults);
                        r.pendingResults = null;
                    }
                    r.activity.performResume();
                    for (int i = this.mRelaunchingActivities.size() - 1; i >= 0; --i) {
                        ActivityClientRecord relaunching = this.mRelaunchingActivities.get(i);
                        if (relaunching.token != r.token || !relaunching.onlyLocalRequest || !relaunching.startsNotResumed) continue;
                        relaunching.startsNotResumed = false;
                    }
                    EventLog.writeEvent(30022, UserHandle.myUserId(), r.activity.getComponentName().getClassName(), reason);
                    r.paused = false;
                    r.stopped = false;
                    r.state = null;
                    r.persistentState = null;
                }
                catch (Exception e) {
                    if (this.mInstrumentation.onException(r.activity, e)) break block7;
                    throw new RuntimeException("Unable to resume activity " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
                }
            }
        }
        return r;
    }

    static void cleanUpPendingRemoveWindows(ActivityClientRecord r, boolean force) {
        if (r.mPreserveWindow && !force) {
            return;
        }
        if (r.mPendingRemoveWindow != null) {
            r.mPendingRemoveWindowManager.removeViewImmediate(r.mPendingRemoveWindow.getDecorView());
            IBinder wtoken = r.mPendingRemoveWindow.getDecorView().getWindowToken();
            if (wtoken != null) {
                WindowManagerGlobal.getInstance().closeAll(wtoken, r.activity.getClass().getName(), "Activity");
            }
        }
        r.mPendingRemoveWindow = null;
        r.mPendingRemoveWindowManager = null;
    }

    void handleResumeActivity(IBinder token, boolean clearHide, boolean isForward, boolean reallyResume, int seq, String reason) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (!ActivityThread.checkAndUpdateLifecycleSeq(seq, r, "resumeActivity")) {
            return;
        }
        this.unscheduleGcIdler();
        this.mSomeActivitiesChanged = true;
        r = this.performResumeActivity(token, clearHide, reason);
        if (r != null) {
            WindowManager wm;
            boolean willBeVisible;
            Activity a = r.activity;
            int forwardBit = isForward ? 256 : 0;
            boolean bl = willBeVisible = !a.mStartedActivity;
            if (!willBeVisible) {
                try {
                    willBeVisible = ActivityManagerNative.getDefault().willActivityBeVisible(a.getActivityToken());
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            if (r.window == null && !a.mFinished && willBeVisible) {
                r.window = r.activity.getWindow();
                View decor = r.window.getDecorView();
                decor.setVisibility(4);
                wm = a.getWindowManager();
                WindowManager.LayoutParams l = r.window.getAttributes();
                a.mDecor = decor;
                l.type = 1;
                l.softInputMode |= forwardBit;
                if (r.mPreserveWindow) {
                    a.mWindowAdded = true;
                    r.mPreserveWindow = false;
                    ViewRootImpl impl = decor.getViewRootImpl();
                    if (impl != null) {
                        impl.notifyChildRebuilt();
                    }
                }
                if (a.mVisibleFromClient && !a.mWindowAdded) {
                    a.mWindowAdded = true;
                    wm.addView(decor, l);
                }
            } else if (!willBeVisible) {
                r.hideForNow = true;
            }
            ActivityThread.cleanUpPendingRemoveWindows(r, false);
            if (!r.activity.mFinished && willBeVisible && r.activity.mDecor != null && !r.hideForNow) {
                if (r.newConfig != null) {
                    this.performConfigurationChangedForActivity(r, r.newConfig, true);
                    r.newConfig = null;
                }
                WindowManager.LayoutParams l = r.window.getAttributes();
                if ((l.softInputMode & 0x100) != forwardBit) {
                    l.softInputMode = l.softInputMode & 0xFFFFFEFF | forwardBit;
                    if (r.activity.mVisibleFromClient) {
                        wm = a.getWindowManager();
                        View decor = r.window.getDecorView();
                        wm.updateViewLayout(decor, l);
                    }
                }
                r.activity.mVisibleFromServer = true;
                ++this.mNumVisibleActivities;
                if (r.activity.mVisibleFromClient) {
                    r.activity.makeVisible();
                }
            }
            if (!r.onlyLocalRequest) {
                r.nextIdle = this.mNewActivities;
                this.mNewActivities = r;
                Looper.myQueue().addIdleHandler(new Idler());
            }
            r.onlyLocalRequest = false;
            if (reallyResume) {
                try {
                    ActivityManagerNative.getDefault().activityResumed(token);
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
            }
        } else {
            try {
                ActivityManagerNative.getDefault().finishActivity(token, 0, null, 0);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }
    }

    private Bitmap createThumbnailBitmap(ActivityClientRecord r) {
        Bitmap thumbnail = this.mAvailThumbnailBitmap;
        try {
            if (thumbnail == null) {
                int h;
                int w = this.mThumbnailWidth;
                if (w < 0) {
                    Resources res = r.activity.getResources();
                    int wId = 17104898;
                    int hId = 0x1050001;
                    this.mThumbnailWidth = w = res.getDimensionPixelSize(wId);
                    this.mThumbnailHeight = h = res.getDimensionPixelSize(hId);
                } else {
                    h = this.mThumbnailHeight;
                }
                if (w > 0 && h > 0) {
                    thumbnail = Bitmap.createBitmap(r.activity.getResources().getDisplayMetrics(), w, h, THUMBNAIL_FORMAT);
                    thumbnail.eraseColor(0);
                }
            }
            if (thumbnail != null) {
                Canvas cv = this.mThumbnailCanvas;
                if (cv == null) {
                    this.mThumbnailCanvas = cv = new Canvas();
                }
                cv.setBitmap(thumbnail);
                if (!r.activity.onCreateThumbnail(thumbnail, cv)) {
                    this.mAvailThumbnailBitmap = thumbnail;
                    thumbnail = null;
                }
                cv.setBitmap(null);
            }
        }
        catch (Exception e) {
            if (!this.mInstrumentation.onException(r.activity, e)) {
                throw new RuntimeException("Unable to create thumbnail of " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
            }
            thumbnail = null;
        }
        return thumbnail;
    }

    private void handlePauseActivity(IBinder token, boolean finished, boolean userLeaving, int configChanges, boolean dontReport, int seq) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (!ActivityThread.checkAndUpdateLifecycleSeq(seq, r, "pauseActivity")) {
            return;
        }
        if (r != null) {
            if (userLeaving) {
                this.performUserLeavingActivity(r);
            }
            r.activity.mConfigChangeFlags |= configChanges;
            this.performPauseActivity(token, finished, r.isPreHoneycomb(), "handlePauseActivity");
            if (r.isPreHoneycomb()) {
                QueuedWork.waitToFinish();
            }
            if (!dontReport) {
                try {
                    ActivityManagerNative.getDefault().activityPaused(token);
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
            }
            this.mSomeActivitiesChanged = true;
        }
    }

    void performUserLeavingActivity(ActivityClientRecord r) {
        this.mInstrumentation.callActivityOnUserLeaving(r.activity);
    }

    Bundle performPauseActivity(IBinder token, boolean finished, boolean saveState, String reason) {
        ActivityClientRecord r = this.mActivities.get(token);
        return r != null ? this.performPauseActivity(r, finished, saveState, reason) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bundle performPauseActivity(ActivityClientRecord r, boolean finished, boolean saveState, String reason) {
        ArrayList<OnActivityPausedListener> listeners;
        if (r.paused) {
            if (r.activity.mFinished) {
                return null;
            }
            RuntimeException e = new RuntimeException("Performing pause of activity that is not resumed: " + r.intent.getComponent().toShortString());
            Slog.e(TAG, e.getMessage(), e);
        }
        if (finished) {
            r.activity.mFinished = true;
        }
        if (!r.activity.mFinished && saveState) {
            this.callCallActivityOnSaveInstanceState(r);
        }
        this.performPauseActivityIfNeeded(r, reason);
        ArrayMap<Activity, ArrayList<OnActivityPausedListener>> arrayMap = this.mOnPauseListeners;
        synchronized (arrayMap) {
            listeners = this.mOnPauseListeners.remove(r.activity);
        }
        int size = listeners != null ? listeners.size() : 0;
        for (int i = 0; i < size; ++i) {
            listeners.get(i).onPaused(r.activity);
        }
        return !r.activity.mFinished && saveState ? r.state : null;
    }

    private void performPauseActivityIfNeeded(ActivityClientRecord r, String reason) {
        block5: {
            if (r.paused) {
                return;
            }
            try {
                r.activity.mCalled = false;
                this.mInstrumentation.callActivityOnPause(r.activity);
                EventLog.writeEvent(30021, UserHandle.myUserId(), r.activity.getComponentName().getClassName(), reason);
                if (!r.activity.mCalled) {
                    throw new SuperNotCalledException("Activity " + ActivityThread.safeToComponentShortString(r.intent) + " did not call through to super.onPause()");
                }
            }
            catch (SuperNotCalledException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.mInstrumentation.onException(r.activity, e)) break block5;
                throw new RuntimeException("Unable to pause activity " + ActivityThread.safeToComponentShortString(r.intent) + ": " + e.toString(), e);
            }
        }
        r.paused = true;
    }

    void performStopActivity(IBinder token, boolean saveState, String reason) {
        ActivityClientRecord r = this.mActivities.get(token);
        this.performStopActivityInner(r, null, false, saveState, reason);
    }

    private void performStopActivityInner(ActivityClientRecord r, StopInfo info, boolean keepShown, boolean saveState, String reason) {
        if (r != null) {
            block10: {
                if (!keepShown && r.stopped) {
                    if (r.activity.mFinished) {
                        return;
                    }
                    RuntimeException e = new RuntimeException("Performing stop of activity that is already stopped: " + r.intent.getComponent().toShortString());
                    Slog.e(TAG, e.getMessage(), e);
                    Slog.e(TAG, r.getStateString());
                }
                this.performPauseActivityIfNeeded(r, reason);
                if (info != null) {
                    try {
                        info.description = r.activity.onCreateDescription();
                    }
                    catch (Exception e) {
                        if (this.mInstrumentation.onException(r.activity, e)) break block10;
                        throw new RuntimeException("Unable to save state of activity " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
                    }
                }
            }
            if (!r.activity.mFinished && saveState && r.state == null) {
                this.callCallActivityOnSaveInstanceState(r);
            }
            if (!keepShown) {
                block11: {
                    try {
                        r.activity.performStop(false);
                    }
                    catch (Exception e) {
                        if (this.mInstrumentation.onException(r.activity, e)) break block11;
                        throw new RuntimeException("Unable to stop activity " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
                    }
                }
                r.stopped = true;
                EventLog.writeEvent(30049, UserHandle.myUserId(), r.activity.getComponentName().getClassName(), reason);
            }
        }
    }

    private void updateVisibility(ActivityClientRecord r, boolean show) {
        View v = r.activity.mDecor;
        if (v != null) {
            if (show) {
                if (!r.activity.mVisibleFromServer) {
                    r.activity.mVisibleFromServer = true;
                    ++this.mNumVisibleActivities;
                    if (r.activity.mVisibleFromClient) {
                        r.activity.makeVisible();
                    }
                }
                if (r.newConfig != null) {
                    this.performConfigurationChangedForActivity(r, r.newConfig, true);
                    r.newConfig = null;
                }
            } else if (r.activity.mVisibleFromServer) {
                r.activity.mVisibleFromServer = false;
                --this.mNumVisibleActivities;
                v.setVisibility(4);
            }
        }
    }

    private void handleStopActivity(IBinder token, boolean show, int configChanges, int seq) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (!ActivityThread.checkAndUpdateLifecycleSeq(seq, r, "stopActivity")) {
            return;
        }
        r.activity.mConfigChangeFlags |= configChanges;
        StopInfo info = new StopInfo();
        this.performStopActivityInner(r, info, show, true, "handleStopActivity");
        this.updateVisibility(r, show);
        if (!r.isPreHoneycomb()) {
            QueuedWork.waitToFinish();
        }
        info.activity = r;
        info.state = r.state;
        info.persistentState = r.persistentState;
        this.mH.post(info);
        this.mSomeActivitiesChanged = true;
    }

    private static boolean checkAndUpdateLifecycleSeq(int seq, ActivityClientRecord r, String action) {
        if (r == null) {
            return true;
        }
        if (seq < r.lastProcessedSeq) {
            return false;
        }
        r.lastProcessedSeq = seq;
        return true;
    }

    void performRestartActivity(IBinder token) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r.stopped) {
            r.activity.performRestart();
            r.stopped = false;
        }
    }

    private void handleWindowVisibility(IBinder token, boolean show) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r == null) {
            Log.w(TAG, "handleWindowVisibility: no activity for token " + token);
            return;
        }
        if (!show && !r.stopped) {
            this.performStopActivityInner(r, null, show, false, "handleWindowVisibility");
        } else if (show && r.stopped) {
            this.unscheduleGcIdler();
            r.activity.performRestart();
            r.stopped = false;
        }
        if (r.activity.mDecor != null) {
            this.updateVisibility(r, show);
        }
        this.mSomeActivitiesChanged = true;
    }

    private void handleSleeping(IBinder token, boolean sleeping) {
        ActivityClientRecord r = this.mActivities.get(token);
        if (r == null) {
            Log.w(TAG, "handleSleeping: no activity for token " + token);
            return;
        }
        if (sleeping) {
            if (!r.stopped && !r.isPreHoneycomb()) {
                block9: {
                    try {
                        r.activity.performStop(false);
                    }
                    catch (Exception e) {
                        if (this.mInstrumentation.onException(r.activity, e)) break block9;
                        throw new RuntimeException("Unable to stop activity " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
                    }
                }
                r.stopped = true;
                EventLog.writeEvent(30049, UserHandle.myUserId(), r.activity.getComponentName().getClassName(), "sleeping");
            }
            if (!r.isPreHoneycomb()) {
                QueuedWork.waitToFinish();
            }
            try {
                ActivityManagerNative.getDefault().activitySlept(r.token);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }
        if (r.stopped && r.activity.mVisibleFromServer) {
            r.activity.performRestart();
            r.stopped = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSetCoreSettings(Bundle coreSettings) {
        ResourcesManager resourcesManager = this.mResourcesManager;
        synchronized (resourcesManager) {
            this.mCoreSettings = coreSettings;
        }
        this.onCoreSettingsChange();
    }

    private void onCoreSettingsChange() {
        boolean debugViewAttributes;
        boolean bl = debugViewAttributes = this.mCoreSettings.getInt("debug_view_attributes", 0) != 0;
        if (debugViewAttributes != View.mDebugViewAttributes) {
            View.mDebugViewAttributes = debugViewAttributes;
            for (Map.Entry<IBinder, ActivityClientRecord> entry : this.mActivities.entrySet()) {
                this.requestRelaunchActivity(entry.getKey(), null, null, 0, false, null, null, false, false);
            }
        }
    }

    private void handleUpdatePackageCompatibilityInfo(UpdateCompatibilityData data) {
        LoadedApk apk = this.peekPackageInfo(data.pkg, false);
        if (apk != null) {
            apk.setCompatibilityInfo(data.info);
        }
        if ((apk = this.peekPackageInfo(data.pkg, true)) != null) {
            apk.setCompatibilityInfo(data.info);
        }
        this.handleConfigurationChanged(this.mConfiguration, data.info);
        WindowManagerGlobal.getInstance().reportNewConfiguration(this.mConfiguration);
    }

    private void deliverResults(ActivityClientRecord r, List<ResultInfo> results) {
        int N = results.size();
        for (int i = 0; i < N; ++i) {
            ResultInfo ri = results.get(i);
            try {
                if (ri.mData != null) {
                    ri.mData.setExtrasClassLoader(r.activity.getClassLoader());
                    ri.mData.prepareToEnterProcess();
                }
                r.activity.dispatchActivityResult(ri.mResultWho, ri.mRequestCode, ri.mResultCode, ri.mData);
                continue;
            }
            catch (Exception e) {
                if (this.mInstrumentation.onException(r.activity, e)) continue;
                throw new RuntimeException("Failure delivering result " + ri + " to activity " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
            }
        }
    }

    private void handleSendResult(ResultData res) {
        ActivityClientRecord r = this.mActivities.get(res.token);
        if (r != null) {
            boolean resumed;
            block8: {
                boolean bl = resumed = !r.paused;
                if (!r.activity.mFinished && r.activity.mDecor != null && r.hideForNow && resumed) {
                    this.updateVisibility(r, true);
                }
                if (resumed) {
                    try {
                        r.activity.mCalled = false;
                        r.activity.mTemporaryPause = true;
                        this.mInstrumentation.callActivityOnPause(r.activity);
                        if (!r.activity.mCalled) {
                            throw new SuperNotCalledException("Activity " + r.intent.getComponent().toShortString() + " did not call through to super.onPause()");
                        }
                    }
                    catch (SuperNotCalledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        if (this.mInstrumentation.onException(r.activity, e)) break block8;
                        throw new RuntimeException("Unable to pause activity " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
                    }
                }
            }
            this.deliverResults(r, res.results);
            if (resumed) {
                r.activity.performResume();
                r.activity.mTemporaryPause = false;
            }
        }
    }

    public ActivityClientRecord performDestroyActivity(IBinder token, boolean finishing) {
        return this.performDestroyActivity(token, finishing, 0, false);
    }

    private ActivityClientRecord performDestroyActivity(IBinder token, boolean finishing, int configChanges, boolean getNonConfigInstance) {
        Class<?> activityClass;
        ActivityClientRecord r;
        block16: {
            r = this.mActivities.get(token);
            activityClass = null;
            if (r != null) {
                block15: {
                    activityClass = r.activity.getClass();
                    r.activity.mConfigChangeFlags |= configChanges;
                    if (finishing) {
                        r.activity.mFinished = true;
                    }
                    this.performPauseActivityIfNeeded(r, "destroy");
                    if (!r.stopped) {
                        block14: {
                            try {
                                r.activity.performStop(r.mPreserveWindow);
                            }
                            catch (SuperNotCalledException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                if (this.mInstrumentation.onException(r.activity, e)) break block14;
                                throw new RuntimeException("Unable to stop activity " + ActivityThread.safeToComponentShortString(r.intent) + ": " + e.toString(), e);
                            }
                        }
                        r.stopped = true;
                        EventLog.writeEvent(30049, UserHandle.myUserId(), r.activity.getComponentName().getClassName(), "destroy");
                    }
                    if (getNonConfigInstance) {
                        try {
                            r.lastNonConfigurationInstances = r.activity.retainNonConfigurationInstances();
                        }
                        catch (Exception e) {
                            if (this.mInstrumentation.onException(r.activity, e)) break block15;
                            throw new RuntimeException("Unable to retain activity " + r.intent.getComponent().toShortString() + ": " + e.toString(), e);
                        }
                    }
                }
                try {
                    r.activity.mCalled = false;
                    this.mInstrumentation.callActivityOnDestroy(r.activity);
                    if (!r.activity.mCalled) {
                        throw new SuperNotCalledException("Activity " + ActivityThread.safeToComponentShortString(r.intent) + " did not call through to super.onDestroy()");
                    }
                    if (r.window != null) {
                        r.window.closeAllPanels();
                    }
                }
                catch (SuperNotCalledException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (this.mInstrumentation.onException(r.activity, e)) break block16;
                    throw new RuntimeException("Unable to destroy activity " + ActivityThread.safeToComponentShortString(r.intent) + ": " + e.toString(), e);
                }
            }
        }
        this.mActivities.remove(token);
        StrictMode.decrementExpectedActivityCount(activityClass);
        return r;
    }

    private static String safeToComponentShortString(Intent intent) {
        ComponentName component = intent.getComponent();
        return component == null ? "[Unknown]" : component.toShortString();
    }

    private void handleDestroyActivity(IBinder token, boolean finishing, int configChanges, boolean getNonConfigInstance) {
        ActivityClientRecord r = this.performDestroyActivity(token, finishing, configChanges, getNonConfigInstance);
        if (r != null) {
            Context c;
            ActivityThread.cleanUpPendingRemoveWindows(r, finishing);
            WindowManager wm = r.activity.getWindowManager();
            View v = r.activity.mDecor;
            if (v != null) {
                if (r.activity.mVisibleFromServer) {
                    --this.mNumVisibleActivities;
                }
                IBinder wtoken = v.getWindowToken();
                if (r.activity.mWindowAdded) {
                    if (r.mPreserveWindow) {
                        r.mPendingRemoveWindow = r.window;
                        r.mPendingRemoveWindowManager = wm;
                        r.window.clearContentView();
                    } else {
                        wm.removeViewImmediate(v);
                    }
                }
                if (wtoken != null && r.mPendingRemoveWindow == null) {
                    WindowManagerGlobal.getInstance().closeAll(wtoken, r.activity.getClass().getName(), "Activity");
                } else if (r.mPendingRemoveWindow != null) {
                    WindowManagerGlobal.getInstance().closeAllExceptView(token, v, r.activity.getClass().getName(), "Activity");
                }
                r.activity.mDecor = null;
            }
            if (r.mPendingRemoveWindow == null) {
                WindowManagerGlobal.getInstance().closeAll(token, r.activity.getClass().getName(), "Activity");
            }
            if ((c = r.activity.getBaseContext()) instanceof ContextImpl) {
                ((ContextImpl)c).scheduleFinalCleanup(r.activity.getClass().getName(), "Activity");
            }
        }
        if (finishing) {
            try {
                ActivityManagerNative.getDefault().activityDestroyed(token);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }
        this.mSomeActivitiesChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRelaunchActivity(IBinder token, List<ResultInfo> pendingResults, List<ReferrerIntent> pendingNewIntents, int configChanges, boolean notResumed, Configuration config, Configuration overrideConfig, boolean fromServer, boolean preserveWindow) {
        ActivityClientRecord target = null;
        ResourcesManager resourcesManager = this.mResourcesManager;
        synchronized (resourcesManager) {
            for (int i = 0; i < this.mRelaunchingActivities.size(); ++i) {
                ActivityClientRecord r = this.mRelaunchingActivities.get(i);
                if (r.token != token) continue;
                target = r;
                if (pendingResults != null) {
                    if (r.pendingResults != null) {
                        r.pendingResults.addAll(pendingResults);
                    } else {
                        r.pendingResults = pendingResults;
                    }
                }
                if (pendingNewIntents != null) {
                    if (r.pendingIntents != null) {
                        r.pendingIntents.addAll(pendingNewIntents);
                    } else {
                        r.pendingIntents = pendingNewIntents;
                    }
                }
                if (r.onlyLocalRequest || !fromServer) break;
                try {
                    ActivityManagerNative.getDefault().activityRelaunched(token);
                    break;
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            if (target == null) {
                target = new ActivityClientRecord();
                target.token = token;
                target.pendingResults = pendingResults;
                target.pendingIntents = pendingNewIntents;
                target.mPreserveWindow = preserveWindow;
                if (!fromServer) {
                    ActivityClientRecord existing = this.mActivities.get(token);
                    if (existing != null) {
                        target.startsNotResumed = existing.paused;
                        target.overrideConfig = existing.overrideConfig;
                    }
                    target.onlyLocalRequest = true;
                }
                this.mRelaunchingActivities.add(target);
                this.sendMessage(126, target);
            }
            if (fromServer) {
                target.startsNotResumed = notResumed;
                target.onlyLocalRequest = false;
            }
            if (config != null) {
                target.createdConfig = config;
            }
            if (overrideConfig != null) {
                target.overrideConfig = overrideConfig;
            }
            target.pendingConfigChanges |= configChanges;
            target.relaunchSeq = this.getLifecycleSeq();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRelaunchActivity(ActivityClientRecord tmp) {
        ActivityClientRecord r;
        this.unscheduleGcIdler();
        this.mSomeActivitiesChanged = true;
        Configuration changedConfig = null;
        int configChanges = 0;
        ResourcesManager resourcesManager = this.mResourcesManager;
        synchronized (resourcesManager) {
            int N = this.mRelaunchingActivities.size();
            IBinder token = tmp.token;
            tmp = null;
            for (int i = 0; i < N; ++i) {
                ActivityClientRecord r2 = this.mRelaunchingActivities.get(i);
                if (r2.token != token) continue;
                tmp = r2;
                configChanges |= tmp.pendingConfigChanges;
                this.mRelaunchingActivities.remove(i);
                --i;
                --N;
            }
            if (tmp == null) {
                return;
            }
            if (this.mPendingConfiguration != null) {
                changedConfig = this.mPendingConfiguration;
                this.mPendingConfiguration = null;
            }
        }
        if (tmp.lastProcessedSeq > tmp.relaunchSeq) {
            Slog.wtf(TAG, "For some reason target: " + tmp + " has lower sequence: " + tmp.relaunchSeq + " than current sequence: " + tmp.lastProcessedSeq);
        } else {
            tmp.lastProcessedSeq = tmp.relaunchSeq;
        }
        if (tmp.createdConfig != null && (this.mConfiguration == null || tmp.createdConfig.isOtherSeqNewer(this.mConfiguration) && this.mConfiguration.diff(tmp.createdConfig) != 0) && (changedConfig == null || tmp.createdConfig.isOtherSeqNewer(changedConfig))) {
            changedConfig = tmp.createdConfig;
        }
        if (changedConfig != null) {
            this.mCurDefaultDisplayDpi = changedConfig.densityDpi;
            this.updateDefaultDensity();
            this.handleConfigurationChanged(changedConfig, null);
        }
        if ((r = this.mActivities.get(tmp.token)) == null) {
            if (!tmp.onlyLocalRequest) {
                try {
                    ActivityManagerNative.getDefault().activityRelaunched(tmp.token);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            return;
        }
        r.activity.mConfigChangeFlags |= configChanges;
        r.onlyLocalRequest = tmp.onlyLocalRequest;
        r.mPreserveWindow = tmp.mPreserveWindow;
        r.lastProcessedSeq = tmp.lastProcessedSeq;
        r.relaunchSeq = tmp.relaunchSeq;
        Intent currentIntent = r.activity.mIntent;
        r.activity.mChangingConfigurations = true;
        try {
            if (r.mPreserveWindow || r.onlyLocalRequest) {
                WindowManagerGlobal.getWindowSession().prepareToReplaceWindows(r.token, !r.onlyLocalRequest);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (!r.paused) {
            this.performPauseActivity(r.token, false, r.isPreHoneycomb(), "handleRelaunchActivity");
        }
        if (r.state == null && !r.stopped && !r.isPreHoneycomb()) {
            this.callCallActivityOnSaveInstanceState(r);
        }
        this.handleDestroyActivity(r.token, false, configChanges, true);
        r.activity = null;
        r.window = null;
        r.hideForNow = false;
        r.nextIdle = null;
        if (tmp.pendingResults != null) {
            if (r.pendingResults == null) {
                r.pendingResults = tmp.pendingResults;
            } else {
                r.pendingResults.addAll(tmp.pendingResults);
            }
        }
        if (tmp.pendingIntents != null) {
            if (r.pendingIntents == null) {
                r.pendingIntents = tmp.pendingIntents;
            } else {
                r.pendingIntents.addAll(tmp.pendingIntents);
            }
        }
        r.startsNotResumed = tmp.startsNotResumed;
        r.overrideConfig = tmp.overrideConfig;
        this.handleLaunchActivity(r, currentIntent, "handleRelaunchActivity");
        if (!tmp.onlyLocalRequest) {
            try {
                ActivityManagerNative.getDefault().activityRelaunched(r.token);
                if (r.window != null) {
                    r.window.reportActivityRelaunched();
                }
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private void callCallActivityOnSaveInstanceState(ActivityClientRecord r) {
        r.state = new Bundle();
        r.state.setAllowFds(false);
        if (r.isPersistable()) {
            r.persistentState = new PersistableBundle();
            this.mInstrumentation.callActivityOnSaveInstanceState(r.activity, r.state, r.persistentState);
        } else {
            this.mInstrumentation.callActivityOnSaveInstanceState(r.activity, r.state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<ComponentCallbacks2> collectComponentCallbacks(boolean allActivities, Configuration newConfig) {
        int i;
        ArrayList<ComponentCallbacks2> callbacks = new ArrayList<ComponentCallbacks2>();
        Object object = this.mResourcesManager;
        synchronized (object) {
            int NAPP = this.mAllApplications.size();
            for (i = 0; i < NAPP; ++i) {
                callbacks.add(this.mAllApplications.get(i));
            }
            int NACT = this.mActivities.size();
            for (int i2 = 0; i2 < NACT; ++i2) {
                ActivityClientRecord ar = this.mActivities.valueAt(i2);
                Activity a = ar.activity;
                if (a == null) continue;
                Configuration thisConfig = this.applyConfigCompatMainThread(this.mCurDefaultDisplayDpi, newConfig, ar.packageInfo.getCompatibilityInfo());
                if (!(ar.activity.mFinished || !allActivities && ar.paused)) {
                    callbacks.add(a);
                    continue;
                }
                if (thisConfig == null) continue;
                ar.newConfig = thisConfig;
            }
            int NSVC = this.mServices.size();
            for (int i3 = 0; i3 < NSVC; ++i3) {
                callbacks.add(this.mServices.valueAt(i3));
            }
        }
        object = this.mProviderMap;
        synchronized (object) {
            int NPRV = this.mLocalProviders.size();
            for (i = 0; i < NPRV; ++i) {
                callbacks.add(this.mLocalProviders.valueAt((int)i).mLocalProvider);
            }
        }
        return callbacks;
    }

    private void performConfigurationChangedForActivity(ActivityClientRecord r, Configuration newBaseConfig, boolean reportToActivity) {
        r.tmpConfig.setTo(newBaseConfig);
        if (r.overrideConfig != null) {
            r.tmpConfig.updateFrom(r.overrideConfig);
        }
        this.performConfigurationChanged(r.activity, r.token, r.tmpConfig, r.overrideConfig, reportToActivity);
        ActivityThread.freeTextLayoutCachesIfNeeded(r.activity.mCurrentConfig.diff(r.tmpConfig));
    }

    private static Configuration createNewConfigAndUpdateIfNotNull(Configuration base, Configuration override) {
        if (override == null) {
            return base;
        }
        Configuration newConfig = new Configuration(base);
        newConfig.updateFrom(override);
        return newConfig;
    }

    private void performConfigurationChanged(ComponentCallbacks2 cb, IBinder activityToken, Configuration newConfig, Configuration amOverrideConfig, boolean reportToActivity) {
        Activity activity;
        Activity activity2 = activity = cb instanceof Activity ? (Activity)cb : null;
        if (activity != null) {
            activity.mCalled = false;
        }
        boolean shouldChangeConfig = false;
        if (activity == null || activity.mCurrentConfig == null) {
            shouldChangeConfig = true;
        } else {
            int diff = activity.mCurrentConfig.diff(newConfig);
            if (diff != 0) {
                shouldChangeConfig = true;
            }
        }
        if (shouldChangeConfig) {
            Configuration contextThemeWrapperOverrideConfig = null;
            if (cb instanceof ContextThemeWrapper) {
                ContextThemeWrapper contextThemeWrapper = (ContextThemeWrapper)((Object)cb);
                contextThemeWrapperOverrideConfig = contextThemeWrapper.getOverrideConfiguration();
            }
            if (activityToken != null) {
                Configuration finalOverrideConfig = ActivityThread.createNewConfigAndUpdateIfNotNull(amOverrideConfig, contextThemeWrapperOverrideConfig);
                this.mResourcesManager.updateResourcesForActivity(activityToken, finalOverrideConfig);
            }
            if (reportToActivity) {
                Configuration configToReport = ActivityThread.createNewConfigAndUpdateIfNotNull(newConfig, contextThemeWrapperOverrideConfig);
                cb.onConfigurationChanged(configToReport);
            }
            if (activity != null) {
                if (reportToActivity && !activity.mCalled) {
                    throw new SuperNotCalledException("Activity " + activity.getLocalClassName() + " did not call through to super.onConfigurationChanged()");
                }
                activity.mConfigChangeFlags = 0;
                activity.mCurrentConfig = new Configuration(newConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyConfigurationToResources(Configuration config) {
        ResourcesManager resourcesManager = this.mResourcesManager;
        synchronized (resourcesManager) {
            this.mResourcesManager.applyConfigurationToResourcesLocked(config, null);
        }
    }

    Configuration applyCompatConfiguration(int displayDensity) {
        Configuration config = this.mConfiguration;
        if (this.mCompatConfiguration == null) {
            this.mCompatConfiguration = new Configuration();
        }
        this.mCompatConfiguration.setTo(this.mConfiguration);
        if (this.mResourcesManager.applyCompatConfigurationLocked(displayDensity, this.mCompatConfiguration)) {
            config = this.mCompatConfiguration;
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleConfigurationChanged(Configuration config, CompatibilityInfo compat) {
        int configDiff = 0;
        ResourcesManager resourcesManager = this.mResourcesManager;
        synchronized (resourcesManager) {
            if (this.mPendingConfiguration != null) {
                if (!this.mPendingConfiguration.isOtherSeqNewer(config)) {
                    config = this.mPendingConfiguration;
                    this.mCurDefaultDisplayDpi = config.densityDpi;
                    this.updateDefaultDensity();
                }
                this.mPendingConfiguration = null;
            }
            if (config == null) {
                return;
            }
            this.mResourcesManager.applyConfigurationToResourcesLocked(config, compat);
            this.updateLocaleListFromAppContext(this.mInitialApplication.getApplicationContext(), this.mResourcesManager.getConfiguration().getLocales());
            if (this.mConfiguration == null) {
                this.mConfiguration = new Configuration();
            }
            if (!this.mConfiguration.isOtherSeqNewer(config) && compat == null) {
                return;
            }
            configDiff = this.mConfiguration.updateFrom(config);
            config = this.applyCompatConfiguration(this.mCurDefaultDisplayDpi);
            Resources.Theme systemTheme = this.getSystemContext().getTheme();
            if ((systemTheme.getChangingConfigurations() & configDiff) != 0) {
                systemTheme.rebase();
            }
        }
        ArrayList<ComponentCallbacks2> callbacks = this.collectComponentCallbacks(false, config);
        ActivityThread.freeTextLayoutCachesIfNeeded(configDiff);
        if (callbacks != null) {
            int N = callbacks.size();
            for (int i = 0; i < N; ++i) {
                ComponentCallbacks2 cb = callbacks.get(i);
                if (cb instanceof Activity) {
                    Activity a = (Activity)cb;
                    this.performConfigurationChangedForActivity(this.mActivities.get(a.getActivityToken()), config, true);
                    continue;
                }
                this.performConfigurationChanged(cb, null, config, null, true);
            }
        }
    }

    static void freeTextLayoutCachesIfNeeded(int configDiff) {
        if (configDiff != 0) {
            boolean hasLocaleConfigChange;
            boolean bl = hasLocaleConfigChange = (configDiff & 4) != 0;
            if (hasLocaleConfigChange) {
                Canvas.freeTextLayoutCaches();
            }
        }
    }

    void handleActivityConfigurationChanged(ActivityConfigChangeData data, boolean reportToActivity) {
        ActivityClientRecord r = this.mActivities.get(data.activityToken);
        if (r == null || r.activity == null) {
            return;
        }
        r.overrideConfig = data.overrideConfig;
        this.performConfigurationChangedForActivity(r, this.mCompatConfiguration, reportToActivity);
        this.mSomeActivitiesChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleProfilerControl(boolean start, ProfilerInfo profilerInfo, int profileType) {
        if (start) {
            try {
                switch (profileType) {
                    default: 
                }
                this.mProfiler.setProfiler(profilerInfo);
                this.mProfiler.startProfiling();
            }
            catch (RuntimeException e) {
                Slog.w(TAG, "Profiling failed on path " + profilerInfo.profileFile + " -- can the process access this path?");
            }
            finally {
                try {
                    profilerInfo.profileFd.close();
                }
                catch (IOException e) {
                    Slog.w(TAG, "Failure closing profile fd", e);
                }
            }
        } else {
            switch (profileType) {
                default: 
            }
            this.mProfiler.stopProfiling();
        }
    }

    public void stopProfiling() {
        this.mProfiler.stopProfiling();
    }

    static void handleDumpHeap(boolean managed, DumpHeapData dhd) {
        if (managed) {
            try {
                Debug.dumpHprofData(dhd.path, dhd.fd.getFileDescriptor());
            }
            catch (IOException e) {
                Slog.w(TAG, "Managed heap dump failed on path " + dhd.path + " -- can the process access this path?");
            }
            finally {
                try {
                    dhd.fd.close();
                }
                catch (IOException e) {
                    Slog.w(TAG, "Failure closing profile fd", e);
                }
            }
        } else {
            Debug.dumpNativeHeap(dhd.fd.getFileDescriptor());
        }
        try {
            ActivityManagerNative.getDefault().dumpHeapFinished(dhd.path);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDispatchPackageBroadcast(int cmd, String[] packages) {
        boolean hasPkgInfo = false;
        switch (cmd) {
            case 0: 
            case 2: {
                boolean killApp;
                boolean bl = killApp = cmd == 0;
                if (packages == null) break;
                ResourcesManager resourcesManager = this.mResourcesManager;
                synchronized (resourcesManager) {
                    for (int i = packages.length - 1; i >= 0; --i) {
                        if (!hasPkgInfo) {
                            WeakReference<LoadedApk> ref = this.mPackages.get(packages[i]);
                            if (ref != null && ref.get() != null) {
                                hasPkgInfo = true;
                            } else {
                                ref = this.mResourcePackages.get(packages[i]);
                                if (ref != null && ref.get() != null) {
                                    hasPkgInfo = true;
                                }
                            }
                        }
                        if (!killApp) continue;
                        this.mPackages.remove(packages[i]);
                        this.mResourcePackages.remove(packages[i]);
                    }
                    break;
                }
            }
            case 3: {
                if (packages == null) break;
                ResourcesManager resourcesManager = this.mResourcesManager;
                synchronized (resourcesManager) {
                    for (int i = packages.length - 1; i >= 0; --i) {
                        LoadedApk pkgInfo;
                        WeakReference<LoadedApk> ref = this.mPackages.get(packages[i]);
                        LoadedApk loadedApk = pkgInfo = ref != null ? (LoadedApk)ref.get() : null;
                        if (pkgInfo != null) {
                            hasPkgInfo = true;
                        } else {
                            ref = this.mResourcePackages.get(packages[i]);
                            LoadedApk loadedApk2 = pkgInfo = ref != null ? (LoadedApk)ref.get() : null;
                            if (pkgInfo != null) {
                                hasPkgInfo = true;
                            }
                        }
                        if (pkgInfo == null) continue;
                        try {
                            String packageName = packages[i];
                            ApplicationInfo aInfo = sPackageManager.getApplicationInfo(packageName, 0, UserHandle.myUserId());
                            if (this.mActivities.size() > 0) {
                                for (ActivityClientRecord ar : this.mActivities.values()) {
                                    if (!ar.activityInfo.applicationInfo.packageName.equals(packageName)) continue;
                                    ar.activityInfo.applicationInfo = aInfo;
                                    ar.packageInfo = pkgInfo;
                                }
                            }
                            List<String> oldPaths = sPackageManager.getPreviousCodePaths(packageName);
                            pkgInfo.updateApplicationInfo(aInfo, oldPaths);
                            continue;
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    break;
                }
            }
        }
        ApplicationPackageManager.handlePackageBroadcast(cmd, packages, hasPkgInfo);
    }

    void handleLowMemory() {
        ArrayList<ComponentCallbacks2> callbacks = this.collectComponentCallbacks(true, null);
        int N = callbacks.size();
        for (int i = 0; i < N; ++i) {
            callbacks.get(i).onLowMemory();
        }
        if (Process.myUid() != 1000) {
            int sqliteReleased = SQLiteDatabase.releaseMemory();
            EventLog.writeEvent(75003, sqliteReleased);
        }
        Canvas.freeCaches();
        Canvas.freeTextLayoutCaches();
        BinderInternal.forceGc("mem");
    }

    void handleTrimMemory(int level) {
        ArrayList<ComponentCallbacks2> callbacks = this.collectComponentCallbacks(true, null);
        int N = callbacks.size();
        for (int i = 0; i < N; ++i) {
            callbacks.get(i).onTrimMemory(level);
        }
        WindowManagerGlobal.getInstance().trimMemory(level);
    }

    private void setupGraphicsSupport(LoadedApk info, File cacheDir) {
        if (Process.isIsolated()) {
            return;
        }
        Trace.traceBegin(64L, "setupGraphicsSupport");
        try {
            int uid = Process.myUid();
            String[] packages = ActivityThread.getPackageManager().getPackagesForUid(uid);
            if (packages != null && packages.length == 1) {
                ThreadedRenderer.setupDiskCache(cacheDir);
                RenderScriptCacheDir.setupDiskCache(cacheDir);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        finally {
            Trace.traceEnd(64L);
        }
    }

    private void updateDefaultDensity() {
        int densityDpi = this.mCurDefaultDisplayDpi;
        if (!this.mDensityCompatMode && densityDpi != 0 && densityDpi != DisplayMetrics.DENSITY_DEVICE) {
            DisplayMetrics.DENSITY_DEVICE = densityDpi;
            Bitmap.setDefaultDensity(densityDpi);
        }
    }

    private String getInstrumentationLibrary(ApplicationInfo appInfo, InstrumentationInfo insInfo) {
        if (appInfo.primaryCpuAbi != null && appInfo.secondaryCpuAbi != null) {
            String secondaryIsa = VMRuntime.getInstructionSet(appInfo.secondaryCpuAbi);
            String secondaryDexCodeIsa = SystemProperties.get("ro.dalvik.vm.isa." + secondaryIsa);
            secondaryIsa = secondaryDexCodeIsa.isEmpty() ? secondaryIsa : secondaryDexCodeIsa;
            String runtimeIsa = VMRuntime.getRuntime().vmInstructionSet();
            if (runtimeIsa.equals(secondaryIsa)) {
                return insInfo.secondaryNativeLibraryDir;
            }
        }
        return insInfo.nativeLibraryDir;
    }

    private void updateLocaleListFromAppContext(Context context, LocaleList newLocaleList) {
        Locale bestLocale = context.getResources().getConfiguration().getLocales().get(0);
        int newLocaleListSize = newLocaleList.size();
        for (int i = 0; i < newLocaleListSize; ++i) {
            if (!bestLocale.equals(newLocaleList.get(i))) continue;
            LocaleList.setDefault(newLocaleList, i);
            return;
        }
        LocaleList.setDefault(new LocaleList(bestLocale, newLocaleList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBindApplication(AppBindData data) {
        InstrumentationInfo ii;
        VMRuntime.registerSensitiveThread();
        if (data.trackAllocation) {
            DdmVmInternal.enableRecentAllocations(true);
        }
        Process.setStartTimes(SystemClock.elapsedRealtime(), SystemClock.uptimeMillis());
        this.mBoundApplication = data;
        this.mConfiguration = new Configuration(data.config);
        this.mCompatConfiguration = new Configuration(data.config);
        this.mProfiler = new Profiler();
        if (data.initProfilerInfo != null) {
            this.mProfiler.profileFile = data.initProfilerInfo.profileFile;
            this.mProfiler.profileFd = data.initProfilerInfo.profileFd;
            this.mProfiler.samplingInterval = data.initProfilerInfo.samplingInterval;
            this.mProfiler.autoStopProfiler = data.initProfilerInfo.autoStopProfiler;
        }
        Process.setArgV0(data.processName);
        DdmHandleAppName.setAppName(data.processName, UserHandle.myUserId());
        if (data.persistent && !ActivityManager.isHighEndGfx()) {
            ThreadedRenderer.disable(false);
        }
        if (this.mProfiler.profileFd != null) {
            this.mProfiler.startProfiling();
        }
        if (data.appInfo.targetSdkVersion <= 12) {
            AsyncTask.setDefaultExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        }
        Message.updateCheckRecycle(data.appInfo.targetSdkVersion);
        TimeZone.setDefault(null);
        LocaleList.setDefault(data.config.getLocales());
        ResourcesManager resourcesManager = this.mResourcesManager;
        synchronized (resourcesManager) {
            this.mResourcesManager.applyConfigurationToResourcesLocked(data.config, data.compatInfo);
            this.mCurDefaultDisplayDpi = data.config.densityDpi;
            this.applyCompatConfiguration(this.mCurDefaultDisplayDpi);
        }
        data.info = this.getPackageInfoNoCheck(data.appInfo, data.compatInfo);
        if ((data.appInfo.flags & 0x2000) == 0) {
            this.mDensityCompatMode = true;
            Bitmap.setDefaultDensity(160);
        }
        this.updateDefaultDensity();
        boolean is24Hr = "24".equals(this.mCoreSettings.getString("time_12_24"));
        DateFormat.set24HourTimePref((boolean)is24Hr);
        boolean bl = View.mDebugViewAttributes = this.mCoreSettings.getInt("debug_view_attributes", 0) != 0;
        if ((data.appInfo.flags & 0x81) != 0) {
            StrictMode.conditionallyEnableDebugLogging();
        }
        if (data.appInfo.targetSdkVersion >= 11) {
            StrictMode.enableDeathOnNetwork();
        }
        if (data.appInfo.targetSdkVersion >= 24) {
            StrictMode.enableDeathOnFileUriExposure();
        }
        NetworkSecurityPolicy.getInstance().setCleartextTrafficPermitted((data.appInfo.flags & 0x8000000) != 0);
        if (data.debugMode != 0) {
            Debug.changeDebugPort(8100);
            if (data.debugMode == 2) {
                Slog.w(TAG, "Application " + data.info.getPackageName() + " is waiting for the debugger on port 8100...");
                IActivityManager mgr = ActivityManagerNative.getDefault();
                try {
                    mgr.showWaitingForDebugger(this.mAppThread, true);
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
                Debug.waitForDebugger();
                try {
                    mgr.showWaitingForDebugger(this.mAppThread, false);
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
            }
            Slog.w(TAG, "Application " + data.info.getPackageName() + " can be debugged on port 8100...");
        }
        boolean isAppDebuggable = (data.appInfo.flags & 2) != 0;
        Trace.setAppTracingAllowed(isAppDebuggable);
        if (isAppDebuggable && data.enableBinderTracking) {
            Binder.enableTracing();
        }
        Trace.traceBegin(64L, "Setup proxies");
        IBinder b = ServiceManager.getService("connectivity");
        if (b != null) {
            IConnectivityManager service = IConnectivityManager.Stub.asInterface(b);
            try {
                ProxyInfo proxyInfo = service.getProxyForNetwork(null);
                Proxy.setHttpProxySystemProperty(proxyInfo);
            }
            catch (RemoteException e) {
                Trace.traceEnd(64L);
                throw e.rethrowFromSystemServer();
            }
        }
        Trace.traceEnd(64L);
        if (data.instrumentationName != null) {
            try {
                ii = new ApplicationPackageManager(null, ActivityThread.getPackageManager()).getInstrumentationInfo(data.instrumentationName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new RuntimeException("Unable to find instrumentation info for: " + data.instrumentationName);
            }
            this.mInstrumentationPackageName = ii.packageName;
            this.mInstrumentationAppDir = ii.sourceDir;
            this.mInstrumentationSplitAppDirs = ii.splitSourceDirs;
            this.mInstrumentationLibDir = this.getInstrumentationLibrary(data.appInfo, ii);
            this.mInstrumentedAppDir = data.info.getAppDir();
            this.mInstrumentedSplitAppDirs = data.info.getSplitAppDirs();
            this.mInstrumentedLibDir = data.info.getLibDir();
        } else {
            ii = null;
        }
        ContextImpl appContext = ContextImpl.createAppContext(this, data.info);
        this.updateLocaleListFromAppContext(appContext, this.mResourcesManager.getConfiguration().getLocales());
        if (!Process.isIsolated() && !"android".equals(appContext.getPackageName())) {
            File cacheDir = appContext.getCacheDir();
            if (cacheDir != null) {
                System.setProperty("java.io.tmpdir", cacheDir.getAbsolutePath());
            } else {
                Log.v(TAG, "Unable to initialize \"java.io.tmpdir\" property due to missing cache directory");
            }
            Context deviceContext = appContext.createDeviceProtectedStorageContext();
            File codeCacheDir = deviceContext.getCodeCacheDir();
            if (codeCacheDir != null) {
                this.setupGraphicsSupport(data.info, codeCacheDir);
            } else {
                Log.e(TAG, "Unable to setupGraphicsSupport due to missing code-cache directory");
            }
        }
        Trace.traceBegin(64L, "NetworkSecurityConfigProvider.install");
        NetworkSecurityConfigProvider.install(appContext);
        Trace.traceEnd(64L);
        if (ii != null) {
            ApplicationInfo instrApp = new ApplicationInfo();
            ii.copyTo(instrApp);
            instrApp.initForUser(UserHandle.myUserId());
            LoadedApk pi = this.getPackageInfo(instrApp, data.compatInfo, appContext.getClassLoader(), false, true, false);
            ContextImpl instrContext = ContextImpl.createAppContext(this, pi);
            try {
                ClassLoader cl = instrContext.getClassLoader();
                this.mInstrumentation = (Instrumentation)cl.loadClass(data.instrumentationName.getClassName()).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate instrumentation " + data.instrumentationName + ": " + e.toString(), e);
            }
            ComponentName component = new ComponentName(ii.packageName, ii.name);
            this.mInstrumentation.init(this, instrContext, appContext, component, data.instrumentationWatcher, data.instrumentationUiAutomationConnection);
            if (this.mProfiler.profileFile != null && !ii.handleProfiling && this.mProfiler.profileFd == null) {
                this.mProfiler.handlingProfiling = true;
                File file = new File(this.mProfiler.profileFile);
                file.getParentFile().mkdirs();
                Debug.startMethodTracing(file.toString(), 0x800000);
            }
        } else {
            this.mInstrumentation = new Instrumentation();
        }
        if ((data.appInfo.flags & 0x100000) != 0) {
            VMRuntime.getRuntime().clearGrowthLimit();
        } else {
            VMRuntime.getRuntime().clampGrowthLimit();
        }
        StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskWrites();
        try {
            Application app;
            this.mInitialApplication = app = data.info.makeApplication(data.restrictedBackupMode, null);
            if (!data.restrictedBackupMode && !ArrayUtils.isEmpty(data.providers)) {
                this.installContentProviders(app, data.providers);
                this.mH.sendEmptyMessageDelayed(132, 10000L);
            }
            try {
                this.mInstrumentation.onCreate(data.instrumentationArgs);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception thrown in onCreate() of " + data.instrumentationName + ": " + e.toString(), e);
            }
            try {
                this.mInstrumentation.callApplicationOnCreate(app);
            }
            catch (Exception e) {
                if (!this.mInstrumentation.onException(app, e)) {
                    throw new RuntimeException("Unable to create application " + app.getClass().getName() + ": " + e.toString(), e);
                }
            }
        }
        finally {
            StrictMode.setThreadPolicy(savedPolicy);
        }
    }

    void finishInstrumentation(int resultCode, Bundle results) {
        IActivityManager am = ActivityManagerNative.getDefault();
        if (this.mProfiler.profileFile != null && this.mProfiler.handlingProfiling && this.mProfiler.profileFd == null) {
            Debug.stopMethodTracing();
        }
        try {
            am.finishInstrumentation(this.mAppThread, resultCode, results);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private void installContentProviders(Context context, List<ProviderInfo> providers) {
        ArrayList<IActivityManager.ContentProviderHolder> results = new ArrayList<IActivityManager.ContentProviderHolder>();
        for (ProviderInfo cpi : providers) {
            IActivityManager.ContentProviderHolder cph = this.installProvider(context, null, cpi, false, true, true);
            if (cph == null) continue;
            cph.noReleaseNeeded = true;
            results.add(cph);
        }
        try {
            ActivityManagerNative.getDefault().publishContentProviders(this.getApplicationThread(), results);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public IContentProvider acquireProvider(Context c, String auth, int userId, boolean stable) {
        IContentProvider provider = this.acquireExistingProvider(c, auth, userId, stable);
        if (provider != null) {
            return provider;
        }
        IActivityManager.ContentProviderHolder holder = null;
        try {
            holder = ActivityManagerNative.getDefault().getContentProvider(this.getApplicationThread(), auth, userId, stable);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
        if (holder == null) {
            Slog.e(TAG, "Failed to find provider info for " + auth);
            return null;
        }
        holder = this.installProvider(c, holder, holder.info, true, holder.noReleaseNeeded, stable);
        return holder.provider;
    }

    private void incProviderRefLocked(ProviderRefCount prc, boolean stable) {
        if (stable) {
            ++prc.stableCount;
            if (prc.stableCount == 1) {
                int unstableDelta;
                if (prc.removePending) {
                    unstableDelta = -1;
                    prc.removePending = false;
                    this.mH.removeMessages(131, prc);
                } else {
                    unstableDelta = 0;
                }
                try {
                    ActivityManagerNative.getDefault().refContentProvider(prc.holder.connection, 1, unstableDelta);
                }
                catch (RemoteException remoteException) {}
            }
        } else {
            ++prc.unstableCount;
            if (prc.unstableCount == 1) {
                if (prc.removePending) {
                    prc.removePending = false;
                    this.mH.removeMessages(131, prc);
                } else {
                    try {
                        ActivityManagerNative.getDefault().refContentProvider(prc.holder.connection, 0, 1);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContentProvider acquireExistingProvider(Context c, String auth, int userId, boolean stable) {
        ArrayMap<ProviderKey, ProviderClientRecord> arrayMap = this.mProviderMap;
        synchronized (arrayMap) {
            ProviderKey key = new ProviderKey(auth, userId);
            ProviderClientRecord pr = this.mProviderMap.get(key);
            if (pr == null) {
                return null;
            }
            IContentProvider provider = pr.mProvider;
            IBinder jBinder = provider.asBinder();
            if (!jBinder.isBinderAlive()) {
                Log.i(TAG, "Acquiring provider " + auth + " for user " + userId + ": existing object's process dead");
                this.handleUnstableProviderDiedLocked(jBinder, true);
                return null;
            }
            ProviderRefCount prc = this.mProviderRefCountMap.get(jBinder);
            if (prc != null) {
                this.incProviderRefLocked(prc, stable);
            }
            return provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseProvider(IContentProvider provider, boolean stable) {
        if (provider == null) {
            return false;
        }
        IBinder jBinder = provider.asBinder();
        ArrayMap<ProviderKey, ProviderClientRecord> arrayMap = this.mProviderMap;
        synchronized (arrayMap) {
            ProviderRefCount prc = this.mProviderRefCountMap.get(jBinder);
            if (prc == null) {
                return false;
            }
            boolean lastRef = false;
            if (stable) {
                if (prc.stableCount == 0) {
                    return false;
                }
                --prc.stableCount;
                if (prc.stableCount == 0) {
                    lastRef = prc.unstableCount == 0;
                    try {
                        ActivityManagerNative.getDefault().refContentProvider(prc.holder.connection, -1, lastRef ? 1 : 0);
                    }
                    catch (RemoteException remoteException) {}
                }
            } else {
                if (prc.unstableCount == 0) {
                    return false;
                }
                --prc.unstableCount;
                if (prc.unstableCount == 0) {
                    boolean bl = lastRef = prc.stableCount == 0;
                    if (!lastRef) {
                        try {
                            ActivityManagerNative.getDefault().refContentProvider(prc.holder.connection, 0, -1);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (lastRef) {
                if (!prc.removePending) {
                    prc.removePending = true;
                    Message msg = this.mH.obtainMessage(131, prc);
                    this.mH.sendMessage(msg);
                } else {
                    Slog.w(TAG, "Duplicate remove pending of provider " + prc.holder.info.name);
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeRemoveProvider(ProviderRefCount prc) {
        ArrayMap<ProviderKey, ProviderClientRecord> arrayMap = this.mProviderMap;
        synchronized (arrayMap) {
            if (!prc.removePending) {
                return;
            }
            prc.removePending = false;
            IBinder jBinder = prc.holder.provider.asBinder();
            ProviderRefCount existingPrc = this.mProviderRefCountMap.get(jBinder);
            if (existingPrc == prc) {
                this.mProviderRefCountMap.remove(jBinder);
            }
            for (int i = this.mProviderMap.size() - 1; i >= 0; --i) {
                ProviderClientRecord pr = this.mProviderMap.valueAt(i);
                IBinder myBinder = pr.mProvider.asBinder();
                if (myBinder != jBinder) continue;
                this.mProviderMap.removeAt(i);
            }
        }
        try {
            ActivityManagerNative.getDefault().removeContentProvider(prc.holder.connection, false);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUnstableProviderDied(IBinder provider, boolean fromClient) {
        ArrayMap<ProviderKey, ProviderClientRecord> arrayMap = this.mProviderMap;
        synchronized (arrayMap) {
            this.handleUnstableProviderDiedLocked(provider, fromClient);
        }
    }

    void handleUnstableProviderDiedLocked(IBinder provider, boolean fromClient) {
        ProviderRefCount prc = this.mProviderRefCountMap.get(provider);
        if (prc != null) {
            this.mProviderRefCountMap.remove(provider);
            for (int i = this.mProviderMap.size() - 1; i >= 0; --i) {
                ProviderClientRecord pr = this.mProviderMap.valueAt(i);
                if (pr == null || pr.mProvider.asBinder() != provider) continue;
                Slog.i(TAG, "Removing dead content provider:" + pr.mProvider.toString());
                this.mProviderMap.removeAt(i);
            }
            if (fromClient) {
                try {
                    ActivityManagerNative.getDefault().unstableProviderDied(prc.holder.connection);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appNotRespondingViaProvider(IBinder provider) {
        ArrayMap<ProviderKey, ProviderClientRecord> arrayMap = this.mProviderMap;
        synchronized (arrayMap) {
            ProviderRefCount prc = this.mProviderRefCountMap.get(provider);
            if (prc != null) {
                try {
                    ActivityManagerNative.getDefault().appNotRespondingViaProvider(prc.holder.connection);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    private ProviderClientRecord installProviderAuthoritiesLocked(IContentProvider provider, ContentProvider localProvider, IActivityManager.ContentProviderHolder holder) {
        String[] auths = holder.info.authority.split(";");
        int userId = UserHandle.getUserId(holder.info.applicationInfo.uid);
        ProviderClientRecord pcr = new ProviderClientRecord(auths, provider, localProvider, holder);
        for (String auth : auths) {
            ProviderKey key = new ProviderKey(auth, userId);
            ProviderClientRecord existing = this.mProviderMap.get(key);
            if (existing != null) {
                Slog.w(TAG, "Content provider " + pcr.mHolder.info.name + " already published as " + auth);
                continue;
            }
            this.mProviderMap.put(key, pcr);
        }
        return pcr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IActivityManager.ContentProviderHolder installProvider(Context context, IActivityManager.ContentProviderHolder holder, ProviderInfo info, boolean noisy, boolean noReleaseNeeded, boolean stable) {
        IActivityManager.ContentProviderHolder retHolder;
        IContentProvider provider;
        ContentProvider localProvider = null;
        if (holder == null || holder.provider == null) {
            if (noisy) {
                Slog.d(TAG, "Loading provider " + info.authority + ": " + info.name);
            }
            Context c = null;
            ApplicationInfo ai = info.applicationInfo;
            if (context.getPackageName().equals(ai.packageName)) {
                c = context;
            } else if (this.mInitialApplication != null && this.mInitialApplication.getPackageName().equals(ai.packageName)) {
                c = this.mInitialApplication;
            } else {
                try {
                    c = context.createPackageContext(ai.packageName, 1);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            if (c == null) {
                Slog.w(TAG, "Unable to get context for package " + ai.packageName + " while loading content provider " + info.name);
                return null;
            }
            try {
                ClassLoader cl = c.getClassLoader();
                localProvider = (ContentProvider)cl.loadClass(info.name).newInstance();
                provider = localProvider.getIContentProvider();
                if (provider == null) {
                    Slog.e(TAG, "Failed to instantiate class " + info.name + " from sourceDir " + info.applicationInfo.sourceDir);
                    return null;
                }
                localProvider.attachInfo(c, info);
            }
            catch (Exception e) {
                if (!this.mInstrumentation.onException(null, e)) {
                    throw new RuntimeException("Unable to get provider " + info.name + ": " + e.toString(), e);
                }
                return null;
            }
        }
        provider = holder.provider;
        ArrayMap<ProviderKey, ProviderClientRecord> arrayMap = this.mProviderMap;
        synchronized (arrayMap) {
            IBinder jBinder = provider.asBinder();
            if (localProvider != null) {
                ComponentName cname = new ComponentName(info.packageName, info.name);
                ProviderClientRecord pr = this.mLocalProvidersByName.get(cname);
                if (pr != null) {
                    provider = pr.mProvider;
                } else {
                    holder = new IActivityManager.ContentProviderHolder(info);
                    holder.provider = provider;
                    holder.noReleaseNeeded = true;
                    pr = this.installProviderAuthoritiesLocked(provider, localProvider, holder);
                    this.mLocalProviders.put(jBinder, pr);
                    this.mLocalProvidersByName.put(cname, pr);
                }
                retHolder = pr.mHolder;
            } else {
                ProviderRefCount prc = this.mProviderRefCountMap.get(jBinder);
                if (prc != null) {
                    if (!noReleaseNeeded) {
                        this.incProviderRefLocked(prc, stable);
                        try {
                            ActivityManagerNative.getDefault().removeContentProvider(holder.connection, stable);
                        }
                        catch (RemoteException pr) {}
                    }
                } else {
                    ProviderClientRecord client = this.installProviderAuthoritiesLocked(provider, localProvider, holder);
                    prc = noReleaseNeeded ? new ProviderRefCount(holder, client, 1000, 1000) : (stable ? new ProviderRefCount(holder, client, 1, 0) : new ProviderRefCount(holder, client, 0, 1));
                    this.mProviderRefCountMap.put(jBinder, prc);
                }
                retHolder = prc.holder;
            }
        }
        return retHolder;
    }

    private void attach(boolean system) {
        sCurrentActivityThread = this;
        this.mSystemThread = system;
        if (!system) {
            ViewRootImpl.addFirstDrawHandler(new Runnable(){

                @Override
                public void run() {
                    ActivityThread.this.ensureJitEnabled();
                }
            });
            DdmHandleAppName.setAppName("<pre-initialized>", UserHandle.myUserId());
            RuntimeInit.setApplicationObject(this.mAppThread.asBinder());
            final IActivityManager mgr = ActivityManagerNative.getDefault();
            try {
                mgr.attachApplication(this.mAppThread);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
            BinderInternal.addGcWatcher(new Runnable(){

                @Override
                public void run() {
                    if (!ActivityThread.this.mSomeActivitiesChanged) {
                        return;
                    }
                    Runtime runtime = Runtime.getRuntime();
                    long dalvikMax = runtime.maxMemory();
                    long dalvikUsed = runtime.totalMemory() - runtime.freeMemory();
                    if (dalvikUsed > 3L * dalvikMax / 4L) {
                        ActivityThread.this.mSomeActivitiesChanged = false;
                        try {
                            mgr.releaseSomeActivities(ActivityThread.this.mAppThread);
                        }
                        catch (RemoteException e) {
                            throw e.rethrowFromSystemServer();
                        }
                    }
                }
            });
        } else {
            DdmHandleAppName.setAppName("system_process", UserHandle.myUserId());
            try {
                this.mInstrumentation = new Instrumentation();
                ContextImpl context = ContextImpl.createAppContext(this, this.getSystemContext().mPackageInfo);
                this.mInitialApplication = context.mPackageInfo.makeApplication(true, null);
                this.mInitialApplication.onCreate();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate Application():" + e.toString(), e);
            }
        }
        DropBox.setReporter(new DropBoxReporter());
        ViewRootImpl.addConfigCallback(new ComponentCallbacks2(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfigurationChanged(Configuration newConfig) {
                ResourcesManager resourcesManager = ActivityThread.this.mResourcesManager;
                synchronized (resourcesManager) {
                    if (ActivityThread.this.mResourcesManager.applyConfigurationToResourcesLocked(newConfig, null)) {
                        ActivityThread.this.updateLocaleListFromAppContext(ActivityThread.this.mInitialApplication.getApplicationContext(), ActivityThread.this.mResourcesManager.getConfiguration().getLocales());
                        if (ActivityThread.this.mPendingConfiguration == null || ActivityThread.this.mPendingConfiguration.isOtherSeqNewer(newConfig)) {
                            ActivityThread.this.mPendingConfiguration = newConfig;
                            ActivityThread.this.sendMessage(118, newConfig);
                        }
                    }
                }
            }

            @Override
            public void onLowMemory() {
            }

            @Override
            public void onTrimMemory(int level) {
            }
        });
    }

    public static ActivityThread systemMain() {
        if (!ActivityManager.isHighEndGfx()) {
            ThreadedRenderer.disable(true);
        } else {
            ThreadedRenderer.enableForegroundTrimming();
        }
        ActivityThread thread = new ActivityThread();
        thread.attach(true);
        return thread;
    }

    public void installSystemProviders(List<ProviderInfo> providers) {
        if (providers != null) {
            this.installContentProviders(this.mInitialApplication, providers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntCoreSetting(String key, int defaultValue) {
        ResourcesManager resourcesManager = this.mResourcesManager;
        synchronized (resourcesManager) {
            if (this.mCoreSettings != null) {
                return this.mCoreSettings.getInt(key, defaultValue);
            }
            return defaultValue;
        }
    }

    public static void main(String[] args) {
        Trace.traceBegin(64L, "ActivityThreadMain");
        SamplingProfilerIntegration.start();
        CloseGuard.setEnabled(false);
        Environment.initForCurrentUser();
        EventLogger.setReporter(new EventLoggingReporter());
        File configDir = Environment.getUserConfigDirectory(UserHandle.myUserId());
        TrustedCertificateStore.setDefaultUserDirectory((File)configDir);
        Process.setArgV0("<pre-initialized>");
        Looper.prepareMainLooper();
        ActivityThread thread = new ActivityThread();
        thread.attach(false);
        if (sMainThreadHandler == null) {
            sMainThreadHandler = thread.getHandler();
        }
        Trace.traceEnd(64L);
        Looper.loop();
        throw new RuntimeException("Main thread loop unexpectedly exited");
    }

    static {
        sCurrentBroadcastIntent = new ThreadLocal();
    }

    private class DropBoxReporter
    implements DropBox.Reporter {
        private DropBoxManager dropBox;

        @Override
        public void addData(String tag, byte[] data, int flags) {
            this.ensureInitialized();
            this.dropBox.addData(tag, data, flags);
        }

        @Override
        public void addText(String tag, String data) {
            this.ensureInitialized();
            this.dropBox.addText(tag, data);
        }

        private synchronized void ensureInitialized() {
            if (this.dropBox == null) {
                this.dropBox = (DropBoxManager)ActivityThread.this.getSystemContext().getSystemService("dropbox");
            }
        }
    }

    private static class EventLoggingReporter
    implements EventLogger.Reporter {
        private EventLoggingReporter() {
        }

        @Override
        public void report(int code, Object ... list) {
            EventLog.writeEvent(code, list);
        }
    }

    private static class ProviderRefCount {
        public final IActivityManager.ContentProviderHolder holder;
        public final ProviderClientRecord client;
        public int stableCount;
        public int unstableCount;
        public boolean removePending;

        ProviderRefCount(IActivityManager.ContentProviderHolder inHolder, ProviderClientRecord inClient, int sCount, int uCount) {
            this.holder = inHolder;
            this.client = inClient;
            this.stableCount = sCount;
            this.unstableCount = uCount;
        }
    }

    private static class StopInfo
    implements Runnable {
        ActivityClientRecord activity;
        Bundle state;
        PersistableBundle persistentState;
        CharSequence description;

        private StopInfo() {
        }

        @Override
        public void run() {
            try {
                ActivityManagerNative.getDefault().activityStopped(this.activity.token, this.state, this.persistentState, this.description);
            }
            catch (RemoteException ex) {
                if (ex instanceof TransactionTooLargeException && this.activity.packageInfo.getTargetSdkVersion() < 24) {
                    Log.e(ActivityThread.TAG, "App sent too much data in instance state, so it was ignored", ex);
                    return;
                }
                throw ex.rethrowFromSystemServer();
            }
        }
    }

    class GcIdler
    implements MessageQueue.IdleHandler {
        GcIdler() {
        }

        @Override
        public boolean queueIdle() {
            ActivityThread.this.doGcIfNeeded();
            return false;
        }
    }

    private class Idler
    implements MessageQueue.IdleHandler {
        private Idler() {
        }

        @Override
        public boolean queueIdle() {
            ActivityClientRecord a = ActivityThread.this.mNewActivities;
            boolean stopProfiling = false;
            if (ActivityThread.this.mBoundApplication != null && ActivityThread.this.mProfiler.profileFd != null && ActivityThread.this.mProfiler.autoStopProfiler) {
                stopProfiling = true;
            }
            if (a != null) {
                ActivityThread.this.mNewActivities = null;
                IActivityManager am = ActivityManagerNative.getDefault();
                do {
                    if (a.activity != null && !a.activity.mFinished) {
                        try {
                            am.activityIdle(a.token, a.createdConfig, stopProfiling);
                            a.createdConfig = null;
                        }
                        catch (RemoteException ex) {
                            throw ex.rethrowFromSystemServer();
                        }
                    }
                    ActivityClientRecord prev = a;
                    a = a.nextIdle;
                    prev.nextIdle = null;
                } while (a != null);
            }
            if (stopProfiling) {
                ActivityThread.this.mProfiler.stopProfiling();
            }
            ActivityThread.this.ensureJitEnabled();
            return false;
        }
    }

    private class H
    extends Handler {
        public static final int LAUNCH_ACTIVITY = 100;
        public static final int PAUSE_ACTIVITY = 101;
        public static final int PAUSE_ACTIVITY_FINISHING = 102;
        public static final int STOP_ACTIVITY_SHOW = 103;
        public static final int STOP_ACTIVITY_HIDE = 104;
        public static final int SHOW_WINDOW = 105;
        public static final int HIDE_WINDOW = 106;
        public static final int RESUME_ACTIVITY = 107;
        public static final int SEND_RESULT = 108;
        public static final int DESTROY_ACTIVITY = 109;
        public static final int BIND_APPLICATION = 110;
        public static final int EXIT_APPLICATION = 111;
        public static final int NEW_INTENT = 112;
        public static final int RECEIVER = 113;
        public static final int CREATE_SERVICE = 114;
        public static final int SERVICE_ARGS = 115;
        public static final int STOP_SERVICE = 116;
        public static final int CONFIGURATION_CHANGED = 118;
        public static final int CLEAN_UP_CONTEXT = 119;
        public static final int GC_WHEN_IDLE = 120;
        public static final int BIND_SERVICE = 121;
        public static final int UNBIND_SERVICE = 122;
        public static final int DUMP_SERVICE = 123;
        public static final int LOW_MEMORY = 124;
        public static final int ACTIVITY_CONFIGURATION_CHANGED = 125;
        public static final int RELAUNCH_ACTIVITY = 126;
        public static final int PROFILER_CONTROL = 127;
        public static final int CREATE_BACKUP_AGENT = 128;
        public static final int DESTROY_BACKUP_AGENT = 129;
        public static final int SUICIDE = 130;
        public static final int REMOVE_PROVIDER = 131;
        public static final int ENABLE_JIT = 132;
        public static final int DISPATCH_PACKAGE_BROADCAST = 133;
        public static final int SCHEDULE_CRASH = 134;
        public static final int DUMP_HEAP = 135;
        public static final int DUMP_ACTIVITY = 136;
        public static final int SLEEPING = 137;
        public static final int SET_CORE_SETTINGS = 138;
        public static final int UPDATE_PACKAGE_COMPATIBILITY_INFO = 139;
        public static final int TRIM_MEMORY = 140;
        public static final int DUMP_PROVIDER = 141;
        public static final int UNSTABLE_PROVIDER_DIED = 142;
        public static final int REQUEST_ASSIST_CONTEXT_EXTRAS = 143;
        public static final int TRANSLUCENT_CONVERSION_COMPLETE = 144;
        public static final int INSTALL_PROVIDER = 145;
        public static final int ON_NEW_ACTIVITY_OPTIONS = 146;
        public static final int CANCEL_VISIBLE_BEHIND = 147;
        public static final int BACKGROUND_VISIBLE_BEHIND_CHANGED = 148;
        public static final int ENTER_ANIMATION_COMPLETE = 149;
        public static final int START_BINDER_TRACKING = 150;
        public static final int STOP_BINDER_TRACKING_AND_DUMP = 151;
        public static final int MULTI_WINDOW_MODE_CHANGED = 152;
        public static final int PICTURE_IN_PICTURE_MODE_CHANGED = 153;
        public static final int LOCAL_VOICE_INTERACTION_STARTED = 154;

        private H() {
        }

        String codeToString(int code) {
            return Integer.toString(code);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    Trace.traceBegin(64L, "activityStart");
                    ActivityClientRecord r = (ActivityClientRecord)msg.obj;
                    r.packageInfo = ActivityThread.this.getPackageInfoNoCheck(r.activityInfo.applicationInfo, r.compatInfo);
                    ActivityThread.this.handleLaunchActivity(r, null, "LAUNCH_ACTIVITY");
                    Trace.traceEnd(64L);
                    break;
                }
                case 126: {
                    Trace.traceBegin(64L, "activityRestart");
                    ActivityClientRecord r = (ActivityClientRecord)msg.obj;
                    ActivityThread.this.handleRelaunchActivity(r);
                    Trace.traceEnd(64L);
                    break;
                }
                case 101: {
                    Trace.traceBegin(64L, "activityPause");
                    SomeArgs args = (SomeArgs)msg.obj;
                    ActivityThread.this.handlePauseActivity((IBinder)args.arg1, false, (args.argi1 & 1) != 0, args.argi2, (args.argi1 & 2) != 0, args.argi3);
                    this.maybeSnapshot();
                    Trace.traceEnd(64L);
                    break;
                }
                case 102: {
                    Trace.traceBegin(64L, "activityPause");
                    SomeArgs args = (SomeArgs)msg.obj;
                    ActivityThread.this.handlePauseActivity((IBinder)args.arg1, true, (args.argi1 & 1) != 0, args.argi2, (args.argi1 & 2) != 0, args.argi3);
                    Trace.traceEnd(64L);
                    break;
                }
                case 103: {
                    Trace.traceBegin(64L, "activityStop");
                    SomeArgs args = (SomeArgs)msg.obj;
                    ActivityThread.this.handleStopActivity((IBinder)args.arg1, true, args.argi2, args.argi3);
                    Trace.traceEnd(64L);
                    break;
                }
                case 104: {
                    Trace.traceBegin(64L, "activityStop");
                    SomeArgs args = (SomeArgs)msg.obj;
                    ActivityThread.this.handleStopActivity((IBinder)args.arg1, false, args.argi2, args.argi3);
                    Trace.traceEnd(64L);
                    break;
                }
                case 105: {
                    Trace.traceBegin(64L, "activityShowWindow");
                    ActivityThread.this.handleWindowVisibility((IBinder)msg.obj, true);
                    Trace.traceEnd(64L);
                    break;
                }
                case 106: {
                    Trace.traceBegin(64L, "activityHideWindow");
                    ActivityThread.this.handleWindowVisibility((IBinder)msg.obj, false);
                    Trace.traceEnd(64L);
                    break;
                }
                case 107: {
                    Trace.traceBegin(64L, "activityResume");
                    SomeArgs args = (SomeArgs)msg.obj;
                    ActivityThread.this.handleResumeActivity((IBinder)args.arg1, true, args.argi1 != 0, true, args.argi3, "RESUME_ACTIVITY");
                    Trace.traceEnd(64L);
                    break;
                }
                case 108: {
                    Trace.traceBegin(64L, "activityDeliverResult");
                    ActivityThread.this.handleSendResult((ResultData)msg.obj);
                    Trace.traceEnd(64L);
                    break;
                }
                case 109: {
                    Trace.traceBegin(64L, "activityDestroy");
                    ActivityThread.this.handleDestroyActivity((IBinder)msg.obj, msg.arg1 != 0, msg.arg2, false);
                    Trace.traceEnd(64L);
                    break;
                }
                case 110: {
                    Trace.traceBegin(64L, "bindApplication");
                    AppBindData data = (AppBindData)msg.obj;
                    ActivityThread.this.handleBindApplication(data);
                    Trace.traceEnd(64L);
                    break;
                }
                case 111: {
                    if (ActivityThread.this.mInitialApplication != null) {
                        ActivityThread.this.mInitialApplication.onTerminate();
                    }
                    Looper.myLooper().quit();
                    break;
                }
                case 112: {
                    Trace.traceBegin(64L, "activityNewIntent");
                    ActivityThread.this.handleNewIntent((NewIntentData)msg.obj);
                    Trace.traceEnd(64L);
                    break;
                }
                case 113: {
                    Trace.traceBegin(64L, "broadcastReceiveComp");
                    ActivityThread.this.handleReceiver((ReceiverData)msg.obj);
                    this.maybeSnapshot();
                    Trace.traceEnd(64L);
                    break;
                }
                case 114: {
                    Trace.traceBegin(64L, "serviceCreate: " + String.valueOf(msg.obj));
                    ActivityThread.this.handleCreateService((CreateServiceData)msg.obj);
                    Trace.traceEnd(64L);
                    break;
                }
                case 121: {
                    Trace.traceBegin(64L, "serviceBind");
                    ActivityThread.this.handleBindService((BindServiceData)msg.obj);
                    Trace.traceEnd(64L);
                    break;
                }
                case 122: {
                    Trace.traceBegin(64L, "serviceUnbind");
                    ActivityThread.this.handleUnbindService((BindServiceData)msg.obj);
                    Trace.traceEnd(64L);
                    break;
                }
                case 115: {
                    Trace.traceBegin(64L, "serviceStart: " + String.valueOf(msg.obj));
                    ActivityThread.this.handleServiceArgs((ServiceArgsData)msg.obj);
                    Trace.traceEnd(64L);
                    break;
                }
                case 116: {
                    Trace.traceBegin(64L, "serviceStop");
                    ActivityThread.this.handleStopService((IBinder)msg.obj);
                    this.maybeSnapshot();
                    Trace.traceEnd(64L);
                    break;
                }
                case 118: {
                    Trace.traceBegin(64L, "configChanged");
                    ActivityThread.this.mCurDefaultDisplayDpi = ((Configuration)msg.obj).densityDpi;
                    ActivityThread.this.handleConfigurationChanged((Configuration)msg.obj, null);
                    Trace.traceEnd(64L);
                    break;
                }
                case 119: {
                    ContextCleanupInfo cci = (ContextCleanupInfo)msg.obj;
                    cci.context.performFinalCleanup(cci.who, cci.what);
                    break;
                }
                case 120: {
                    ActivityThread.this.scheduleGcIdler();
                    break;
                }
                case 123: {
                    ActivityThread.this.handleDumpService((DumpComponentInfo)msg.obj);
                    break;
                }
                case 124: {
                    Trace.traceBegin(64L, "lowMemory");
                    ActivityThread.this.handleLowMemory();
                    Trace.traceEnd(64L);
                    break;
                }
                case 125: {
                    Trace.traceBegin(64L, "activityConfigChanged");
                    ActivityThread.this.handleActivityConfigurationChanged((ActivityConfigChangeData)msg.obj, msg.arg1 == 1);
                    Trace.traceEnd(64L);
                    break;
                }
                case 127: {
                    ActivityThread.this.handleProfilerControl(msg.arg1 != 0, (ProfilerInfo)msg.obj, msg.arg2);
                    break;
                }
                case 128: {
                    Trace.traceBegin(64L, "backupCreateAgent");
                    ActivityThread.this.handleCreateBackupAgent((CreateBackupAgentData)msg.obj);
                    Trace.traceEnd(64L);
                    break;
                }
                case 129: {
                    Trace.traceBegin(64L, "backupDestroyAgent");
                    ActivityThread.this.handleDestroyBackupAgent((CreateBackupAgentData)msg.obj);
                    Trace.traceEnd(64L);
                    break;
                }
                case 130: {
                    Process.killProcess(Process.myPid());
                    break;
                }
                case 131: {
                    Trace.traceBegin(64L, "providerRemove");
                    ActivityThread.this.completeRemoveProvider((ProviderRefCount)msg.obj);
                    Trace.traceEnd(64L);
                    break;
                }
                case 132: {
                    ActivityThread.this.ensureJitEnabled();
                    break;
                }
                case 133: {
                    Trace.traceBegin(64L, "broadcastPackage");
                    ActivityThread.this.handleDispatchPackageBroadcast(msg.arg1, (String[])msg.obj);
                    Trace.traceEnd(64L);
                    break;
                }
                case 134: {
                    throw new RemoteServiceException((String)msg.obj);
                }
                case 135: {
                    ActivityThread.handleDumpHeap(msg.arg1 != 0, (DumpHeapData)msg.obj);
                    break;
                }
                case 136: {
                    ActivityThread.this.handleDumpActivity((DumpComponentInfo)msg.obj);
                    break;
                }
                case 141: {
                    ActivityThread.this.handleDumpProvider((DumpComponentInfo)msg.obj);
                    break;
                }
                case 137: {
                    Trace.traceBegin(64L, "sleeping");
                    ActivityThread.this.handleSleeping((IBinder)msg.obj, msg.arg1 != 0);
                    Trace.traceEnd(64L);
                    break;
                }
                case 138: {
                    Trace.traceBegin(64L, "setCoreSettings");
                    ActivityThread.this.handleSetCoreSettings((Bundle)msg.obj);
                    Trace.traceEnd(64L);
                    break;
                }
                case 139: {
                    ActivityThread.this.handleUpdatePackageCompatibilityInfo((UpdateCompatibilityData)msg.obj);
                    break;
                }
                case 140: {
                    Trace.traceBegin(64L, "trimMemory");
                    ActivityThread.this.handleTrimMemory(msg.arg1);
                    Trace.traceEnd(64L);
                    break;
                }
                case 142: {
                    ActivityThread.this.handleUnstableProviderDied((IBinder)msg.obj, false);
                    break;
                }
                case 143: {
                    ActivityThread.this.handleRequestAssistContextExtras((RequestAssistContextExtras)msg.obj);
                    break;
                }
                case 144: {
                    ActivityThread.this.handleTranslucentConversionComplete((IBinder)msg.obj, msg.arg1 == 1);
                    break;
                }
                case 145: {
                    ActivityThread.this.handleInstallProvider((ProviderInfo)msg.obj);
                    break;
                }
                case 146: {
                    Pair pair = (Pair)msg.obj;
                    ActivityThread.this.onNewActivityOptions((IBinder)pair.first, (ActivityOptions)pair.second);
                    break;
                }
                case 147: {
                    ActivityThread.this.handleCancelVisibleBehind((IBinder)msg.obj);
                    break;
                }
                case 148: {
                    ActivityThread.this.handleOnBackgroundVisibleBehindChanged((IBinder)msg.obj, msg.arg1 > 0);
                    break;
                }
                case 149: {
                    ActivityThread.this.handleEnterAnimationComplete((IBinder)msg.obj);
                    break;
                }
                case 150: {
                    ActivityThread.this.handleStartBinderTracking();
                    break;
                }
                case 151: {
                    ActivityThread.this.handleStopBinderTrackingAndDump((ParcelFileDescriptor)msg.obj);
                    break;
                }
                case 152: {
                    ActivityThread.this.handleMultiWindowModeChanged((IBinder)msg.obj, msg.arg1 == 1);
                    break;
                }
                case 153: {
                    ActivityThread.this.handlePictureInPictureModeChanged((IBinder)msg.obj, msg.arg1 == 1);
                    break;
                }
                case 154: {
                    ActivityThread.this.handleLocalVoiceInteractionStarted((IBinder)((SomeArgs)msg.obj).arg1, (IVoiceInteractor)((SomeArgs)msg.obj).arg2);
                }
            }
            Object obj = msg.obj;
            if (obj instanceof SomeArgs) {
                ((SomeArgs)obj).recycle();
            }
        }

        private void maybeSnapshot() {
            if (ActivityThread.this.mBoundApplication != null && SamplingProfilerIntegration.isEnabled()) {
                String packageName = ActivityThread.this.mBoundApplication.info.mPackageName;
                PackageInfo packageInfo = null;
                try {
                    ContextImpl context = ActivityThread.this.getSystemContext();
                    if (context == null) {
                        Log.e(ActivityThread.TAG, "cannot get a valid context");
                        return;
                    }
                    PackageManager pm = ((Context)context).getPackageManager();
                    if (pm == null) {
                        Log.e(ActivityThread.TAG, "cannot get a valid PackageManager");
                        return;
                    }
                    packageInfo = pm.getPackageInfo(packageName, 1);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e(ActivityThread.TAG, "cannot get package info for " + packageName, e);
                }
                SamplingProfilerIntegration.writeSnapshot(ActivityThread.this.mBoundApplication.processName, packageInfo);
            }
        }
    }

    private class ApplicationThread
    extends ApplicationThreadNative {
        private static final String DB_INFO_FORMAT = "  %8s %8s %14s %14s  %s";
        private int mLastProcessState = -1;

        private ApplicationThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updatePendingConfiguration(Configuration config) {
            ResourcesManager resourcesManager = ActivityThread.this.mResourcesManager;
            synchronized (resourcesManager) {
                if (ActivityThread.this.mPendingConfiguration == null || ActivityThread.this.mPendingConfiguration.isOtherSeqNewer(config)) {
                    ActivityThread.this.mPendingConfiguration = config;
                }
            }
        }

        @Override
        public void schedulePauseActivity(IBinder token, boolean finished, boolean userLeaving, int configChanges, boolean dontReport) {
            int seq = ActivityThread.this.getLifecycleSeq();
            ActivityThread.this.sendMessage(finished ? 102 : 101, token, (userLeaving ? 1 : 0) | (dontReport ? 2 : 0), configChanges, seq);
        }

        @Override
        public void scheduleStopActivity(IBinder token, boolean showWindow, int configChanges) {
            int seq = ActivityThread.this.getLifecycleSeq();
            ActivityThread.this.sendMessage(showWindow ? 103 : 104, token, 0, configChanges, seq);
        }

        @Override
        public void scheduleWindowVisibility(IBinder token, boolean showWindow) {
            ActivityThread.this.sendMessage(showWindow ? 105 : 106, token);
        }

        @Override
        public void scheduleSleeping(IBinder token, boolean sleeping) {
            ActivityThread.this.sendMessage(137, token, sleeping ? 1 : 0);
        }

        @Override
        public void scheduleResumeActivity(IBinder token, int processState, boolean isForward, Bundle resumeArgs) {
            int seq = ActivityThread.this.getLifecycleSeq();
            this.updateProcessState(processState, false);
            ActivityThread.this.sendMessage(107, token, isForward ? 1 : 0, 0, seq);
        }

        @Override
        public void scheduleSendResult(IBinder token, List<ResultInfo> results) {
            ResultData res = new ResultData();
            res.token = token;
            res.results = results;
            ActivityThread.this.sendMessage(108, res);
        }

        @Override
        public void scheduleLaunchActivity(Intent intent, IBinder token, int ident, ActivityInfo info, Configuration curConfig, Configuration overrideConfig, CompatibilityInfo compatInfo, String referrer, IVoiceInteractor voiceInteractor, int procState, Bundle state, PersistableBundle persistentState, List<ResultInfo> pendingResults, List<ReferrerIntent> pendingNewIntents, boolean notResumed, boolean isForward, ProfilerInfo profilerInfo) {
            this.updateProcessState(procState, false);
            ActivityClientRecord r = new ActivityClientRecord();
            r.token = token;
            r.ident = ident;
            r.intent = intent;
            r.referrer = referrer;
            r.voiceInteractor = voiceInteractor;
            r.activityInfo = info;
            r.compatInfo = compatInfo;
            r.state = state;
            r.persistentState = persistentState;
            r.pendingResults = pendingResults;
            r.pendingIntents = pendingNewIntents;
            r.startsNotResumed = notResumed;
            r.isForward = isForward;
            r.profilerInfo = profilerInfo;
            r.overrideConfig = overrideConfig;
            this.updatePendingConfiguration(curConfig);
            ActivityThread.this.sendMessage(100, r);
        }

        @Override
        public void scheduleRelaunchActivity(IBinder token, List<ResultInfo> pendingResults, List<ReferrerIntent> pendingNewIntents, int configChanges, boolean notResumed, Configuration config, Configuration overrideConfig, boolean preserveWindow) {
            ActivityThread.this.requestRelaunchActivity(token, pendingResults, pendingNewIntents, configChanges, notResumed, config, overrideConfig, true, preserveWindow);
        }

        @Override
        public void scheduleNewIntent(List<ReferrerIntent> intents, IBinder token) {
            NewIntentData data = new NewIntentData();
            data.intents = intents;
            data.token = token;
            ActivityThread.this.sendMessage(112, data);
        }

        @Override
        public void scheduleDestroyActivity(IBinder token, boolean finishing, int configChanges) {
            ActivityThread.this.sendMessage(109, token, finishing ? 1 : 0, configChanges);
        }

        @Override
        public void scheduleReceiver(Intent intent, ActivityInfo info, CompatibilityInfo compatInfo, int resultCode, String data, Bundle extras, boolean sync, int sendingUser, int processState) {
            this.updateProcessState(processState, false);
            ReceiverData r = new ReceiverData(intent, resultCode, data, extras, sync, false, ActivityThread.this.mAppThread.asBinder(), sendingUser);
            r.info = info;
            r.compatInfo = compatInfo;
            ActivityThread.this.sendMessage(113, r);
        }

        @Override
        public void scheduleCreateBackupAgent(ApplicationInfo app, CompatibilityInfo compatInfo, int backupMode) {
            CreateBackupAgentData d = new CreateBackupAgentData();
            d.appInfo = app;
            d.compatInfo = compatInfo;
            d.backupMode = backupMode;
            ActivityThread.this.sendMessage(128, d);
        }

        @Override
        public void scheduleDestroyBackupAgent(ApplicationInfo app, CompatibilityInfo compatInfo) {
            CreateBackupAgentData d = new CreateBackupAgentData();
            d.appInfo = app;
            d.compatInfo = compatInfo;
            ActivityThread.this.sendMessage(129, d);
        }

        @Override
        public void scheduleCreateService(IBinder token, ServiceInfo info, CompatibilityInfo compatInfo, int processState) {
            this.updateProcessState(processState, false);
            CreateServiceData s = new CreateServiceData();
            s.token = token;
            s.info = info;
            s.compatInfo = compatInfo;
            ActivityThread.this.sendMessage(114, s);
        }

        @Override
        public void scheduleBindService(IBinder token, Intent intent, boolean rebind, int processState) {
            this.updateProcessState(processState, false);
            BindServiceData s = new BindServiceData();
            s.token = token;
            s.intent = intent;
            s.rebind = rebind;
            ActivityThread.this.sendMessage(121, s);
        }

        @Override
        public void scheduleUnbindService(IBinder token, Intent intent) {
            BindServiceData s = new BindServiceData();
            s.token = token;
            s.intent = intent;
            ActivityThread.this.sendMessage(122, s);
        }

        @Override
        public void scheduleServiceArgs(IBinder token, boolean taskRemoved, int startId, int flags, Intent args) {
            ServiceArgsData s = new ServiceArgsData();
            s.token = token;
            s.taskRemoved = taskRemoved;
            s.startId = startId;
            s.flags = flags;
            s.args = args;
            ActivityThread.this.sendMessage(115, s);
        }

        @Override
        public void scheduleStopService(IBinder token) {
            ActivityThread.this.sendMessage(116, token);
        }

        @Override
        public void bindApplication(String processName, ApplicationInfo appInfo, List<ProviderInfo> providers, ComponentName instrumentationName, ProfilerInfo profilerInfo, Bundle instrumentationArgs, IInstrumentationWatcher instrumentationWatcher, IUiAutomationConnection instrumentationUiConnection, int debugMode, boolean enableBinderTracking, boolean trackAllocation, boolean isRestrictedBackupMode, boolean persistent, Configuration config, CompatibilityInfo compatInfo, Map<String, IBinder> services, Bundle coreSettings) {
            if (services != null) {
                ServiceManager.initServiceCache(services);
            }
            this.setCoreSettings(coreSettings);
            AppBindData data = new AppBindData();
            data.processName = processName;
            data.appInfo = appInfo;
            data.providers = providers;
            data.instrumentationName = instrumentationName;
            data.instrumentationArgs = instrumentationArgs;
            data.instrumentationWatcher = instrumentationWatcher;
            data.instrumentationUiAutomationConnection = instrumentationUiConnection;
            data.debugMode = debugMode;
            data.enableBinderTracking = enableBinderTracking;
            data.trackAllocation = trackAllocation;
            data.restrictedBackupMode = isRestrictedBackupMode;
            data.persistent = persistent;
            data.config = config;
            data.compatInfo = compatInfo;
            data.initProfilerInfo = profilerInfo;
            ActivityThread.this.sendMessage(110, data);
        }

        @Override
        public void scheduleExit() {
            ActivityThread.this.sendMessage(111, null);
        }

        @Override
        public void scheduleSuicide() {
            ActivityThread.this.sendMessage(130, null);
        }

        @Override
        public void scheduleConfigurationChanged(Configuration config) {
            this.updatePendingConfiguration(config);
            ActivityThread.this.sendMessage(118, config);
        }

        @Override
        public void updateTimeZone() {
            TimeZone.setDefault(null);
        }

        @Override
        public void clearDnsCache() {
            InetAddress.clearDnsCache();
            NetworkEventDispatcher.getInstance().onNetworkConfigurationChanged();
        }

        @Override
        public void setHttpProxy(String host, String port, String exclList, Uri pacFileUrl) {
            ConnectivityManager cm = ConnectivityManager.from(ActivityThread.this.getSystemContext());
            Network network = cm.getBoundNetworkForProcess();
            if (network != null) {
                Proxy.setHttpProxySystemProperty(cm.getDefaultProxy());
            } else {
                Proxy.setHttpProxySystemProperty(host, port, exclList, pacFileUrl);
            }
        }

        @Override
        public void processInBackground() {
            ActivityThread.this.mH.removeMessages(120);
            ActivityThread.this.mH.sendMessage(ActivityThread.this.mH.obtainMessage(120));
        }

        @Override
        public void dumpService(FileDescriptor fd, IBinder servicetoken, String[] args) {
            DumpComponentInfo data = new DumpComponentInfo();
            try {
                data.fd = ParcelFileDescriptor.dup(fd);
                data.token = servicetoken;
                data.args = args;
                ActivityThread.this.sendMessage(123, data, 0, 0, true);
            }
            catch (IOException e) {
                Slog.w(ActivityThread.TAG, "dumpService failed", e);
            }
        }

        @Override
        public void scheduleRegisteredReceiver(IIntentReceiver receiver, Intent intent, int resultCode, String dataStr, Bundle extras, boolean ordered, boolean sticky, int sendingUser, int processState) throws RemoteException {
            this.updateProcessState(processState, false);
            receiver.performReceive(intent, resultCode, dataStr, extras, ordered, sticky, sendingUser);
        }

        @Override
        public void scheduleLowMemory() {
            ActivityThread.this.sendMessage(124, null);
        }

        @Override
        public void scheduleActivityConfigurationChanged(IBinder token, Configuration overrideConfig, boolean reportToActivity) {
            ActivityThread.this.sendMessage(125, new ActivityConfigChangeData(token, overrideConfig), reportToActivity ? 1 : 0);
        }

        @Override
        public void profilerControl(boolean start, ProfilerInfo profilerInfo, int profileType) {
            ActivityThread.this.sendMessage(127, profilerInfo, start ? 1 : 0, profileType);
        }

        @Override
        public void dumpHeap(boolean managed, String path, ParcelFileDescriptor fd) {
            DumpHeapData dhd = new DumpHeapData();
            dhd.path = path;
            dhd.fd = fd;
            ActivityThread.this.sendMessage(135, dhd, managed ? 1 : 0, 0, true);
        }

        @Override
        public void setSchedulingGroup(int group) {
            try {
                Process.setProcessGroup(Process.myPid(), group);
            }
            catch (Exception e) {
                Slog.w(ActivityThread.TAG, "Failed setting process group to " + group, e);
            }
        }

        @Override
        public void dispatchPackageBroadcast(int cmd, String[] packages) {
            ActivityThread.this.sendMessage(133, packages, cmd);
        }

        @Override
        public void scheduleCrash(String msg) {
            ActivityThread.this.sendMessage(134, msg);
        }

        @Override
        public void dumpActivity(FileDescriptor fd, IBinder activitytoken, String prefix, String[] args) {
            DumpComponentInfo data = new DumpComponentInfo();
            try {
                data.fd = ParcelFileDescriptor.dup(fd);
                data.token = activitytoken;
                data.prefix = prefix;
                data.args = args;
                ActivityThread.this.sendMessage(136, data, 0, 0, true);
            }
            catch (IOException e) {
                Slog.w(ActivityThread.TAG, "dumpActivity failed", e);
            }
        }

        @Override
        public void dumpProvider(FileDescriptor fd, IBinder providertoken, String[] args) {
            DumpComponentInfo data = new DumpComponentInfo();
            try {
                data.fd = ParcelFileDescriptor.dup(fd);
                data.token = providertoken;
                data.args = args;
                ActivityThread.this.sendMessage(141, data, 0, 0, true);
            }
            catch (IOException e) {
                Slog.w(ActivityThread.TAG, "dumpProvider failed", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dumpMemInfo(FileDescriptor fd, Debug.MemoryInfo mem, boolean checkin, boolean dumpFullInfo, boolean dumpDalvik, boolean dumpSummaryOnly, boolean dumpUnreachable, String[] args) {
            FileOutputStream fout = new FileOutputStream(fd);
            FastPrintWriter pw = new FastPrintWriter(fout);
            try {
                this.dumpMemInfo(pw, mem, checkin, dumpFullInfo, dumpDalvik, dumpSummaryOnly, dumpUnreachable);
            }
            finally {
                ((PrintWriter)pw).flush();
            }
        }

        private void dumpMemInfo(PrintWriter pw, Debug.MemoryInfo memInfo, boolean checkin, boolean dumpFullInfo, boolean dumpDalvik, boolean dumpSummaryOnly, boolean dumpUnreachable) {
            String assetAlloc;
            long nativeMax = Debug.getNativeHeapSize() / 1024L;
            long nativeAllocated = Debug.getNativeHeapAllocatedSize() / 1024L;
            long nativeFree = Debug.getNativeHeapFreeSize() / 1024L;
            Runtime runtime = Runtime.getRuntime();
            runtime.gc();
            long dalvikMax = runtime.totalMemory() / 1024L;
            long dalvikFree = runtime.freeMemory() / 1024L;
            long dalvikAllocated = dalvikMax - dalvikFree;
            long viewInstanceCount = ViewDebug.getViewInstanceCount();
            long viewRootInstanceCount = ViewDebug.getViewRootImplCount();
            long appContextInstanceCount = Debug.countInstancesOfClass(ContextImpl.class);
            long activityInstanceCount = Debug.countInstancesOfClass(Activity.class);
            int globalAssetCount = AssetManager.getGlobalAssetCount();
            int globalAssetManagerCount = AssetManager.getGlobalAssetManagerCount();
            int binderLocalObjectCount = Debug.getBinderLocalObjectCount();
            int binderProxyObjectCount = Debug.getBinderProxyObjectCount();
            int binderDeathObjectCount = Debug.getBinderDeathObjectCount();
            long parcelSize = Parcel.getGlobalAllocSize();
            long parcelCount = Parcel.getGlobalAllocCount();
            long openSslSocketCount = Debug.countInstancesOfClass(OpenSSLSocketImpl.class);
            SQLiteDebug.PagerStats stats = SQLiteDebug.getDatabaseInfo();
            ActivityThread.dumpMemInfoTable(pw, memInfo, checkin, dumpFullInfo, dumpDalvik, dumpSummaryOnly, Process.myPid(), ActivityThread.this.mBoundApplication != null ? ActivityThread.this.mBoundApplication.processName : "unknown", nativeMax, nativeAllocated, nativeFree, dalvikMax, dalvikAllocated, dalvikFree);
            if (checkin) {
                pw.print(viewInstanceCount);
                pw.print(',');
                pw.print(viewRootInstanceCount);
                pw.print(',');
                pw.print(appContextInstanceCount);
                pw.print(',');
                pw.print(activityInstanceCount);
                pw.print(',');
                pw.print(globalAssetCount);
                pw.print(',');
                pw.print(globalAssetManagerCount);
                pw.print(',');
                pw.print(binderLocalObjectCount);
                pw.print(',');
                pw.print(binderProxyObjectCount);
                pw.print(',');
                pw.print(binderDeathObjectCount);
                pw.print(',');
                pw.print(openSslSocketCount);
                pw.print(',');
                pw.print(stats.memoryUsed / 1024);
                pw.print(',');
                pw.print(stats.memoryUsed / 1024);
                pw.print(',');
                pw.print(stats.pageCacheOverflow / 1024);
                pw.print(',');
                pw.print(stats.largestMemAlloc / 1024);
                for (int i = 0; i < stats.dbStats.size(); ++i) {
                    SQLiteDebug.DbStats dbStats = stats.dbStats.get(i);
                    pw.print(',');
                    pw.print(dbStats.dbName);
                    pw.print(',');
                    pw.print(dbStats.pageSize);
                    pw.print(',');
                    pw.print(dbStats.dbSize);
                    pw.print(',');
                    pw.print(dbStats.lookaside);
                    pw.print(',');
                    pw.print(dbStats.cache);
                    pw.print(',');
                    pw.print(dbStats.cache);
                }
                pw.println();
                return;
            }
            pw.println(" ");
            pw.println(" Objects");
            ActivityThread.printRow(pw, ActivityThread.TWO_COUNT_COLUMNS, "Views:", viewInstanceCount, "ViewRootImpl:", viewRootInstanceCount);
            ActivityThread.printRow(pw, ActivityThread.TWO_COUNT_COLUMNS, "AppContexts:", appContextInstanceCount, "Activities:", activityInstanceCount);
            ActivityThread.printRow(pw, ActivityThread.TWO_COUNT_COLUMNS, "Assets:", globalAssetCount, "AssetManagers:", globalAssetManagerCount);
            ActivityThread.printRow(pw, ActivityThread.TWO_COUNT_COLUMNS, "Local Binders:", binderLocalObjectCount, "Proxy Binders:", binderProxyObjectCount);
            ActivityThread.printRow(pw, ActivityThread.TWO_COUNT_COLUMNS, "Parcel memory:", parcelSize / 1024L, "Parcel count:", parcelCount);
            ActivityThread.printRow(pw, ActivityThread.TWO_COUNT_COLUMNS, "Death Recipients:", binderDeathObjectCount, "OpenSSL Sockets:", openSslSocketCount);
            pw.println(" ");
            pw.println(" SQL");
            ActivityThread.printRow(pw, ActivityThread.ONE_COUNT_COLUMN, "MEMORY_USED:", stats.memoryUsed / 1024);
            ActivityThread.printRow(pw, ActivityThread.TWO_COUNT_COLUMNS, "PAGECACHE_OVERFLOW:", stats.pageCacheOverflow / 1024, "MALLOC_SIZE:", stats.largestMemAlloc / 1024);
            pw.println(" ");
            int N = stats.dbStats.size();
            if (N > 0) {
                pw.println(" DATABASES");
                ActivityThread.printRow(pw, DB_INFO_FORMAT, "pgsz", "dbsz", "Lookaside(b)", "cache", "Dbname");
                for (int i = 0; i < N; ++i) {
                    SQLiteDebug.DbStats dbStats = stats.dbStats.get(i);
                    ActivityThread.printRow(pw, DB_INFO_FORMAT, dbStats.pageSize > 0L ? String.valueOf(dbStats.pageSize) : " ", dbStats.dbSize > 0L ? String.valueOf(dbStats.dbSize) : " ", dbStats.lookaside > 0 ? String.valueOf(dbStats.lookaside) : " ", dbStats.cache, dbStats.dbName);
                }
            }
            if ((assetAlloc = AssetManager.getAssetAllocations()) != null) {
                pw.println(" ");
                pw.println(" Asset Allocations");
                pw.print(assetAlloc);
            }
            if (dumpUnreachable) {
                boolean showContents = ActivityThread.this.mBoundApplication != null && (ActivityThread.this.mBoundApplication.appInfo.flags & 2) != 0 || Build.IS_DEBUGGABLE;
                pw.println(" ");
                pw.println(" Unreachable memory");
                pw.print(Debug.getUnreachableMemory(100, showContents));
            }
        }

        @Override
        public void dumpGfxInfo(FileDescriptor fd, String[] args) {
            ActivityThread.this.dumpGraphicsInfo(fd);
            WindowManagerGlobal.getInstance().dumpGfxInfo(fd, args);
        }

        private void dumpDatabaseInfo(FileDescriptor fd, String[] args) {
            FastPrintWriter pw = new FastPrintWriter(new FileOutputStream(fd));
            PrintWriterPrinter printer = new PrintWriterPrinter(pw);
            SQLiteDebug.dump(printer, args);
            ((PrintWriter)pw).flush();
        }

        @Override
        public void dumpDbInfo(FileDescriptor fd, final String[] args) {
            if (ActivityThread.this.mSystemThread) {
                ParcelFileDescriptor dup;
                try {
                    dup = ParcelFileDescriptor.dup(fd);
                }
                catch (IOException e) {
                    Log.w(ActivityThread.TAG, "Could not dup FD " + fd.getInt$());
                    return;
                }
                AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ApplicationThread.this.dumpDatabaseInfo(dup.getFileDescriptor(), args);
                        }
                        finally {
                            IoUtils.closeQuietly(dup);
                        }
                    }
                });
            } else {
                this.dumpDatabaseInfo(fd, args);
            }
        }

        @Override
        public void unstableProviderDied(IBinder provider) {
            ActivityThread.this.sendMessage(142, provider);
        }

        @Override
        public void requestAssistContextExtras(IBinder activityToken, IBinder requestToken, int requestType, int sessionId) {
            RequestAssistContextExtras cmd = new RequestAssistContextExtras();
            cmd.activityToken = activityToken;
            cmd.requestToken = requestToken;
            cmd.requestType = requestType;
            cmd.sessionId = sessionId;
            ActivityThread.this.sendMessage(143, cmd);
        }

        @Override
        public void setCoreSettings(Bundle coreSettings) {
            ActivityThread.this.sendMessage(138, coreSettings);
        }

        @Override
        public void updatePackageCompatibilityInfo(String pkg, CompatibilityInfo info) {
            UpdateCompatibilityData ucd = new UpdateCompatibilityData();
            ucd.pkg = pkg;
            ucd.info = info;
            ActivityThread.this.sendMessage(139, ucd);
        }

        @Override
        public void scheduleTrimMemory(int level) {
            ActivityThread.this.sendMessage(140, null, level);
        }

        @Override
        public void scheduleTranslucentConversionComplete(IBinder token, boolean drawComplete) {
            ActivityThread.this.sendMessage(144, token, drawComplete ? 1 : 0);
        }

        @Override
        public void scheduleOnNewActivityOptions(IBinder token, ActivityOptions options) {
            ActivityThread.this.sendMessage(146, new Pair<IBinder, ActivityOptions>(token, options));
        }

        @Override
        public void setProcessState(int state) {
            this.updateProcessState(state, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateProcessState(int processState, boolean fromIpc) {
            ApplicationThread applicationThread = this;
            synchronized (applicationThread) {
                if (this.mLastProcessState != processState) {
                    this.mLastProcessState = processState;
                    boolean DALVIK_PROCESS_STATE_JANK_PERCEPTIBLE = false;
                    boolean DALVIK_PROCESS_STATE_JANK_IMPERCEPTIBLE = true;
                    int dalvikProcessState = 1;
                    if (processState <= 6) {
                        dalvikProcessState = 0;
                    }
                    VMRuntime.getRuntime().updateProcessState(dalvikProcessState);
                }
            }
        }

        @Override
        public void scheduleInstallProvider(ProviderInfo provider) {
            ActivityThread.this.sendMessage(145, provider);
        }

        @Override
        public void updateTimePrefs(boolean is24Hour) {
            DateFormat.set24HourTimePref((boolean)is24Hour);
        }

        @Override
        public void scheduleCancelVisibleBehind(IBinder token) {
            ActivityThread.this.sendMessage(147, token);
        }

        @Override
        public void scheduleBackgroundVisibleBehindChanged(IBinder token, boolean visible) {
            ActivityThread.this.sendMessage(148, token, visible ? 1 : 0);
        }

        @Override
        public void scheduleEnterAnimationComplete(IBinder token) {
            ActivityThread.this.sendMessage(149, token);
        }

        @Override
        public void notifyCleartextNetwork(byte[] firstPacket) {
            if (StrictMode.vmCleartextNetworkEnabled()) {
                StrictMode.onCleartextNetworkDetected(firstPacket);
            }
        }

        @Override
        public void startBinderTracking() {
            ActivityThread.this.sendMessage(150, null);
        }

        @Override
        public void stopBinderTrackingAndDump(FileDescriptor fd) {
            try {
                ActivityThread.this.sendMessage(151, ParcelFileDescriptor.dup(fd));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void scheduleMultiWindowModeChanged(IBinder token, boolean isInMultiWindowMode) throws RemoteException {
            ActivityThread.this.sendMessage(152, token, isInMultiWindowMode ? 1 : 0);
        }

        @Override
        public void schedulePictureInPictureModeChanged(IBinder token, boolean isInPipMode) throws RemoteException {
            ActivityThread.this.sendMessage(153, token, isInPipMode ? 1 : 0);
        }

        @Override
        public void scheduleLocalVoiceInteractionStarted(IBinder token, IVoiceInteractor voiceInteractor) throws RemoteException {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = token;
            args.arg2 = voiceInteractor;
            ActivityThread.this.sendMessage(154, args);
        }
    }

    static class ActivityConfigChangeData {
        final IBinder activityToken;
        final Configuration overrideConfig;

        public ActivityConfigChangeData(IBinder token, Configuration config) {
            this.activityToken = token;
            this.overrideConfig = config;
        }
    }

    static class RequestAssistContextExtras {
        IBinder activityToken;
        IBinder requestToken;
        int requestType;
        int sessionId;

        RequestAssistContextExtras() {
        }
    }

    static class UpdateCompatibilityData {
        String pkg;
        CompatibilityInfo info;

        UpdateCompatibilityData() {
        }
    }

    static class DumpHeapData {
        String path;
        ParcelFileDescriptor fd;

        DumpHeapData() {
        }
    }

    static class ContextCleanupInfo {
        ContextImpl context;
        String what;
        String who;

        ContextCleanupInfo() {
        }
    }

    static class ResultData {
        IBinder token;
        List<ResultInfo> results;

        ResultData() {
        }

        public String toString() {
            return "ResultData{token=" + this.token + " results" + this.results + "}";
        }
    }

    static class DumpComponentInfo {
        ParcelFileDescriptor fd;
        IBinder token;
        String prefix;
        String[] args;

        DumpComponentInfo() {
        }
    }

    static class Profiler {
        String profileFile;
        ParcelFileDescriptor profileFd;
        int samplingInterval;
        boolean autoStopProfiler;
        boolean profiling;
        boolean handlingProfiling;

        Profiler() {
        }

        public void setProfiler(ProfilerInfo profilerInfo) {
            ParcelFileDescriptor fd = profilerInfo.profileFd;
            if (this.profiling) {
                if (fd != null) {
                    try {
                        fd.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
            if (this.profileFd != null) {
                try {
                    this.profileFd.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.profileFile = profilerInfo.profileFile;
            this.profileFd = fd;
            this.samplingInterval = profilerInfo.samplingInterval;
            this.autoStopProfiler = profilerInfo.autoStopProfiler;
        }

        public void startProfiling() {
            if (this.profileFd == null || this.profiling) {
                return;
            }
            try {
                int bufferSize = SystemProperties.getInt("debug.traceview-buffer-size-mb", 8);
                VMDebug.startMethodTracing(this.profileFile, this.profileFd.getFileDescriptor(), bufferSize * 1024 * 1024, 0, this.samplingInterval != 0, this.samplingInterval);
                this.profiling = true;
            }
            catch (RuntimeException e) {
                Slog.w(ActivityThread.TAG, "Profiling failed on path " + this.profileFile);
                try {
                    this.profileFd.close();
                    this.profileFd = null;
                }
                catch (IOException e2) {
                    Slog.w(ActivityThread.TAG, "Failure closing profile fd", e2);
                }
            }
        }

        public void stopProfiling() {
            if (this.profiling) {
                this.profiling = false;
                Debug.stopMethodTracing();
                if (this.profileFd != null) {
                    try {
                        this.profileFd.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.profileFd = null;
                this.profileFile = null;
            }
        }
    }

    static class AppBindData {
        LoadedApk info;
        String processName;
        ApplicationInfo appInfo;
        List<ProviderInfo> providers;
        ComponentName instrumentationName;
        Bundle instrumentationArgs;
        IInstrumentationWatcher instrumentationWatcher;
        IUiAutomationConnection instrumentationUiAutomationConnection;
        int debugMode;
        boolean enableBinderTracking;
        boolean trackAllocation;
        boolean restrictedBackupMode;
        boolean persistent;
        Configuration config;
        CompatibilityInfo compatInfo;
        ProfilerInfo initProfilerInfo;

        AppBindData() {
        }

        public String toString() {
            return "AppBindData{appInfo=" + this.appInfo + "}";
        }
    }

    static class ServiceArgsData {
        IBinder token;
        boolean taskRemoved;
        int startId;
        int flags;
        Intent args;

        ServiceArgsData() {
        }

        public String toString() {
            return "ServiceArgsData{token=" + this.token + " startId=" + this.startId + " args=" + this.args + "}";
        }
    }

    static class BindServiceData {
        IBinder token;
        Intent intent;
        boolean rebind;

        BindServiceData() {
        }

        public String toString() {
            return "BindServiceData{token=" + this.token + " intent=" + this.intent + "}";
        }
    }

    static class CreateServiceData {
        IBinder token;
        ServiceInfo info;
        CompatibilityInfo compatInfo;
        Intent intent;

        CreateServiceData() {
        }

        public String toString() {
            return "CreateServiceData{token=" + this.token + " className=" + this.info.name + " packageName=" + this.info.packageName + " intent=" + this.intent + "}";
        }
    }

    static class CreateBackupAgentData {
        ApplicationInfo appInfo;
        CompatibilityInfo compatInfo;
        int backupMode;

        CreateBackupAgentData() {
        }

        public String toString() {
            return "CreateBackupAgentData{appInfo=" + this.appInfo + " backupAgent=" + this.appInfo.backupAgentName + " mode=" + this.backupMode + "}";
        }
    }

    static class ReceiverData
    extends BroadcastReceiver.PendingResult {
        Intent intent;
        ActivityInfo info;
        CompatibilityInfo compatInfo;

        public ReceiverData(Intent intent, int resultCode, String resultData, Bundle resultExtras, boolean ordered, boolean sticky, IBinder token, int sendingUser) {
            super(resultCode, resultData, resultExtras, 0, ordered, sticky, token, sendingUser, intent.getFlags());
            this.intent = intent;
        }

        public String toString() {
            return "ReceiverData{intent=" + this.intent + " packageName=" + this.info.packageName + " resultCode=" + this.getResultCode() + " resultData=" + this.getResultData() + " resultExtras=" + this.getResultExtras(false) + "}";
        }
    }

    static class NewIntentData {
        List<ReferrerIntent> intents;
        IBinder token;

        NewIntentData() {
        }

        public String toString() {
            return "NewIntentData{intents=" + this.intents + " token=" + this.token + "}";
        }
    }

    class ProviderClientRecord {
        final String[] mNames;
        final IContentProvider mProvider;
        final ContentProvider mLocalProvider;
        final IActivityManager.ContentProviderHolder mHolder;

        ProviderClientRecord(String[] names, IContentProvider provider, ContentProvider localProvider, IActivityManager.ContentProviderHolder holder) {
            this.mNames = names;
            this.mProvider = provider;
            this.mLocalProvider = localProvider;
            this.mHolder = holder;
        }
    }

    static class ActivityClientRecord {
        IBinder token;
        int ident;
        Intent intent;
        String referrer;
        IVoiceInteractor voiceInteractor;
        Bundle state;
        PersistableBundle persistentState;
        Activity activity;
        Window window;
        Activity parent = null;
        String embeddedID = null;
        Activity.NonConfigurationInstances lastNonConfigurationInstances;
        boolean paused = false;
        boolean stopped = false;
        boolean hideForNow = false;
        Configuration newConfig;
        Configuration createdConfig;
        Configuration overrideConfig;
        private Configuration tmpConfig = new Configuration();
        ActivityClientRecord nextIdle = null;
        ProfilerInfo profilerInfo;
        ActivityInfo activityInfo;
        CompatibilityInfo compatInfo;
        LoadedApk packageInfo;
        List<ResultInfo> pendingResults;
        List<ReferrerIntent> pendingIntents;
        boolean startsNotResumed;
        boolean isForward;
        int pendingConfigChanges;
        boolean onlyLocalRequest;
        Window mPendingRemoveWindow;
        WindowManager mPendingRemoveWindowManager;
        boolean mPreserveWindow;
        int relaunchSeq = 0;
        int lastProcessedSeq = 0;

        ActivityClientRecord() {
        }

        public boolean isPreHoneycomb() {
            if (this.activity != null) {
                return this.activity.getApplicationInfo().targetSdkVersion < 11;
            }
            return false;
        }

        public boolean isPersistable() {
            return this.activityInfo.persistableMode == 2;
        }

        public String toString() {
            ComponentName componentName = this.intent != null ? this.intent.getComponent() : null;
            return "ActivityRecord{" + Integer.toHexString(System.identityHashCode(this)) + " token=" + this.token + " " + (componentName == null ? "no component name" : componentName.toShortString()) + "}";
        }

        public String getStateString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ActivityClientRecord{");
            sb.append("paused=").append(this.paused);
            sb.append(", stopped=").append(this.stopped);
            sb.append(", hideForNow=").append(this.hideForNow);
            sb.append(", startsNotResumed=").append(this.startsNotResumed);
            sb.append(", isForward=").append(this.isForward);
            sb.append(", pendingConfigChanges=").append(this.pendingConfigChanges);
            sb.append(", onlyLocalRequest=").append(this.onlyLocalRequest);
            sb.append(", preserveWindow=").append(this.mPreserveWindow);
            if (this.activity != null) {
                sb.append(", Activity{");
                sb.append("resumed=").append(this.activity.mResumed);
                sb.append(", stopped=").append(this.activity.mStopped);
                sb.append(", finished=").append(this.activity.isFinishing());
                sb.append(", destroyed=").append(this.activity.isDestroyed());
                sb.append(", startedActivity=").append(this.activity.mStartedActivity);
                sb.append(", temporaryPause=").append(this.activity.mTemporaryPause);
                sb.append(", changingConfigurations=").append(this.activity.mChangingConfigurations);
                sb.append(", visibleBehind=").append(this.activity.mVisibleBehind);
                sb.append("}");
            }
            sb.append("}");
            return sb.toString();
        }
    }

    private static class ProviderKey {
        final String authority;
        final int userId;

        public ProviderKey(String authority, int userId) {
            this.authority = authority;
            this.userId = userId;
        }

        public boolean equals(Object o) {
            if (o instanceof ProviderKey) {
                ProviderKey other = (ProviderKey)o;
                return Objects.equals(this.authority, other.authority) && this.userId == other.userId;
            }
            return false;
        }

        public int hashCode() {
            return (this.authority != null ? this.authority.hashCode() : 0) ^ this.userId;
        }
    }
}

