/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Keyframe;
import android.animation.KeyframeSet;
import android.animation.Keyframes;
import android.animation.TimeInterpolator;
import java.util.List;

class IntKeyframeSet
extends KeyframeSet
implements Keyframes.IntKeyframes {
    private int firstValue;
    private int lastValue;
    private int deltaValue;
    private boolean firstTime = true;

    public IntKeyframeSet(Keyframe.IntKeyframe ... keyframes) {
        super(keyframes);
    }

    @Override
    public Object getValue(float fraction2) {
        return this.getIntValue(fraction2);
    }

    @Override
    public IntKeyframeSet clone() {
        List keyframes = this.mKeyframes;
        int numKeyframes = this.mKeyframes.size();
        Keyframe.IntKeyframe[] newKeyframes = new Keyframe.IntKeyframe[numKeyframes];
        for (int i = 0; i < numKeyframes; ++i) {
            newKeyframes[i] = (Keyframe.IntKeyframe)((Keyframe)keyframes.get(i)).clone();
        }
        IntKeyframeSet newSet = new IntKeyframeSet(newKeyframes);
        return newSet;
    }

    @Override
    public void invalidateCache() {
        this.firstTime = true;
    }

    @Override
    public int getIntValue(float fraction2) {
        if (this.mNumKeyframes == 2) {
            if (this.firstTime) {
                this.firstTime = false;
                this.firstValue = ((Keyframe.IntKeyframe)this.mKeyframes.get(0)).getIntValue();
                this.lastValue = ((Keyframe.IntKeyframe)this.mKeyframes.get(1)).getIntValue();
                this.deltaValue = this.lastValue - this.firstValue;
            }
            if (this.mInterpolator != null) {
                fraction2 = this.mInterpolator.getInterpolation(fraction2);
            }
            if (this.mEvaluator == null) {
                return this.firstValue + (int)(fraction2 * (float)this.deltaValue);
            }
            return ((Number)this.mEvaluator.evaluate(fraction2, this.firstValue, this.lastValue)).intValue();
        }
        if (fraction2 <= 0.0f) {
            Keyframe.IntKeyframe prevKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(0);
            Keyframe.IntKeyframe nextKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(1);
            int prevValue = prevKeyframe.getIntValue();
            int nextValue = nextKeyframe.getIntValue();
            float prevFraction = prevKeyframe.getFraction();
            float nextFraction = nextKeyframe.getFraction();
            TimeInterpolator interpolator2 = nextKeyframe.getInterpolator();
            if (interpolator2 != null) {
                fraction2 = interpolator2.getInterpolation(fraction2);
            }
            float intervalFraction = (fraction2 - prevFraction) / (nextFraction - prevFraction);
            return this.mEvaluator == null ? prevValue + (int)(intervalFraction * (float)(nextValue - prevValue)) : ((Number)this.mEvaluator.evaluate(intervalFraction, prevValue, nextValue)).intValue();
        }
        if (fraction2 >= 1.0f) {
            Keyframe.IntKeyframe prevKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(this.mNumKeyframes - 2);
            Keyframe.IntKeyframe nextKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(this.mNumKeyframes - 1);
            int prevValue = prevKeyframe.getIntValue();
            int nextValue = nextKeyframe.getIntValue();
            float prevFraction = prevKeyframe.getFraction();
            float nextFraction = nextKeyframe.getFraction();
            TimeInterpolator interpolator3 = nextKeyframe.getInterpolator();
            if (interpolator3 != null) {
                fraction2 = interpolator3.getInterpolation(fraction2);
            }
            float intervalFraction = (fraction2 - prevFraction) / (nextFraction - prevFraction);
            return this.mEvaluator == null ? prevValue + (int)(intervalFraction * (float)(nextValue - prevValue)) : ((Number)this.mEvaluator.evaluate(intervalFraction, prevValue, nextValue)).intValue();
        }
        Keyframe.IntKeyframe prevKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(0);
        for (int i = 1; i < this.mNumKeyframes; ++i) {
            Keyframe.IntKeyframe nextKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(i);
            if (fraction2 < nextKeyframe.getFraction()) {
                TimeInterpolator interpolator4 = nextKeyframe.getInterpolator();
                float intervalFraction = (fraction2 - prevKeyframe.getFraction()) / (nextKeyframe.getFraction() - prevKeyframe.getFraction());
                int prevValue = prevKeyframe.getIntValue();
                int nextValue = nextKeyframe.getIntValue();
                if (interpolator4 != null) {
                    intervalFraction = interpolator4.getInterpolation(intervalFraction);
                }
                return this.mEvaluator == null ? prevValue + (int)(intervalFraction * (float)(nextValue - prevValue)) : ((Number)this.mEvaluator.evaluate(intervalFraction, prevValue, nextValue)).intValue();
            }
            prevKeyframe = nextKeyframe;
        }
        return ((Number)((Keyframe)this.mKeyframes.get(this.mNumKeyframes - 1)).getValue()).intValue();
    }

    @Override
    public Class getType() {
        return Integer.class;
    }
}

