/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.util;

import com.intellij.appengine.facet.AppEngineFacet;
import com.intellij.appengine.facet.AppEngineWebIntegration;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.ui.ListCellRendererWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineUtil {
    @NonNls
    public static final String APP_ENGINE_WEB_XML_NAME = "appengine-web.xml";
    @NonNls
    public static final String APP_ENGINE_APPLICATION_XML_NAME = "appengine-application.xml";
    @NonNls
    public static final String JDO_CONFIG_XML_NAME = "jdoconfig.xml";
    @NonNls
    public static final String JPA_CONFIG_XML_NAME = "persistence.xml";

    private AppEngineUtil() {
    }

    public static void setupAppEngineArtifactCombobox(@NotNull Project project, @NotNull JComboBox comboBox, boolean withAppEngineFacetOnly) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/appengine/util/AppEngineUtil", "setupAppEngineArtifactCombobox"));
        }
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/intellij/appengine/util/AppEngineUtil", "setupAppEngineArtifactCombobox"));
        }
        comboBox.setRenderer(new ListCellRendererWrapper<Artifact>(){

            public void customize(JList list, Artifact value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setIcon(value.getArtifactType().getIcon());
                    this.setText(value.getName());
                }
            }
        });
        comboBox.removeAllItems();
        for (Artifact artifact : AppEngineUtil.collectAppEngineArtifacts(project, withAppEngineFacetOnly)) {
            comboBox.addItem(artifact);
        }
    }

    public static List<Artifact> collectAppEngineArtifacts(@NotNull Project project, boolean withAppEngineFacetOnly) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/appengine/util/AppEngineUtil", "collectAppEngineArtifacts"));
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        if (project.isDefault()) {
            return artifacts;
        }
        for (Artifact artifact : ArtifactManager.getInstance((Project)project).getArtifacts()) {
            if (!AppEngineWebIntegration.getInstance().getAppEngineTargetArtifactTypes().contains(artifact.getArtifactType()) || withAppEngineFacetOnly && AppEngineUtil.findAppEngineFacet(project, artifact) == null) continue;
            artifacts.add(artifact);
        }
        Collections.sort(artifacts, ArtifactManager.ARTIFACT_COMPARATOR);
        return artifacts;
    }

    @Nullable
    public static AppEngineFacet findAppEngineFacet(@NotNull Project project, @NotNull Artifact artifact) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/appengine/util/AppEngineUtil", "findAppEngineFacet"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/appengine/util/AppEngineUtil", "findAppEngineFacet"));
        }
        Set modules = ArtifactUtil.getModulesIncludedInArtifacts(Collections.singletonList(artifact), (Project)project);
        for (Module module : modules) {
            AppEngineFacet appEngineFacet = AppEngineFacet.getAppEngineFacetByModule(module);
            if (appEngineFacet == null) continue;
            return appEngineFacet;
        }
        return null;
    }

    public static File getAppEngineSystemDir() {
        return new File(PathManager.getSystemPath(), "GoogleAppEngine");
    }

    public static List<String> getDefaultSourceRootsToEnhance(ModuleRootModel rootModel) {
        ArrayList<String> paths = new ArrayList<String>();
        for (String url : rootModel.getSourceRootUrls(false)) {
            paths.add(VfsUtil.urlToPath((String)url));
        }
        return paths;
    }
}

