/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.server.run;

import com.intellij.appengine.sdk.AppEngineSdk;
import com.intellij.appengine.server.instance.AppEngineServerModel;
import com.intellij.appengine.server.integration.AppEngineServerData;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.JavaCommandLineStartupPolicy;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import java.io.File;

public class AppEngineServerStartupPolicy
implements JavaCommandLineStartupPolicy {
    public JavaParameters createCommandLine(CommonModel commonModel) throws ExecutionException {
        AppEngineServerData data = (AppEngineServerData)commonModel.getApplicationServer().getPersistentData();
        AppEngineSdk sdk = data.getSdk();
        if (StringUtil.isEmpty((String)sdk.getSdkHomePath())) {
            throw new ExecutionException("Path to App Engine SDK isn't specified");
        }
        File toolsApiJarFile = sdk.getToolsApiJarFile();
        if (!toolsApiJarFile.exists()) {
            throw new ExecutionException("'" + sdk.getSdkHomePath() + "' isn't valid App Engine SDK installation: '" + toolsApiJarFile.getAbsolutePath() + "' not found");
        }
        JavaParameters javaParameters = new JavaParameters();
        javaParameters.getClassPath().add(toolsApiJarFile.getAbsolutePath());
        javaParameters.setMainClass("com.google.appengine.tools.development.DevAppServerMain");
        AppEngineServerModel serverModel = (AppEngineServerModel)commonModel.getServerModel();
        Artifact artifact = serverModel.getArtifact();
        if (artifact == null) {
            throw new ExecutionException("Artifact isn't specified");
        }
        ParametersList parameters = javaParameters.getProgramParametersList();
        parameters.addParametersString(serverModel.getServerParameters());
        parameters.replaceOrAppend("-p", "");
        parameters.replaceOrAppend("--port", "");
        parameters.add("-p", String.valueOf(serverModel.getLocalPort()));
        parameters.add("--disable_update_check");
        String outputPath = artifact.getOutputPath();
        if (outputPath == null || outputPath.length() == 0) {
            throw new ExecutionException("Output path isn't specified for '" + artifact.getName() + "' artifact");
        }
        String explodedPathParameter = FileUtil.toSystemDependentName((String)outputPath);
        parameters.add(explodedPathParameter);
        javaParameters.setWorkingDirectory(explodedPathParameter);
        ParametersList vmParameters = javaParameters.getVMParametersList();
        sdk.patchJavaParametersForDevServer(vmParameters);
        if (SystemInfo.isMac) {
            vmParameters.add("-XstartOnFirstThread");
        }
        return javaParameters;
    }
}

