/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.gwt;

import com.intellij.appengine.sdk.AppEngineSdk;
import com.intellij.appengine.server.integration.AppEngineServerData;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.run.GwtDevModeServer;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import icons.GoogleAppEngineIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AppEngineGwtServer
extends GwtDevModeServer {
    private final ApplicationServer myServer;

    public AppEngineGwtServer(@NotNull ApplicationServer server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/appengine/gwt/AppEngineGwtServer", "<init>"));
        }
        super("app-engine:" + server.getName(), server.getName());
        this.myServer = server;
    }

    public Icon getIcon() {
        return GoogleAppEngineIcons.AppEngine;
    }

    public void patchParameters(@NotNull JavaParameters parameters, String originalOutputDir, @NotNull GwtFacet gwtFacet) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/appengine/gwt/AppEngineGwtServer", "patchParameters"));
        }
        if (gwtFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtFacet", "com/intellij/appengine/gwt/AppEngineGwtServer", "patchParameters"));
        }
        ParametersList programParameters = parameters.getProgramParametersList();
        programParameters.add("-server");
        programParameters.add("com.google.appengine.tools.development.gwt.AppEngineLauncher");
        AppEngineSdk sdk = ((AppEngineServerData)this.myServer.getPersistentData()).getSdk();
        sdk.patchJavaParametersForDevServer(parameters.getVMParametersList());
        for (File jar : (File[])ArrayUtil.mergeArrays((Object[])sdk.getLibraries(), (Object[])sdk.getJspLibraries())) {
            parameters.getClassPath().addFirst(FileUtil.toSystemIndependentName((String)jar.getAbsolutePath()));
        }
        parameters.getClassPath().add(sdk.getToolsApiJarFile());
    }
}

