/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.facet.impl;

import com.intellij.appengine.facet.AppEngineWebIntegration;
import com.intellij.appengine.sdk.AppEngineSdk;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.impl.artifacts.PlainArtifactType;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineCommunityWebIntegration
extends AppEngineWebIntegration {
    private static final Logger LOG = Logger.getInstance(AppEngineCommunityWebIntegration.class);

    @Override
    @Nullable
    public VirtualFile suggestParentDirectoryForAppEngineWebXml(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/appengine/facet/impl/AppEngineCommunityWebIntegration", "suggestParentDirectoryForAppEngineWebXml"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/appengine/facet/impl/AppEngineCommunityWebIntegration", "suggestParentDirectoryForAppEngineWebXml"));
        }
        VirtualFile root = (VirtualFile)ArrayUtil.getFirstElement((Object[])rootModel.getContentRoots());
        if (root != null) {
            try {
                return VfsUtil.createDirectoryIfMissing((VirtualFile)root, (String)"WEB-INF");
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public ArtifactType getAppEngineWebArtifactType() {
        PlainArtifactType plainArtifactType = PlainArtifactType.getInstance();
        if (plainArtifactType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/facet/impl/AppEngineCommunityWebIntegration", "getAppEngineWebArtifactType"));
        }
        return plainArtifactType;
    }

    @Override
    @Nullable
    public ArtifactType getAppEngineApplicationArtifactType() {
        return null;
    }

    @Override
    public void setupJpaSupport(@NotNull Module module, @NotNull VirtualFile persistenceXml) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/appengine/facet/impl/AppEngineCommunityWebIntegration", "setupJpaSupport"));
        }
        if (persistenceXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistenceXml", "com/intellij/appengine/facet/impl/AppEngineCommunityWebIntegration", "setupJpaSupport"));
        }
    }

    @Override
    public void setupRunConfiguration(@NotNull AppEngineSdk sdk, @Nullable Artifact artifact, @NotNull Project project) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/appengine/facet/impl/AppEngineCommunityWebIntegration", "setupRunConfiguration"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/appengine/facet/impl/AppEngineCommunityWebIntegration", "setupRunConfiguration"));
        }
    }

    @Override
    public void setupDevServer(@NotNull AppEngineSdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/appengine/facet/impl/AppEngineCommunityWebIntegration", "setupDevServer"));
        }
    }

    @Override
    public void addDevServerToModuleDependencies(@NotNull ModifiableRootModel rootModel, @NotNull AppEngineSdk sdk) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/appengine/facet/impl/AppEngineCommunityWebIntegration", "addDevServerToModuleDependencies"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/appengine/facet/impl/AppEngineCommunityWebIntegration", "addDevServerToModuleDependencies"));
        }
    }

    @Override
    public void addLibraryToArtifact(@NotNull Library library, @NotNull Artifact artifact, @NotNull Project project) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/appengine/facet/impl/AppEngineCommunityWebIntegration", "addLibraryToArtifact"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/appengine/facet/impl/AppEngineCommunityWebIntegration", "addLibraryToArtifact"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/appengine/facet/impl/AppEngineCommunityWebIntegration", "addLibraryToArtifact"));
        }
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
        for (PackagingElement element : PackagingElementFactory.getInstance().createLibraryElements(library)) {
            String dir = element.getFilesKind(artifactManager.getResolvingContext()).containsDirectoriesWithClasses() ? "classes" : "lib";
            artifactManager.addElementsToDirectory(artifact, "WEB-INF/" + dir, element);
        }
    }

    @Override
    public List<? extends AppEngineSdk> getSdkForConfiguredDevServers() {
        return Collections.emptyList();
    }

    @Override
    public void addDescriptor(@NotNull Artifact artifact, @NotNull Project project, @NotNull VirtualFile descriptor) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/appengine/facet/impl/AppEngineCommunityWebIntegration", "addDescriptor"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/appengine/facet/impl/AppEngineCommunityWebIntegration", "addDescriptor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/appengine/facet/impl/AppEngineCommunityWebIntegration", "addDescriptor"));
        }
        ArtifactManager.getInstance((Project)project).addElementsToDirectory(artifact, "WEB-INF", PackagingElementFactory.getInstance().createFileCopy(descriptor.getPath(), null));
    }

    @Override
    @NotNull
    public List<FrameworkSupportInModuleProvider.FrameworkDependency> getAppEngineFrameworkDependencies() {
        List<FrameworkSupportInModuleProvider.FrameworkDependency> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/facet/impl/AppEngineCommunityWebIntegration", "getAppEngineFrameworkDependencies"));
        }
        return list;
    }
}

