/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.facet;

import com.intellij.appengine.facet.AppEngineFacet;
import com.intellij.appengine.facet.AppEngineFacetConfiguration;
import com.intellij.appengine.facet.AppEngineFacetType;
import com.intellij.appengine.facet.AppEngineFrameworkType;
import com.intellij.appengine.sdk.AppEngineSdk;
import com.intellij.appengine.sdk.AppEngineSdkManager;
import com.intellij.facet.FacetType;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.indexing.FileContent;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AppEngineFrameworkDetector
extends FacetBasedFrameworkDetector<AppEngineFacet, AppEngineFacetConfiguration> {
    public AppEngineFrameworkDetector() {
        super("appengine-java");
    }

    @NotNull
    public FacetType<AppEngineFacet, AppEngineFacetConfiguration> getFacetType() {
        FacetType facetType = FacetType.findInstance(AppEngineFacetType.class);
        if (facetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/facet/AppEngineFrameworkDetector", "getFacetType"));
        }
        return facetType;
    }

    public FrameworkType getFrameworkType() {
        return AppEngineFrameworkType.getFrameworkType();
    }

    public void setupFacet(@NotNull AppEngineFacet facet, ModifiableRootModel model) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/appengine/facet/AppEngineFrameworkDetector", "setupFacet"));
        }
        List<? extends AppEngineSdk> sdks = AppEngineSdkManager.getInstance().getValidSdks();
        if (!sdks.isEmpty()) {
            ((AppEngineFacetConfiguration)facet.getConfiguration()).setSdkHomePath(sdks.get(0).getSdkHomePath());
        }
    }

    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType = StdFileTypes.XML;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/facet/AppEngineFrameworkDetector", "getFileType"));
        }
        return languageFileType;
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        FileContentPattern fileContentPattern = FileContentPattern.fileContent().withName("appengine-web.xml").xmlWithRootTag("appengine-web-app");
        if (fileContentPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/facet/AppEngineFrameworkDetector", "createSuitableFilePattern"));
        }
        return fileContentPattern;
    }
}

