/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.actions;

import com.intellij.CommonBundle;
import com.intellij.appengine.cloud.AppEngineAuthData;
import com.intellij.appengine.cloud.AppEngineServerConfiguration;
import com.intellij.appengine.descriptor.dom.AppEngineWebApp;
import com.intellij.appengine.facet.AppEngineAccountDialog;
import com.intellij.appengine.facet.AppEngineFacet;
import com.intellij.appengine.sdk.AppEngineSdk;
import com.intellij.appengine.util.AppEngineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineBuilder;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.xml.GenericDomValue;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineUploader {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.appengine.actions.AppEngineUploader");
    private final Project myProject;
    private final Artifact myArtifact;
    private final AppEngineFacet myAppEngineFacet;
    private final AppEngineSdk mySdk;
    private final AppEngineAuthData myAuthData;
    private final ServerRuntimeInstance.DeploymentOperationCallback myCallback;
    private final LoggingHandler myLoggingHandler;

    private AppEngineUploader(Project project, Artifact artifact, AppEngineFacet appEngineFacet, AppEngineSdk sdk, AppEngineAuthData authData, ServerRuntimeInstance.DeploymentOperationCallback callback, @NotNull LoggingHandler loggingHandler) {
        if (loggingHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loggingHandler", "com/intellij/appengine/actions/AppEngineUploader", "<init>"));
        }
        this.myProject = project;
        this.myArtifact = artifact;
        this.myAppEngineFacet = appEngineFacet;
        this.mySdk = sdk;
        this.myAuthData = authData;
        this.myCallback = callback;
        this.myLoggingHandler = loggingHandler;
    }

    @Nullable
    public static AppEngineUploader createUploader(@NotNull Project project, @NotNull Artifact artifact, @NotNull AppEngineServerConfiguration configuration, @NotNull ServerRuntimeInstance.DeploymentOperationCallback callback, @NotNull LoggingHandler loggingHandler) {
        AppEngineAuthData authData;
        GenericDomValue<String> application;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/appengine/actions/AppEngineUploader", "createUploader"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/appengine/actions/AppEngineUploader", "createUploader"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/appengine/actions/AppEngineUploader", "createUploader"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/appengine/actions/AppEngineUploader", "createUploader"));
        }
        if (loggingHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loggingHandler", "com/intellij/appengine/actions/AppEngineUploader", "createUploader"));
        }
        String explodedPath = artifact.getOutputPath();
        if (explodedPath == null) {
            callback.errorOccurred("Output path isn't specified for '" + artifact.getName() + "' artifact");
            return null;
        }
        AppEngineFacet appEngineFacet = AppEngineUtil.findAppEngineFacet(project, artifact);
        if (appEngineFacet == null) {
            callback.errorOccurred("App Engine facet not found in '" + artifact.getName() + "' artifact");
            return null;
        }
        AppEngineSdk sdk = appEngineFacet.getSdk();
        if (!sdk.getAppCfgFile().exists()) {
            callback.errorOccurred("Path to App Engine SDK isn't specified correctly in App Engine Facet settings");
            return null;
        }
        PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)project).getResolvingContext();
        VirtualFile descriptorFile = ArtifactUtil.findSourceFileByOutputPath((Artifact)artifact, (String)"WEB-INF/appengine-web.xml", (PackagingElementResolvingContext)context);
        AppEngineWebApp root = AppEngineFacet.getDescriptorRoot(descriptorFile, appEngineFacet.getModule().getProject());
        if (root != null && StringUtil.isEmptyOrSpaces((String)((String)(application = root.getApplication()).getValue()))) {
            final String name = Messages.showInputDialog((Project)project, (String)"<html>Application name is not specified in appengine-web.xml.<br>Enter application name (see your <a href=\"http://appengine.google.com\">AppEngine account</a>):</html>", (String)CommonBundle.getErrorTitle(), null, (String)"", null);
            if (name == null) {
                return null;
            }
            PsiFile file = application.getXmlTag().getContainingFile();
            new WriteCommandAction(project, new PsiFile[]{file}){

                protected void run(@NotNull Result result) {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/appengine/actions/AppEngineUploader$1", "run"));
                    }
                    application.setStringValue(name);
                }
            }.execute();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
        }
        if ((authData = AppEngineAccountDialog.createAuthData(project, configuration)) == null) {
            return null;
        }
        return new AppEngineUploader(project, artifact, appEngineFacet, sdk, authData, callback, loggingHandler);
    }

    public void startUploading() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Uploading application", true, null){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/appengine/actions/AppEngineUploader$2", "run"));
                }
                AppEngineUploader.this.compileAndUpload();
            }
        });
    }

    private void compileAndUpload() {
        final Runnable startUploading = () -> ApplicationManager.getApplication().invokeLater(() -> this.startUploadingProcess());
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        CompileScope moduleScope = compilerManager.createModuleCompileScope(this.myAppEngineFacet.getModule(), true);
        CompileScope compileScope = ArtifactCompileScope.createScopeWithArtifacts((CompileScope)moduleScope, Collections.singletonList(this.myArtifact));
        ApplicationManager.getApplication().invokeLater(() -> compilerManager.make(compileScope, new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                if (!aborted && errors == 0) {
                    startUploading.run();
                }
            }
        }));
    }

    private void startUploadingProcess() {
        OSProcessHandler processHandler;
        try {
            JavaParameters parameters = new JavaParameters();
            parameters.configureByModule(this.myAppEngineFacet.getModule(), 1);
            parameters.setMainClass("com.google.appengine.tools.admin.AppCfg");
            parameters.getClassPath().add(this.mySdk.getToolsApiJarFile().getAbsolutePath());
            HttpConfigurable.getInstance().getJvmProperties(false, null).forEach(p -> parameters.getVMParametersList().addProperty((String)p.first, (String)p.second));
            ParametersList programParameters = parameters.getProgramParametersList();
            if (this.myAuthData.isOAuth2()) {
                programParameters.add("--oauth2");
            } else {
                programParameters.add("--email=" + this.myAuthData.getEmail());
                programParameters.add("--passin");
                programParameters.add("--no_cookies");
            }
            programParameters.add("update");
            programParameters.add(FileUtil.toSystemDependentName((String)this.myArtifact.getOutputPath()));
            GeneralCommandLine commandLine = CommandLineBuilder.createFromJavaParameters((SimpleJavaParameters)parameters);
            processHandler = new OSProcessHandler(commandLine);
        }
        catch (ExecutionException e) {
            this.myCallback.errorOccurred("Cannot start uploading: " + e.getMessage());
            return;
        }
        processHandler.addProcessListener((ProcessListener)new MyProcessListener((ProcessHandler)processHandler, null, this.myLoggingHandler));
        this.myLoggingHandler.attachToProcess((ProcessHandler)processHandler);
        processHandler.startNotify();
    }

    private class MyProcessListener
    extends ProcessAdapter {
        private boolean myPasswordEntered;
        private final ProcessHandler myProcessHandler;
        @Nullable
        private final ConsoleView myConsole;
        @Nullable
        private final LoggingHandler myLoggingHandler;

        public MyProcessListener(@Nullable ProcessHandler processHandler, @Nullable ConsoleView console, LoggingHandler loggingHandler) {
            this.myProcessHandler = processHandler;
            this.myConsole = console;
            this.myLoggingHandler = loggingHandler;
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            if (!AppEngineUploader.this.myAuthData.isOAuth2() && !this.myPasswordEntered && !outputType.equals((Object)ProcessOutputTypes.SYSTEM) && event.getText().contains(AppEngineUploader.this.myAuthData.getEmail())) {
                this.myPasswordEntered = true;
                OutputStream processInput = this.myProcessHandler.getProcessInput();
                if (processInput != null) {
                    PrintWriter input = new PrintWriter(processInput);
                    input.println(AppEngineUploader.this.myAuthData.getPassword());
                    input.flush();
                    String message = StringUtil.repeatSymbol((char)'*', (int)AppEngineUploader.this.myAuthData.getPassword().length()) + "\n";
                    if (this.myConsole != null) {
                        this.myConsole.print(message, ConsoleViewContentType.USER_INPUT);
                    } else if (this.myLoggingHandler != null) {
                        this.myLoggingHandler.print(message);
                    }
                }
            }
        }

        public void processTerminated(ProcessEvent event) {
            int exitCode = event.getExitCode();
            if (exitCode == 0) {
                AppEngineUploader.this.myCallback.succeeded(new DeploymentRuntime(){

                    public boolean isUndeploySupported() {
                        return false;
                    }

                    public void undeploy(@NotNull DeploymentRuntime.UndeploymentTaskCallback callback) {
                        if (callback == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/appengine/actions/AppEngineUploader$MyProcessListener$1", "undeploy"));
                        }
                    }
                });
            } else {
                AppEngineUploader.this.myCallback.errorOccurred("Process terminated with exit code " + exitCode);
            }
        }
    }
}

