/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.javafx.JavaFxHtmlPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

public class PreviewStaticServer
extends HttpRequestHandler {
    public static final String INLINE_CSS_FILENAME = "inline.css";
    private static final String PREFIX = "/api/markdown-preview/";
    @Nullable
    private String myInlineStyle = null;
    private long myInlineStyleTimestamp = 0L;

    public static PreviewStaticServer getInstance() {
        return (PreviewStaticServer)((Object)HttpRequestHandler.Companion.getEP_NAME().findExtension(PreviewStaticServer.class));
    }

    @NotNull
    public static String createCSP(@NotNull List<String> scripts, @NotNull List<String> styles) {
        if (scripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scripts", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "createCSP"));
        }
        if (styles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styles", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "createCSP"));
        }
        String string = "default-src 'none'; script-src " + StringUtil.join(scripts, (String)" ") + "; style-src https: " + StringUtil.join(styles, (String)" ") + "; img-src *; connect-src 'none'; font-src *; object-src 'none'; media-src 'none'; child-src 'none';";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "createCSP"));
        }
        return string;
    }

    @NotNull
    private static String getStaticUrl(@NotNull String staticPath) {
        if (staticPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "staticPath", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "getStaticUrl"));
        }
        String string = "http://localhost:" + BuiltInServerManager.getInstance().getPort() + PREFIX + staticPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "getStaticUrl"));
        }
        return string;
    }

    @NotNull
    public static String getScriptUrl(@NotNull String scriptFileName) {
        if (scriptFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptFileName", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "getScriptUrl"));
        }
        String string = PreviewStaticServer.getStaticUrl("scripts/" + scriptFileName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "getScriptUrl"));
        }
        return string;
    }

    @NotNull
    public static String getStyleUrl(@NotNull String scriptFileName) {
        if (scriptFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptFileName", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "getStyleUrl"));
        }
        String string = PreviewStaticServer.getStaticUrl("styles/" + scriptFileName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "getStyleUrl"));
        }
        return string;
    }

    public void setInlineStyle(@Nullable String inlineStyle) {
        this.myInlineStyle = inlineStyle;
        this.myInlineStyleTimestamp = System.currentTimeMillis();
    }

    public boolean isSupported(@NotNull FullHttpRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "isSupported"));
        }
        return super.isSupported(request) && request.uri().startsWith(PREFIX);
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) throws IOException {
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "process"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "process"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "process"));
        }
        String path = urlDecoder.path();
        if (!path.startsWith(PREFIX)) {
            throw new IllegalStateException("prefix should have been checked by #isSupported");
        }
        String payLoad = path.substring(PREFIX.length());
        List typeAndName = StringUtil.split((String)payLoad, (String)"/");
        if (typeAndName.size() != 2) {
            return false;
        }
        String contentType = (String)typeAndName.get(0);
        String fileName = (String)typeAndName.get(1);
        if ("scripts".equals(contentType) && MarkdownHtmlPanel.SCRIPTS.contains(fileName)) {
            PreviewStaticServer.sendResource((HttpRequest)request, context.channel(), JavaFxHtmlPanel.class, fileName);
        } else if ("styles".equals(contentType) && MarkdownHtmlPanel.STYLES.contains(fileName)) {
            if (INLINE_CSS_FILENAME.equals(fileName)) {
                this.sendInlineStyle((HttpRequest)request, context.channel());
            } else {
                PreviewStaticServer.sendResource((HttpRequest)request, context.channel(), MarkdownCssSettings.class, fileName);
            }
        } else {
            return false;
        }
        return true;
    }

    private void sendInlineStyle(@NotNull HttpRequest request, @NotNull Channel channel) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "sendInlineStyle"));
        }
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "sendInlineStyle"));
        }
        HttpResponse response = FileResponses.INSTANCE.prepareSend(request, channel, this.myInlineStyleTimestamp, INLINE_CSS_FILENAME, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        if (response == null) {
            return;
        }
        Responses.addKeepAliveIfNeed((HttpResponse)response, (HttpRequest)request);
        if (this.myInlineStyle == null) {
            Responses.send((HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (Channel)channel, (HttpRequest)request);
            return;
        }
        channel.write((Object)response);
        if (request.method() != HttpMethod.HEAD) {
            channel.write((Object)new ChunkedStream((InputStream)new ByteArrayInputStream(this.myInlineStyle.getBytes(CharsetToolkit.UTF8_CHARSET))));
        }
        ChannelFuture future = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void sendResource(@NotNull HttpRequest request, @NotNull Channel channel, @NotNull Class<?> clazz, @NotNull String resourceName) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "sendResource"));
        }
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "sendResource"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "sendResource"));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "org/intellij/plugins/markdown/ui/preview/PreviewStaticServer", "sendResource"));
        }
        String fileName = resourceName.substring(resourceName.lastIndexOf(47) + 1);
        HttpResponse response = FileResponses.INSTANCE.prepareSend(request, channel, 0L, fileName, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        if (response == null) {
            return;
        }
        Responses.addKeepAliveIfNeed((HttpResponse)response, (HttpRequest)request);
        try (InputStream resource2 = clazz.getResourceAsStream(resourceName);){
            if (resource2 == null) {
                Responses.send((HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (Channel)channel, (HttpRequest)request);
                return;
            }
            channel.write((Object)response);
            if (request.method() != HttpMethod.HEAD) {
                channel.write((Object)new ChunkedStream(resource2));
            }
        }
        catch (IOException resource2) {
            // empty catch block
        }
        ChannelFuture future = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

