/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.ui.split.SplitFileEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownActionUtil {
    @Nullable
    public static SplitFileEditor findSplitEditor(AnActionEvent e) {
        FileEditor editor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        if (editor instanceof SplitFileEditor) {
            return (SplitFileEditor)editor;
        }
        return (SplitFileEditor)((Object)SplitFileEditor.PARENT_SPLIT_KEY.get((UserDataHolder)editor));
    }

    @Nullable
    public static Editor findMarkdownTextEditor(AnActionEvent e) {
        SplitFileEditor splitEditor = MarkdownActionUtil.findSplitEditor(e);
        if (splitEditor == null) {
            PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            if (psiFile != null && psiFile.getLanguage() == MarkdownLanguage.INSTANCE && ApplicationManager.getApplication().isUnitTestMode()) {
                return (Editor)e.getData(CommonDataKeys.EDITOR);
            }
            return null;
        }
        if (!(splitEditor.getMainEditor() instanceof TextEditor)) {
            return null;
        }
        TextEditor mainEditor = (TextEditor)splitEditor.getMainEditor();
        if (!mainEditor.getComponent().isVisible()) {
            return null;
        }
        return mainEditor.getEditor();
    }

    @Nullable
    public static Couple<PsiElement> getElementsUnderCaretOrSelection(@NotNull PsiFile file, @NotNull Caret caret) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/markdown/ui/actions/MarkdownActionUtil", "getElementsUnderCaretOrSelection"));
        }
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "org/intellij/plugins/markdown/ui/actions/MarkdownActionUtil", "getElementsUnderCaretOrSelection"));
        }
        if (caret.getSelectionStart() == caret.getSelectionEnd()) {
            PsiElement element = file.findElementAt(caret.getSelectionStart());
            if (element == null) {
                return null;
            }
            return Couple.of((Object)element, (Object)element);
        }
        PsiElement startElement = file.findElementAt(caret.getSelectionStart());
        PsiElement endElement = file.findElementAt(caret.getSelectionEnd());
        if (startElement == null || endElement == null) {
            return null;
        }
        return Couple.of((Object)startElement, (Object)endElement);
    }

    @Nullable
    public static PsiElement getCommonParentOfType(@NotNull PsiElement element1, @NotNull PsiElement element2, @NotNull IElementType elementType) {
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "org/intellij/plugins/markdown/ui/actions/MarkdownActionUtil", "getCommonParentOfType"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "org/intellij/plugins/markdown/ui/actions/MarkdownActionUtil", "getCommonParentOfType"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/intellij/plugins/markdown/ui/actions/MarkdownActionUtil", "getCommonParentOfType"));
        }
        PsiElement base = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        return PsiTreeUtil.findFirstParent((PsiElement)base, (boolean)false, element -> {
            if (elementType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/intellij/plugins/markdown/ui/actions/MarkdownActionUtil", "lambda$getCommonParentOfType$0"));
            }
            ASTNode node = element.getNode();
            return node != null && node.getElementType() == elementType;
        });
    }
}

