/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.intellij.plugins.markdown.settings.MarkdownLAFListener;
import org.intellij.plugins.markdown.settings.MarkdownPreviewSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="MarkdownApplicationSettings", storages={@Storage(value="markdown.xml")})
public class MarkdownApplicationSettings
implements PersistentStateComponent<State>,
MarkdownCssSettings.Holder,
MarkdownPreviewSettings.Holder {
    private State myState = new State();

    public MarkdownApplicationSettings() {
        MarkdownLAFListener lafListener = new MarkdownLAFListener();
        LafManager.getInstance().addLafManagerListener((LafManagerListener)lafListener);
        ApplicationManager.getApplication().invokeLater(() -> lafListener.updateCssSettingsForced(MarkdownLAFListener.isDarcula(LafManager.getInstance().getCurrentLookAndFeel())));
    }

    @NotNull
    public static MarkdownApplicationSettings getInstance() {
        MarkdownApplicationSettings markdownApplicationSettings = (MarkdownApplicationSettings)ServiceManager.getService(MarkdownApplicationSettings.class);
        if (markdownApplicationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownApplicationSettings", "getInstance"));
        }
        return markdownApplicationSettings;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
    }

    @Override
    public void setMarkdownCssSettings(@NotNull MarkdownCssSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/intellij/plugins/markdown/settings/MarkdownApplicationSettings", "setMarkdownCssSettings"));
        }
        this.myState.myCssSettings = settings;
        ((SettingsChangedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SettingsChangedListener.TOPIC)).onSettingsChange(this);
    }

    @Override
    @NotNull
    public MarkdownCssSettings getMarkdownCssSettings() {
        MarkdownCssSettings markdownCssSettings = this.myState.myCssSettings;
        if (markdownCssSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownApplicationSettings", "getMarkdownCssSettings"));
        }
        return markdownCssSettings;
    }

    @Override
    public void setMarkdownPreviewSettings(@NotNull MarkdownPreviewSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/intellij/plugins/markdown/settings/MarkdownApplicationSettings", "setMarkdownPreviewSettings"));
        }
        this.myState.myPreviewSettings = settings;
        ((SettingsChangedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SettingsChangedListener.TOPIC)).onSettingsChange(this);
    }

    @Override
    @NotNull
    public MarkdownPreviewSettings getMarkdownPreviewSettings() {
        MarkdownPreviewSettings markdownPreviewSettings = this.myState.myPreviewSettings;
        if (markdownPreviewSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownApplicationSettings", "getMarkdownPreviewSettings"));
        }
        return markdownPreviewSettings;
    }

    public static interface SettingsChangedListener {
        public static final Topic<SettingsChangedListener> TOPIC = Topic.create((String)"MarkdownApplicationSettingsChanged", SettingsChangedListener.class);

        public void onSettingsChange(@NotNull MarkdownApplicationSettings var1);
    }

    public static class State {
        @Property(surroundWithTag=false)
        @NotNull
        private MarkdownCssSettings myCssSettings = MarkdownCssSettings.DEFAULT;
        @Property(surroundWithTag=false)
        @NotNull
        private MarkdownPreviewSettings myPreviewSettings = MarkdownPreviewSettings.DEFAULT;
    }
}

