/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownBlockQuoteImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeBlockImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHtmlBlockImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDefinitionImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestinationImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItemImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownParagraphImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCellImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRowImpl;
import org.jetbrains.annotations.NotNull;

public enum MarkdownPsiFactory {
    INSTANCE;


    public PsiElement createElement(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/intellij/plugins/markdown/lang/psi/MarkdownPsiFactory", "createElement"));
        }
        IElementType elementType = node.getElementType();
        if (elementType == MarkdownElementTypes.PARAGRAPH) {
            return new MarkdownParagraphImpl(node);
        }
        if (MarkdownTokenTypeSets.HEADERS.contains(elementType)) {
            return new MarkdownHeaderImpl(node);
        }
        if (elementType == MarkdownElementTypes.CODE_FENCE) {
            return (MarkdownCodeFenceImpl)node;
        }
        if (MarkdownTokenTypeSets.LISTS.contains(elementType)) {
            return new MarkdownListImpl(node);
        }
        if (elementType == MarkdownElementTypes.LIST_ITEM) {
            return new MarkdownListItemImpl(node);
        }
        if (elementType == MarkdownElementTypes.BLOCK_QUOTE) {
            return new MarkdownBlockQuoteImpl(node);
        }
        if (elementType == MarkdownElementTypes.LINK_DEFINITION) {
            return new MarkdownLinkDefinitionImpl(node);
        }
        if (elementType == MarkdownElementTypes.LINK_DESTINATION) {
            return new MarkdownLinkDestinationImpl(node);
        }
        if (elementType == MarkdownElementTypes.CODE_BLOCK) {
            return new MarkdownCodeBlockImpl(node);
        }
        if (elementType == MarkdownElementTypes.HTML_BLOCK) {
            return new MarkdownHtmlBlockImpl(node);
        }
        if (elementType == MarkdownElementTypes.TABLE) {
            return new MarkdownTableImpl(node);
        }
        if (elementType == MarkdownElementTypes.TABLE_ROW || elementType == MarkdownElementTypes.TABLE_HEADER) {
            return new MarkdownTableRowImpl(node);
        }
        if (elementType == MarkdownElementTypes.TABLE_CELL) {
            return new MarkdownTableCellImpl(node);
        }
        return new ASTWrapperPsiElement(node);
    }
}

