/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi;

import com.intellij.lang.ASTFactory;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceContentImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownASTFactory
extends ASTFactory {
    @Nullable
    public CompositeElement createComposite(IElementType type) {
        if (type == MarkdownElementTypes.CODE_FENCE) {
            return new MarkdownCodeFenceImpl(type);
        }
        return super.createComposite(type);
    }

    @Nullable
    public LeafElement createLeaf(@NotNull IElementType type, @NotNull CharSequence text) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/intellij/plugins/markdown/lang/psi/MarkdownASTFactory", "createLeaf"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/plugins/markdown/lang/psi/MarkdownASTFactory", "createLeaf"));
        }
        if (type == MarkdownTokenTypes.CODE_FENCE_CONTENT) {
            return new MarkdownCodeFenceContentImpl(type, text);
        }
        return super.createLeaf(type, text);
    }
}

