/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.lexer.MarkdownToplevelLexer;
import org.intellij.plugins.markdown.lang.parser.MarkdownParserAdapter;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.jetbrains.annotations.NotNull;

public class MarkdownParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        MarkdownToplevelLexer markdownToplevelLexer = new MarkdownToplevelLexer();
        if (markdownToplevelLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/parser/MarkdownParserDefinition", "createLexer"));
        }
        return markdownToplevelLexer;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        MarkdownParserAdapter markdownParserAdapter = new MarkdownParserAdapter();
        if (markdownParserAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/parser/MarkdownParserDefinition", "createParser"));
        }
        return markdownParserAdapter;
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = MarkdownElementTypes.MARKDOWN_FILE_ELEMENT_TYPE;
        if (iFileElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/parser/MarkdownParserDefinition", "getFileNodeType"));
        }
        return iFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[0]);
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/parser/MarkdownParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/parser/MarkdownParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/parser/MarkdownParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        PsiElement psiElement = MarkdownPsiFactory.INSTANCE.createElement(node);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/parser/MarkdownParserDefinition", "createElement"));
        }
        return psiElement;
    }

    @NotNull
    public PsiFile createFile(FileViewProvider viewProvider) {
        MarkdownFile markdownFile = new MarkdownFile(viewProvider);
        if (markdownFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/parser/MarkdownParserDefinition", "createFile"));
        }
        return markdownFile;
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
        if (spaceRequirements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/parser/MarkdownParserDefinition", "spaceExistanceTypeBetweenTokens"));
        }
        return spaceRequirements;
    }
}

