/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang;

import com.intellij.lang.Language;
import com.intellij.psi.tree.IElementType;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.MarkdownLazyElementType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownElementType
extends IElementType {
    @NotNull
    private static final Map<org.intellij.markdown.IElementType, IElementType> markdownToPlatformTypeMap = new HashMap<org.intellij.markdown.IElementType, IElementType>();
    @NotNull
    private static final Map<IElementType, org.intellij.markdown.IElementType> platformToMarkdownTypeMap = new HashMap<IElementType, org.intellij.markdown.IElementType>();

    public MarkdownElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/intellij/plugins/markdown/lang/MarkdownElementType", "<init>"));
        }
        super(debugName, (Language)MarkdownLanguage.INSTANCE);
    }

    public String toString() {
        return MessageFormat.format("Markdown:{0}", super.toString());
    }

    @Contract(value="!null -> !null")
    public static synchronized IElementType platformType(@Nullable org.intellij.markdown.IElementType markdownType) {
        if (markdownType == null) {
            return null;
        }
        if (markdownToPlatformTypeMap.containsKey(markdownType)) {
            return markdownToPlatformTypeMap.get(markdownType);
        }
        Object result = markdownType == MarkdownElementTypes.PARAGRAPH || markdownType == MarkdownTokenTypes.ATX_CONTENT || markdownType == MarkdownTokenTypes.SETEXT_CONTENT || markdownType == GFMTokenTypes.CELL ? new MarkdownLazyElementType(markdownType.toString()) : new MarkdownElementType(markdownType.toString());
        markdownToPlatformTypeMap.put(markdownType, (IElementType)result);
        platformToMarkdownTypeMap.put((IElementType)result, markdownType);
        return result;
    }

    @Contract(value="!null -> !null")
    public static synchronized org.intellij.markdown.IElementType markdownType(@Nullable IElementType platformType) {
        if (platformType == null) {
            return null;
        }
        return platformToMarkdownTypeMap.get(platformType);
    }
}

