/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.intellij.plugins.markdown.injection.LanguageListCompletionContributor;

public class MarkdownTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, Project project, Editor editor, PsiFile file) {
        if (charTyped == '`') {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            for (Caret caret : editor.getCaretModel().getAllCarets()) {
                int offset = caret.getOffset();
                if (LanguageListCompletionContributor.isInMiddleOfUncollapsedFence(file.findElementAt(offset), offset)) continue;
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
            return TypedHandlerDelegate.Result.STOP;
        }
        return super.checkAutoPopup(charTyped, project, editor, file);
    }
}

