/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.util.Callback;

public class FlowPane
extends Pane {
    private static final String MARGIN_CONSTRAINT = "flowpane-margin";
    private static final Callback<Node, Insets> marginAccessor = n -> FlowPane.getMargin(n);
    private ObjectProperty<Orientation> orientation;
    private DoubleProperty hgap;
    private DoubleProperty vgap;
    private DoubleProperty prefWrapLength;
    private ObjectProperty<Pos> alignment;
    private ObjectProperty<HPos> columnHalignment;
    private ObjectProperty<VPos> rowValignment;
    private List<Run> runs = null;
    private double lastMaxRunLength = -1.0;
    boolean computingRuns = false;

    public static void setMargin(Node child, Insets value) {
        FlowPane.setConstraint(child, MARGIN_CONSTRAINT, value);
    }

    public static Insets getMargin(Node child) {
        return (Insets)FlowPane.getConstraint(child, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node child) {
        FlowPane.setMargin(child, null);
    }

    public FlowPane() {
    }

    public FlowPane(Orientation orientation) {
        this();
        this.setOrientation(orientation);
    }

    public FlowPane(double hgap, double vgap) {
        this();
        this.setHgap(hgap);
        this.setVgap(vgap);
    }

    public FlowPane(Orientation orientation, double hgap, double vgap) {
        this();
        this.setOrientation(orientation);
        this.setHgap(hgap);
        this.setVgap(vgap);
    }

    public FlowPane(Node ... children) {
        this.getChildren().addAll((Node[])children);
    }

    public FlowPane(Orientation orientation, Node ... children) {
        this();
        this.setOrientation(orientation);
        this.getChildren().addAll((Node[])children);
    }

    public FlowPane(double hgap, double vgap, Node ... children) {
        this();
        this.setHgap(hgap);
        this.setVgap(vgap);
        this.getChildren().addAll((Node[])children);
    }

    public FlowPane(Orientation orientation, double hgap, double vgap, Node ... children) {
        this();
        this.setOrientation(orientation);
        this.setHgap(hgap);
        this.setVgap(vgap);
        this.getChildren().addAll((Node[])children);
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new StyleableObjectProperty((Object)Orientation.HORIZONTAL){

                @Override
                public void invalidated() {
                    FlowPane.this.requestLayout();
                }

                @Override
                public CssMetaData<FlowPane, Orientation> getCssMetaData() {
                    return StyleableProperties.ORIENTATION;
                }

                @Override
                public Object getBean() {
                    return FlowPane.this;
                }

                @Override
                public String getName() {
                    return "orientation";
                }
            };
        }
        return this.orientation;
    }

    public final void setOrientation(Orientation value) {
        this.orientationProperty().set(value);
    }

    public final Orientation getOrientation() {
        return this.orientation == null ? Orientation.HORIZONTAL : (Orientation)((Object)this.orientation.get());
    }

    public final DoubleProperty hgapProperty() {
        if (this.hgap == null) {
            this.hgap = new StyleableDoubleProperty(){

                @Override
                public void invalidated() {
                    FlowPane.this.requestLayout();
                }

                @Override
                public CssMetaData<FlowPane, Number> getCssMetaData() {
                    return StyleableProperties.HGAP;
                }

                @Override
                public Object getBean() {
                    return FlowPane.this;
                }

                @Override
                public String getName() {
                    return "hgap";
                }
            };
        }
        return this.hgap;
    }

    public final void setHgap(double value) {
        this.hgapProperty().set(value);
    }

    public final double getHgap() {
        return this.hgap == null ? 0.0 : this.hgap.get();
    }

    public final DoubleProperty vgapProperty() {
        if (this.vgap == null) {
            this.vgap = new StyleableDoubleProperty(){

                @Override
                public void invalidated() {
                    FlowPane.this.requestLayout();
                }

                @Override
                public CssMetaData<FlowPane, Number> getCssMetaData() {
                    return StyleableProperties.VGAP;
                }

                @Override
                public Object getBean() {
                    return FlowPane.this;
                }

                @Override
                public String getName() {
                    return "vgap";
                }
            };
        }
        return this.vgap;
    }

    public final void setVgap(double value) {
        this.vgapProperty().set(value);
    }

    public final double getVgap() {
        return this.vgap == null ? 0.0 : this.vgap.get();
    }

    public final DoubleProperty prefWrapLengthProperty() {
        if (this.prefWrapLength == null) {
            this.prefWrapLength = new DoublePropertyBase(400.0){

                @Override
                protected void invalidated() {
                    FlowPane.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return FlowPane.this;
                }

                @Override
                public String getName() {
                    return "prefWrapLength";
                }
            };
        }
        return this.prefWrapLength;
    }

    public final void setPrefWrapLength(double value) {
        this.prefWrapLengthProperty().set(value);
    }

    public final double getPrefWrapLength() {
        return this.prefWrapLength == null ? 400.0 : this.prefWrapLength.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new StyleableObjectProperty<Pos>(Pos.TOP_LEFT){

                @Override
                public void invalidated() {
                    FlowPane.this.requestLayout();
                }

                @Override
                public CssMetaData<FlowPane, Pos> getCssMetaData() {
                    return StyleableProperties.ALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return FlowPane.this;
                }

                @Override
                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos value) {
        this.alignmentProperty().set(value);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.TOP_LEFT : (Pos)((Object)this.alignment.get());
    }

    private Pos getAlignmentInternal() {
        Pos localPos = this.getAlignment();
        return localPos == null ? Pos.TOP_LEFT : localPos;
    }

    public final ObjectProperty<HPos> columnHalignmentProperty() {
        if (this.columnHalignment == null) {
            this.columnHalignment = new StyleableObjectProperty<HPos>(HPos.LEFT){

                @Override
                public void invalidated() {
                    FlowPane.this.requestLayout();
                }

                @Override
                public CssMetaData<FlowPane, HPos> getCssMetaData() {
                    return StyleableProperties.COLUMN_HALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return FlowPane.this;
                }

                @Override
                public String getName() {
                    return "columnHalignment";
                }
            };
        }
        return this.columnHalignment;
    }

    public final void setColumnHalignment(HPos value) {
        this.columnHalignmentProperty().set(value);
    }

    public final HPos getColumnHalignment() {
        return this.columnHalignment == null ? HPos.LEFT : (HPos)((Object)this.columnHalignment.get());
    }

    private HPos getColumnHalignmentInternal() {
        HPos localPos = this.getColumnHalignment();
        return localPos == null ? HPos.LEFT : localPos;
    }

    public final ObjectProperty<VPos> rowValignmentProperty() {
        if (this.rowValignment == null) {
            this.rowValignment = new StyleableObjectProperty<VPos>(VPos.CENTER){

                @Override
                public void invalidated() {
                    FlowPane.this.requestLayout();
                }

                @Override
                public CssMetaData<FlowPane, VPos> getCssMetaData() {
                    return StyleableProperties.ROW_VALIGNMENT;
                }

                @Override
                public Object getBean() {
                    return FlowPane.this;
                }

                @Override
                public String getName() {
                    return "rowValignment";
                }
            };
        }
        return this.rowValignment;
    }

    public final void setRowValignment(VPos value) {
        this.rowValignmentProperty().set(value);
    }

    public final VPos getRowValignment() {
        return this.rowValignment == null ? VPos.CENTER : (VPos)((Object)this.rowValignment.get());
    }

    private VPos getRowValignmentInternal() {
        VPos localPos = this.getRowValignment();
        return localPos == null ? VPos.CENTER : localPos;
    }

    @Override
    public Orientation getContentBias() {
        return this.getOrientation();
    }

    @Override
    protected double computeMinWidth(double height) {
        if (this.getContentBias() == Orientation.HORIZONTAL) {
            double maxPref = 0.0;
            ObservableList<Node> children = this.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                Node child = (Node)children.get(i);
                if (!child.isManaged()) continue;
                maxPref = Math.max(maxPref, child.prefWidth(-1.0));
            }
            Insets insets = this.getInsets();
            return insets.getLeft() + this.snapSize(maxPref) + insets.getRight();
        }
        return this.computePrefWidth(height);
    }

    @Override
    protected double computeMinHeight(double width) {
        if (this.getContentBias() == Orientation.VERTICAL) {
            double maxPref = 0.0;
            ObservableList<Node> children = this.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                Node child = (Node)children.get(i);
                if (!child.isManaged()) continue;
                maxPref = Math.max(maxPref, child.prefHeight(-1.0));
            }
            Insets insets = this.getInsets();
            return insets.getTop() + this.snapSize(maxPref) + insets.getBottom();
        }
        return this.computePrefHeight(width);
    }

    @Override
    protected double computePrefWidth(double forHeight) {
        Insets insets = this.getInsets();
        if (this.getOrientation() == Orientation.HORIZONTAL) {
            double maxRunWidth = this.getPrefWrapLength();
            List<Run> hruns = this.getRuns(maxRunWidth);
            double w = this.computeContentWidth(hruns);
            w = this.getPrefWrapLength() > w ? this.getPrefWrapLength() : w;
            return insets.getLeft() + this.snapSize(w) + insets.getRight();
        }
        double maxRunHeight = forHeight != -1.0 ? forHeight - insets.getTop() - insets.getBottom() : this.getPrefWrapLength();
        List<Run> vruns = this.getRuns(maxRunHeight);
        return insets.getLeft() + this.computeContentWidth(vruns) + insets.getRight();
    }

    @Override
    protected double computePrefHeight(double forWidth) {
        Insets insets = this.getInsets();
        if (this.getOrientation() == Orientation.HORIZONTAL) {
            double maxRunWidth = forWidth != -1.0 ? forWidth - insets.getLeft() - insets.getRight() : this.getPrefWrapLength();
            List<Run> hruns = this.getRuns(maxRunWidth);
            return insets.getTop() + this.computeContentHeight(hruns) + insets.getBottom();
        }
        double maxRunHeight = this.getPrefWrapLength();
        List<Run> vruns = this.getRuns(maxRunHeight);
        double h = this.computeContentHeight(vruns);
        h = this.getPrefWrapLength() > h ? this.getPrefWrapLength() : h;
        return insets.getTop() + this.snapSize(h) + insets.getBottom();
    }

    @Override
    public void requestLayout() {
        if (!this.computingRuns) {
            this.runs = null;
        }
        super.requestLayout();
    }

    private List<Run> getRuns(double maxRunLength) {
        if (this.runs == null || maxRunLength != this.lastMaxRunLength) {
            this.computingRuns = true;
            this.lastMaxRunLength = maxRunLength;
            this.runs = new ArrayList<Run>();
            double runLength = 0.0;
            double runOffset = 0.0;
            Run run = new Run();
            double vgap = this.snapSpace(this.getVgap());
            double hgap = this.snapSpace(this.getHgap());
            ObservableList<Node> children = this.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                double nodeLength;
                Node child = (Node)children.get(i);
                if (!child.isManaged()) continue;
                LayoutRect nodeRect = new LayoutRect();
                nodeRect.node = child;
                Insets margin = FlowPane.getMargin(child);
                nodeRect.width = this.computeChildPrefAreaWidth(child, margin);
                nodeRect.height = this.computeChildPrefAreaHeight(child, margin);
                double d = nodeLength = this.getOrientation() == Orientation.HORIZONTAL ? nodeRect.width : nodeRect.height;
                if (runLength + nodeLength > maxRunLength && runLength > 0.0) {
                    this.normalizeRun(run, runOffset);
                    runOffset = this.getOrientation() == Orientation.HORIZONTAL ? (runOffset += run.height + vgap) : (runOffset += run.width + hgap);
                    this.runs.add(run);
                    runLength = 0.0;
                    run = new Run();
                }
                if (this.getOrientation() == Orientation.HORIZONTAL) {
                    nodeRect.x = runLength;
                    runLength += nodeRect.width + hgap;
                } else {
                    nodeRect.y = runLength;
                    runLength += nodeRect.height + vgap;
                }
                run.rects.add(nodeRect);
            }
            this.normalizeRun(run, runOffset);
            this.runs.add(run);
            this.computingRuns = false;
        }
        return this.runs;
    }

    private void normalizeRun(Run run, double runOffset) {
        if (this.getOrientation() == Orientation.HORIZONTAL) {
            ArrayList<Node> rownodes = new ArrayList<Node>();
            run.width = (double)(run.rects.size() - 1) * this.snapSpace(this.getHgap());
            int max = run.rects.size();
            for (int i2 = 0; i2 < max; ++i2) {
                LayoutRect lrect = run.rects.get(i2);
                rownodes.add(lrect.node);
                run.width += lrect.width;
                lrect.y = runOffset;
            }
            run.height = this.computeMaxPrefAreaHeight(rownodes, marginAccessor, this.getRowValignment());
            run.baselineOffset = this.getRowValignment() == VPos.BASELINE ? this.getAreaBaselineOffset(rownodes, marginAccessor, i -> run.rects.get((int)i.intValue()).width, run.height, true) : 0.0;
        } else {
            run.height = (double)(run.rects.size() - 1) * this.snapSpace(this.getVgap());
            double maxw = 0.0;
            int max = run.rects.size();
            for (int i3 = 0; i3 < max; ++i3) {
                LayoutRect lrect = run.rects.get(i3);
                run.height += lrect.height;
                lrect.x = runOffset;
                maxw = Math.max(maxw, lrect.width);
            }
            run.width = maxw;
            run.baselineOffset = run.height;
        }
    }

    private double computeContentWidth(List<Run> runs) {
        double cwidth = this.getOrientation() == Orientation.HORIZONTAL ? 0.0 : (double)(runs.size() - 1) * this.snapSpace(this.getHgap());
        int max = runs.size();
        for (int i = 0; i < max; ++i) {
            Run run = runs.get(i);
            if (this.getOrientation() == Orientation.HORIZONTAL) {
                cwidth = Math.max(cwidth, run.width);
                continue;
            }
            cwidth += run.width;
        }
        return cwidth;
    }

    private double computeContentHeight(List<Run> runs) {
        double cheight = this.getOrientation() == Orientation.VERTICAL ? 0.0 : (double)(runs.size() - 1) * this.snapSpace(this.getVgap());
        int max = runs.size();
        for (int i = 0; i < max; ++i) {
            Run run = runs.get(i);
            if (this.getOrientation() == Orientation.VERTICAL) {
                cheight = Math.max(cheight, run.height);
                continue;
            }
            cheight += run.height;
        }
        return cheight;
    }

    @Override
    protected void layoutChildren() {
        Insets insets = this.getInsets();
        double width = this.getWidth();
        double height = this.getHeight();
        double top = insets.getTop();
        double left = insets.getLeft();
        double bottom = insets.getBottom();
        double right = insets.getRight();
        double insideWidth = width - left - right;
        double insideHeight = height - top - bottom;
        List<Run> runs = this.getRuns(this.getOrientation() == Orientation.HORIZONTAL ? insideWidth : insideHeight);
        int max = runs.size();
        for (int i = 0; i < max; ++i) {
            Run run = runs.get(i);
            double xoffset = left + FlowPane.computeXOffset(insideWidth, this.getOrientation() == Orientation.HORIZONTAL ? run.width : this.computeContentWidth(runs), this.getAlignmentInternal().getHpos());
            double yoffset = top + FlowPane.computeYOffset(insideHeight, this.getOrientation() == Orientation.VERTICAL ? run.height : this.computeContentHeight(runs), this.getAlignmentInternal().getVpos());
            for (int j = 0; j < run.rects.size(); ++j) {
                LayoutRect lrect = run.rects.get(j);
                double x = xoffset + lrect.x;
                double y = yoffset + lrect.y;
                this.layoutInArea(lrect.node, x, y, this.getOrientation() == Orientation.HORIZONTAL ? lrect.width : run.width, this.getOrientation() == Orientation.VERTICAL ? lrect.height : run.height, run.baselineOffset, FlowPane.getMargin(lrect.node), this.getColumnHalignmentInternal(), this.getRowValignmentInternal());
            }
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FlowPane.getClassCssMetaData();
    }

    private static class Run {
        ArrayList<LayoutRect> rects = new ArrayList();
        double width;
        double height;
        double baselineOffset;

        private Run() {
        }
    }

    private static class LayoutRect {
        public Node node;
        double x;
        double y;
        double width;
        double height;

        private LayoutRect() {
        }

        public String toString() {
            return "LayoutRect node id=" + this.node.getId() + " " + this.x + "," + this.y + " " + this.width + "x" + this.height;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<FlowPane, Pos> ALIGNMENT = new CssMetaData<FlowPane, Pos>("-fx-alignment", new EnumConverter<Pos>(Pos.class), Pos.TOP_LEFT){

            @Override
            public boolean isSettable(FlowPane node) {
                return node.alignment == null || !node.alignment.isBound();
            }

            @Override
            public StyleableProperty<Pos> getStyleableProperty(FlowPane node) {
                return (StyleableProperty)((Object)node.alignmentProperty());
            }
        };
        private static final CssMetaData<FlowPane, HPos> COLUMN_HALIGNMENT = new CssMetaData<FlowPane, HPos>("-fx-column-halignment", new EnumConverter<HPos>(HPos.class), HPos.LEFT){

            @Override
            public boolean isSettable(FlowPane node) {
                return node.columnHalignment == null || !node.columnHalignment.isBound();
            }

            @Override
            public StyleableProperty<HPos> getStyleableProperty(FlowPane node) {
                return (StyleableProperty)((Object)node.columnHalignmentProperty());
            }
        };
        private static final CssMetaData<FlowPane, Number> HGAP = new CssMetaData<FlowPane, Number>("-fx-hgap", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(FlowPane node) {
                return node.hgap == null || !node.hgap.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(FlowPane node) {
                return (StyleableProperty)((Object)node.hgapProperty());
            }
        };
        private static final CssMetaData<FlowPane, VPos> ROW_VALIGNMENT = new CssMetaData<FlowPane, VPos>("-fx-row-valignment", new EnumConverter<VPos>(VPos.class), VPos.CENTER){

            @Override
            public boolean isSettable(FlowPane node) {
                return node.rowValignment == null || !node.rowValignment.isBound();
            }

            @Override
            public StyleableProperty<VPos> getStyleableProperty(FlowPane node) {
                return (StyleableProperty)((Object)node.rowValignmentProperty());
            }
        };
        private static final CssMetaData<FlowPane, Orientation> ORIENTATION = new CssMetaData<FlowPane, Orientation>("-fx-orientation", new EnumConverter<Orientation>(Orientation.class), Orientation.HORIZONTAL){

            @Override
            public Orientation getInitialValue(FlowPane node) {
                return node.getOrientation();
            }

            @Override
            public boolean isSettable(FlowPane node) {
                return node.orientation == null || !node.orientation.isBound();
            }

            @Override
            public StyleableProperty<Orientation> getStyleableProperty(FlowPane node) {
                return (StyleableProperty)((Object)node.orientationProperty());
            }
        };
        private static final CssMetaData<FlowPane, Number> VGAP = new CssMetaData<FlowPane, Number>("-fx-vgap", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(FlowPane node) {
                return node.vgap == null || !node.vgap.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(FlowPane node) {
                return (StyleableProperty)((Object)node.vgapProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Region.getClassCssMetaData());
            styleables.add(ALIGNMENT);
            styleables.add(COLUMN_HALIGNMENT);
            styleables.add(HGAP);
            styleables.add(ROW_VALIGNMENT);
            styleables.add(ORIENTATION);
            styleables.add(VGAP);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

