/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class ComboBox<T>
extends ComboBoxBase<T> {
    private ObjectProperty<ObservableList<T>> items = new SimpleObjectProperty<ObservableList<T>>(this, "items");
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty<StringConverter<StringConverter<T>>>(this, "converter", ComboBox.defaultStringConverter());
    private ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactory = new SimpleObjectProperty<Callback<ListView<T>, ListCell<T>>>(this, "cellFactory");
    private ObjectProperty<ListCell<T>> buttonCell = new SimpleObjectProperty<ListCell<T>>(this, "buttonCell");
    private ObjectProperty<SingleSelectionModel<T>> selectionModel = new SimpleObjectProperty<SingleSelectionModel<T>>(this, "selectionModel"){
        private SingleSelectionModel<T> oldSM;
        {
            this.oldSM = null;
        }

        @Override
        protected void invalidated() {
            SingleSelectionModel sm;
            if (this.oldSM != null) {
                this.oldSM.selectedItemProperty().removeListener(ComboBox.this.selectedItemListener);
            }
            this.oldSM = sm = (SingleSelectionModel)this.get();
            if (sm != null) {
                sm.selectedItemProperty().addListener(ComboBox.this.selectedItemListener);
            }
        }
    };
    private IntegerProperty visibleRowCount = new SimpleIntegerProperty(this, "visibleRowCount", 10);
    private TextField textField;
    private ReadOnlyObjectWrapper<TextField> editor;
    private ObjectProperty<Node> placeholder;
    private ChangeListener<T> selectedItemListener = new ChangeListener<T>(){

        @Override
        public void changed(ObservableValue<? extends T> ov, T t, T t1) {
            if (!ComboBox.this.wasSetAllCalled || t1 != null) {
                ComboBox.this.updateValue(t1);
            }
            ComboBox.this.wasSetAllCalled = false;
        }
    };
    private static final String DEFAULT_STYLE_CLASS = "combo-box";
    private boolean wasSetAllCalled = false;
    private int previousItemCount = -1;

    private static <T> StringConverter<T> defaultStringConverter() {
        return new StringConverter<T>(){

            @Override
            public String toString(T t) {
                return t == null ? null : t.toString();
            }

            @Override
            public T fromString(String string) {
                return string;
            }
        };
    }

    public ComboBox() {
        this(FXCollections.observableArrayList());
    }

    public ComboBox(ObservableList<T> items) {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.setAccessibleRole(AccessibleRole.COMBO_BOX);
        this.setItems(items);
        this.setSelectionModel(new ComboBoxSelectionModel(this));
        this.valueProperty().addListener((ov, t, t1) -> {
            if (this.getItems() == null) {
                return;
            }
            SingleSelectionModel<Object> sm = this.getSelectionModel();
            int index = this.getItems().indexOf(t1);
            if (index == -1) {
                sm.setSelectedItem(t1);
            } else {
                Object selectedItem = sm.getSelectedItem();
                if (selectedItem == null || !selectedItem.equals(this.getValue())) {
                    ((SelectionModel)sm).clearAndSelect(index);
                }
            }
        });
        this.editableProperty().addListener(o -> this.getSelectionModel().clearSelection());
    }

    public final void setItems(ObservableList<T> value) {
        this.itemsProperty().set(value);
    }

    public final ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }

    public ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.items;
    }

    public ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public final void setCellFactory(Callback<ListView<T>, ListCell<T>> value) {
        this.cellFactoryProperty().set(value);
    }

    public final Callback<ListView<T>, ListCell<T>> getCellFactory() {
        return (Callback)this.cellFactoryProperty().get();
    }

    public ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public ObjectProperty<ListCell<T>> buttonCellProperty() {
        return this.buttonCell;
    }

    public final void setButtonCell(ListCell<T> value) {
        this.buttonCellProperty().set(value);
    }

    public final ListCell<T> getButtonCell() {
        return (ListCell)this.buttonCellProperty().get();
    }

    public final void setSelectionModel(SingleSelectionModel<T> value) {
        this.selectionModel.set(value);
    }

    public final SingleSelectionModel<T> getSelectionModel() {
        return (SingleSelectionModel)this.selectionModel.get();
    }

    public final ObjectProperty<SingleSelectionModel<T>> selectionModelProperty() {
        return this.selectionModel;
    }

    public final void setVisibleRowCount(int value) {
        this.visibleRowCount.set(value);
    }

    public final int getVisibleRowCount() {
        return this.visibleRowCount.get();
    }

    public final IntegerProperty visibleRowCountProperty() {
        return this.visibleRowCount;
    }

    public final TextField getEditor() {
        return (TextField)this.editorProperty().get();
    }

    public final ReadOnlyObjectProperty<TextField> editorProperty() {
        if (this.editor == null) {
            this.editor = new ReadOnlyObjectWrapper(this, "editor");
            this.textField = new ComboBoxPopupControl.FakeFocusTextField();
            this.editor.set(this.textField);
        }
        return this.editor.getReadOnlyProperty();
    }

    public final ObjectProperty<Node> placeholderProperty() {
        if (this.placeholder == null) {
            this.placeholder = new SimpleObjectProperty<Node>(this, "placeholder");
        }
        return this.placeholder;
    }

    public final void setPlaceholder(Node value) {
        this.placeholderProperty().set(value);
    }

    public final Node getPlaceholder() {
        return this.placeholder == null ? null : (Node)this.placeholder.get();
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ComboBoxListViewSkin(this);
    }

    private void updateValue(T newValue) {
        if (!this.valueProperty().isBound()) {
            this.setValue(newValue);
        }
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case TEXT: {
                String accText = this.getAccessibleText();
                if (accText != null && !accText.isEmpty()) {
                    return accText;
                }
                Object title = super.queryAccessibleAttribute(attribute, parameters);
                if (title != null) {
                    return title;
                }
                StringConverter converter = this.getConverter();
                if (converter == null) {
                    return this.getValue() != null ? this.getValue().toString() : "";
                }
                return converter.toString(this.getValue());
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    static class ComboBoxSelectionModel<T>
    extends SingleSelectionModel<T> {
        private final ComboBox<T> comboBox;
        private final ListChangeListener<T> itemsContentObserver = new ListChangeListener<T>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends T> c) {
                int newIndex;
                if (comboBox.getItems() == null || comboBox.getItems().isEmpty()) {
                    this.setSelectedIndex(-1);
                } else if (this.getSelectedIndex() == -1 && this.getSelectedItem() != null && (newIndex = comboBox.getItems().indexOf(this.getSelectedItem())) != -1) {
                    this.setSelectedIndex(newIndex);
                }
                int shift = 0;
                while (c.next()) {
                    comboBox.wasSetAllCalled = comboBox.previousItemCount == c.getRemovedSize();
                    if (c.wasReplaced() || !c.wasAdded() && !c.wasRemoved() || c.getFrom() > this.getSelectedIndex() || this.getSelectedIndex() == -1) continue;
                    shift += c.wasAdded() ? c.getAddedSize() : -c.getRemovedSize();
                }
                if (shift != 0) {
                    this.clearAndSelect(this.getSelectedIndex() + shift);
                }
                comboBox.previousItemCount = this.getItemCount();
            }
        };
        private final InvalidationListener itemsObserver;
        private WeakListChangeListener<T> weakItemsContentObserver = new WeakListChangeListener<T>(this.itemsContentObserver);

        public ComboBoxSelectionModel(ComboBox<T> cb) {
            if (cb == null) {
                throw new NullPointerException("ComboBox can not be null");
            }
            this.comboBox = cb;
            this.selectedIndexProperty().addListener(valueModel -> this.setSelectedItem(this.getModelItem(this.getSelectedIndex())));
            this.itemsObserver = new InvalidationListener(){
                private WeakReference<ObservableList<T>> weakItemsRef;
                {
                    this.weakItemsRef = new WeakReference(comboBox.getItems());
                }

                @Override
                public void invalidated(Observable observable) {
                    ObservableList oldItems = (ObservableList)this.weakItemsRef.get();
                    this.weakItemsRef = new WeakReference(comboBox.getItems());
                    this.updateItemsObserver(oldItems, comboBox.getItems());
                }
            };
            this.comboBox.itemsProperty().addListener(new WeakInvalidationListener(this.itemsObserver));
            if (this.comboBox.getItems() != null) {
                this.comboBox.getItems().addListener(this.weakItemsContentObserver);
            }
        }

        private void updateItemsObserver(ObservableList<T> oldList, ObservableList<T> newList) {
            Object value;
            if (oldList != null) {
                oldList.removeListener(this.weakItemsContentObserver);
            }
            if (newList != null) {
                newList.addListener(this.weakItemsContentObserver);
            }
            int newValueIndex = -1;
            if (newList != null && (value = this.comboBox.getValue()) != null) {
                newValueIndex = newList.indexOf(value);
            }
            this.setSelectedIndex(newValueIndex);
        }

        @Override
        protected T getModelItem(int index) {
            ObservableList<T> items = this.comboBox.getItems();
            if (items == null) {
                return null;
            }
            if (index < 0 || index >= items.size()) {
                return null;
            }
            return (T)items.get(index);
        }

        @Override
        protected int getItemCount() {
            ObservableList<T> items = this.comboBox.getItems();
            return items == null ? 0 : items.size();
        }
    }
}

