/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.javafx.animation.TickCalculation;
import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.collections.VetoableListDecorator;
import com.sun.scenario.animation.AbstractMasterTimer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.util.Duration;

public final class SequentialTransition
extends Transition {
    private static final Animation[] EMPTY_ANIMATION_ARRAY = new Animation[0];
    private static final int BEFORE = -1;
    private static final double EPSILON = 1.0E-12;
    private Animation[] cachedChildren = EMPTY_ANIMATION_ARRAY;
    private long[] startTimes;
    private long[] durations;
    private long[] delays;
    private double[] rates;
    private boolean[] forceChildSync;
    private int end;
    private int curIndex = -1;
    private long oldTicks = 0L;
    private long offsetTicks;
    private boolean childrenChanged = true;
    private boolean toggledRate;
    private final InvalidationListener childrenListener = observable -> {
        this.childrenChanged = true;
        if (this.getStatus() == Animation.Status.STOPPED) {
            this.setCycleDuration(this.computeCycleDuration());
        }
    };
    private final ChangeListener<Number> rateListener = new ChangeListener<Number>(){

        @Override
        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            if (oldValue.doubleValue() * newValue.doubleValue() < 0.0) {
                for (int i = 0; i < SequentialTransition.this.cachedChildren.length; ++i) {
                    Animation child = SequentialTransition.this.cachedChildren[i];
                    child.clipEnvelope.setRate(SequentialTransition.this.rates[i] * Math.signum(SequentialTransition.this.getCurrentRate()));
                }
                SequentialTransition.this.toggledRate = true;
            }
        }
    };
    private ObjectProperty<Node> node;
    private static final Node DEFAULT_NODE = null;
    private final Set<Animation> childrenSet = new HashSet<Animation>();
    private final ObservableList<Animation> children = new VetoableListDecorator<Animation>((ObservableList)new TrackableObservableList<Animation>(){

        @Override
        protected void onChanged(ListChangeListener.Change<Animation> c) {
            while (c.next()) {
                for (Animation animation : c.getRemoved()) {
                    animation.parent = null;
                    animation.rateProperty().removeListener(SequentialTransition.this.childrenListener);
                    animation.totalDurationProperty().removeListener(SequentialTransition.this.childrenListener);
                    animation.delayProperty().removeListener(SequentialTransition.this.childrenListener);
                }
                for (Animation animation : c.getAddedSubList()) {
                    animation.parent = SequentialTransition.this;
                    animation.rateProperty().addListener(SequentialTransition.this.childrenListener);
                    animation.totalDurationProperty().addListener(SequentialTransition.this.childrenListener);
                    animation.delayProperty().addListener(SequentialTransition.this.childrenListener);
                }
            }
            SequentialTransition.this.childrenListener.invalidated(SequentialTransition.this.children);
        }
    }){

        @Override
        protected void onProposedChange(List<Animation> toBeAdded, int ... indexes) {
            IllegalArgumentException exception = null;
            for (int i = 0; i < indexes.length; i += 2) {
                for (int idx = indexes[i]; idx < indexes[i + 1]; ++idx) {
                    SequentialTransition.this.childrenSet.remove(SequentialTransition.this.children.get(idx));
                }
            }
            for (Animation child : toBeAdded) {
                if (child == null) {
                    exception = new IllegalArgumentException("Child cannot be null");
                    break;
                }
                if (!SequentialTransition.this.childrenSet.add(child)) {
                    exception = new IllegalArgumentException("Attempting to add a duplicate to the list of children");
                    break;
                }
                if (!SequentialTransition.checkCycle(child, SequentialTransition.this)) continue;
                exception = new IllegalArgumentException("This change would create cycle");
                break;
            }
            if (exception != null) {
                SequentialTransition.this.childrenSet.clear();
                SequentialTransition.this.childrenSet.addAll(SequentialTransition.this.children);
                throw exception;
            }
        }
    };

    public final void setNode(Node value) {
        if (this.node != null || value != null) {
            this.nodeProperty().set(value);
        }
    }

    public final Node getNode() {
        return this.node == null ? DEFAULT_NODE : (Node)this.node.get();
    }

    public final ObjectProperty<Node> nodeProperty() {
        if (this.node == null) {
            this.node = new SimpleObjectProperty<Node>(this, "node", DEFAULT_NODE);
        }
        return this.node;
    }

    private static boolean checkCycle(Animation child, Animation parent) {
        Animation a = parent;
        while (a != child) {
            if (a.parent != null) {
                a = a.parent;
                continue;
            }
            return false;
        }
        return true;
    }

    public final ObservableList<Animation> getChildren() {
        return this.children;
    }

    public SequentialTransition(Node node, Animation ... children) {
        this.setInterpolator(Interpolator.LINEAR);
        this.setNode(node);
        this.getChildren().setAll((Animation[])children);
    }

    public SequentialTransition(Animation ... children) {
        this((Node)null, children);
    }

    public SequentialTransition(Node node) {
        this.setInterpolator(Interpolator.LINEAR);
        this.setNode(node);
    }

    public SequentialTransition() {
        this((Node)null);
    }

    SequentialTransition(AbstractMasterTimer timer) {
        super(timer);
        this.setInterpolator(Interpolator.LINEAR);
    }

    @Override
    protected Node getParentTargetNode() {
        Node _node = this.getNode();
        return _node != null ? _node : (this.parent != null && this.parent instanceof Transition ? ((Transition)this.parent).getParentTargetNode() : null);
    }

    private Duration computeCycleDuration() {
        Duration currentDur = Duration.ZERO;
        for (Animation animation : this.getChildren()) {
            currentDur = currentDur.add(animation.getDelay());
            double absRate = Math.abs(animation.getRate());
            if (!(currentDur = currentDur.add(absRate < 1.0E-12 ? animation.getTotalDuration() : animation.getTotalDuration().divide(absRate))).isIndefinite()) continue;
            break;
        }
        return currentDur;
    }

    private double calculateFraction(long currentTicks, long cycleTicks) {
        double frac = (double)currentTicks / (double)cycleTicks;
        return frac <= 0.0 ? 0.0 : (frac >= 1.0 ? 1.0 : frac);
    }

    private int findNewIndex(long ticks) {
        int toIndex;
        if (this.curIndex != -1 && this.curIndex != this.end && this.startTimes[this.curIndex] <= ticks && ticks <= this.startTimes[this.curIndex + 1]) {
            return this.curIndex;
        }
        boolean indexUndefined = this.curIndex == -1 || this.curIndex == this.end;
        int fromIndex = indexUndefined || ticks < this.oldTicks ? 0 : this.curIndex + 1;
        int index = Arrays.binarySearch(this.startTimes, fromIndex, toIndex = indexUndefined || this.oldTicks < ticks ? this.end : this.curIndex, ticks);
        return index < 0 ? -index - 2 : (index > 0 ? index - 1 : 0);
    }

    @Override
    void impl_sync(boolean forceSync) {
        super.impl_sync(forceSync);
        if (forceSync && this.childrenChanged || this.startTimes == null) {
            this.cachedChildren = this.getChildren().toArray(EMPTY_ANIMATION_ARRAY);
            this.end = this.cachedChildren.length;
            this.startTimes = new long[this.end + 1];
            this.durations = new long[this.end];
            this.delays = new long[this.end];
            this.rates = new double[this.end];
            this.forceChildSync = new boolean[this.end];
            long cycleTicks = 0L;
            int i = 0;
            for (Animation animation : this.cachedChildren) {
                this.startTimes[i] = cycleTicks;
                this.rates[i] = Math.abs(animation.getRate());
                if (this.rates[i] < 1.0E-12) {
                    this.rates[i] = 1.0;
                }
                this.durations[i] = TickCalculation.fromDuration(animation.getTotalDuration(), this.rates[i]);
                this.delays[i] = TickCalculation.fromDuration(animation.getDelay());
                cycleTicks = this.durations[i] == Long.MAX_VALUE || this.delays[i] == Long.MAX_VALUE || cycleTicks == Long.MAX_VALUE ? Long.MAX_VALUE : TickCalculation.add(cycleTicks, TickCalculation.add(this.durations[i], this.delays[i]));
                this.forceChildSync[i] = true;
                ++i;
            }
            this.startTimes[this.end] = cycleTicks;
            this.childrenChanged = false;
        } else if (forceSync) {
            int n = this.forceChildSync.length;
            for (int i = 0; i < n; ++i) {
                this.forceChildSync[i] = true;
            }
        }
    }

    @Override
    void impl_start(boolean forceSync) {
        super.impl_start(forceSync);
        this.toggledRate = false;
        this.rateProperty().addListener(this.rateListener);
        this.offsetTicks = 0L;
        double curRate = this.getCurrentRate();
        long currentTicks = TickCalculation.fromDuration(this.getCurrentTime());
        if (curRate < 0.0) {
            this.jumpToEnd();
            this.curIndex = this.end;
            if (currentTicks < this.startTimes[this.end]) {
                this.impl_jumpTo(currentTicks, this.startTimes[this.end], false);
            }
        } else {
            this.jumpToBefore();
            this.curIndex = -1;
            if (currentTicks > 0L) {
                this.impl_jumpTo(currentTicks, this.startTimes[this.end], false);
            }
        }
    }

    @Override
    void impl_pause() {
        Animation current;
        super.impl_pause();
        if (this.curIndex != -1 && this.curIndex != this.end && (current = this.cachedChildren[this.curIndex]).getStatus() == Animation.Status.RUNNING) {
            current.impl_pause();
        }
    }

    @Override
    void impl_resume() {
        Animation current;
        super.impl_resume();
        if (this.curIndex != -1 && this.curIndex != this.end && (current = this.cachedChildren[this.curIndex]).getStatus() == Animation.Status.PAUSED) {
            current.impl_resume();
            current.clipEnvelope.setRate(this.rates[this.curIndex] * Math.signum(this.getCurrentRate()));
        }
    }

    @Override
    void impl_stop() {
        Animation current;
        super.impl_stop();
        if (this.curIndex != -1 && this.curIndex != this.end && (current = this.cachedChildren[this.curIndex]).getStatus() != Animation.Status.STOPPED) {
            current.impl_stop();
        }
        if (this.childrenChanged) {
            this.setCycleDuration(this.computeCycleDuration());
        }
        this.rateProperty().removeListener(this.rateListener);
    }

    private boolean startChild(Animation child, int index) {
        boolean forceSync = this.forceChildSync[index];
        if (child.impl_startable(forceSync)) {
            child.clipEnvelope.setRate(this.rates[index] * Math.signum(this.getCurrentRate()));
            child.impl_start(forceSync);
            this.forceChildSync[index] = false;
            return true;
        }
        return false;
    }

    @Override
    void impl_playTo(long currentTicks, long cycleTicks) {
        Animation current;
        this.impl_setCurrentTicks(currentTicks);
        double frac = this.calculateFraction(currentTicks, cycleTicks);
        long newTicks = Math.max(0L, Math.min(this.getCachedInterpolator().interpolate(0L, cycleTicks, frac), cycleTicks));
        int newIndex = this.findNewIndex(newTicks);
        Animation animation = current = this.curIndex == -1 || this.curIndex == this.end ? null : this.cachedChildren[this.curIndex];
        if (this.toggledRate) {
            if (current != null && current.getStatus() == Animation.Status.RUNNING) {
                this.offsetTicks = (long)((double)this.offsetTicks - Math.signum(this.getCurrentRate()) * (double)(this.durations[this.curIndex] - 2L * (this.oldTicks - this.delays[this.curIndex] - this.startTimes[this.curIndex])));
            }
            this.toggledRate = false;
        }
        if (this.curIndex == newIndex) {
            if (this.getCurrentRate() > 0.0) {
                long currentDelay = TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]);
                if (newTicks >= currentDelay) {
                    if (this.oldTicks <= currentDelay || current.getStatus() == Animation.Status.STOPPED) {
                        boolean enteringCycle;
                        boolean bl = enteringCycle = this.oldTicks <= currentDelay;
                        if (enteringCycle) {
                            current.clipEnvelope.jumpTo(0L);
                        }
                        if (!this.startChild(current, this.curIndex)) {
                            EventHandler<ActionEvent> handler;
                            if (enteringCycle && (handler = current.getOnFinished()) != null) {
                                handler.handle(new ActionEvent(this, null));
                            }
                            this.oldTicks = newTicks;
                            return;
                        }
                    }
                    if (newTicks >= this.startTimes[this.curIndex + 1]) {
                        current.impl_timePulse(TickCalculation.sub(this.durations[this.curIndex], this.offsetTicks));
                        if (newTicks == cycleTicks) {
                            this.curIndex = this.end;
                        }
                    } else {
                        long localTicks = TickCalculation.sub(newTicks - currentDelay, this.offsetTicks);
                        current.impl_timePulse(localTicks);
                    }
                }
            } else {
                long currentDelay = TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]);
                if (this.oldTicks >= this.startTimes[this.curIndex + 1] || this.oldTicks >= currentDelay && current.getStatus() == Animation.Status.STOPPED) {
                    boolean enteringCycle;
                    boolean bl = enteringCycle = this.oldTicks >= this.startTimes[this.curIndex + 1];
                    if (enteringCycle) {
                        current.clipEnvelope.jumpTo(Math.round((double)this.durations[this.curIndex] * this.rates[this.curIndex]));
                    }
                    if (!this.startChild(current, this.curIndex)) {
                        EventHandler<ActionEvent> handler;
                        if (enteringCycle && (handler = current.getOnFinished()) != null) {
                            handler.handle(new ActionEvent(this, null));
                        }
                        this.oldTicks = newTicks;
                        return;
                    }
                }
                if (newTicks <= currentDelay) {
                    current.impl_timePulse(TickCalculation.sub(this.durations[this.curIndex], this.offsetTicks));
                    if (newTicks == 0L) {
                        this.curIndex = -1;
                    }
                } else {
                    long localTicks = TickCalculation.sub(this.startTimes[this.curIndex + 1] - newTicks, this.offsetTicks);
                    current.impl_timePulse(localTicks);
                }
            }
        } else if (this.curIndex < newIndex) {
            EventHandler<ActionEvent> handler;
            if (current != null) {
                long oldDelay = TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]);
                if (this.oldTicks <= oldDelay || current.getStatus() == Animation.Status.STOPPED && this.oldTicks != this.startTimes[this.curIndex + 1]) {
                    EventHandler<ActionEvent> handler2;
                    boolean enteringCycle;
                    boolean bl = enteringCycle = this.oldTicks <= oldDelay;
                    if (enteringCycle) {
                        current.clipEnvelope.jumpTo(0L);
                    }
                    if (!this.startChild(current, this.curIndex) && enteringCycle && (handler2 = current.getOnFinished()) != null) {
                        handler2.handle(new ActionEvent(this, null));
                    }
                }
                if (current.getStatus() == Animation.Status.RUNNING) {
                    current.impl_timePulse(TickCalculation.sub(this.durations[this.curIndex], this.offsetTicks));
                }
                this.oldTicks = this.startTimes[this.curIndex + 1];
            }
            this.offsetTicks = 0L;
            ++this.curIndex;
            while (this.curIndex < newIndex) {
                Animation animation2 = this.cachedChildren[this.curIndex];
                animation2.clipEnvelope.jumpTo(0L);
                if (this.startChild(animation2, this.curIndex)) {
                    animation2.impl_timePulse(this.durations[this.curIndex]);
                } else {
                    handler = animation2.getOnFinished();
                    if (handler != null) {
                        handler.handle(new ActionEvent(this, null));
                    }
                }
                this.oldTicks = this.startTimes[this.curIndex + 1];
                ++this.curIndex;
            }
            Animation newAnimation = this.cachedChildren[this.curIndex];
            newAnimation.clipEnvelope.jumpTo(0L);
            if (this.startChild(newAnimation, this.curIndex)) {
                if (newTicks >= this.startTimes[this.curIndex + 1]) {
                    newAnimation.impl_timePulse(this.durations[this.curIndex]);
                    if (newTicks == cycleTicks) {
                        this.curIndex = this.end;
                    }
                } else {
                    long localTicks = TickCalculation.sub(newTicks, TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]));
                    newAnimation.impl_timePulse(localTicks);
                }
            } else {
                handler = newAnimation.getOnFinished();
                if (handler != null) {
                    handler.handle(new ActionEvent(this, null));
                }
            }
        } else {
            EventHandler<ActionEvent> handler;
            if (current != null) {
                long oldDelay = TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]);
                if (this.oldTicks >= this.startTimes[this.curIndex + 1] || this.oldTicks > oldDelay && current.getStatus() == Animation.Status.STOPPED) {
                    EventHandler<ActionEvent> handler3;
                    boolean enteringCycle;
                    boolean bl = enteringCycle = this.oldTicks >= this.startTimes[this.curIndex + 1];
                    if (enteringCycle) {
                        current.clipEnvelope.jumpTo(Math.round((double)this.durations[this.curIndex] * this.rates[this.curIndex]));
                    }
                    if (!this.startChild(current, this.curIndex) && enteringCycle && (handler3 = current.getOnFinished()) != null) {
                        handler3.handle(new ActionEvent(this, null));
                    }
                }
                if (current.getStatus() == Animation.Status.RUNNING) {
                    current.impl_timePulse(TickCalculation.sub(this.durations[this.curIndex], this.offsetTicks));
                }
                this.oldTicks = this.startTimes[this.curIndex];
            }
            this.offsetTicks = 0L;
            --this.curIndex;
            while (this.curIndex > newIndex) {
                Animation animation3 = this.cachedChildren[this.curIndex];
                animation3.clipEnvelope.jumpTo(Math.round((double)this.durations[this.curIndex] * this.rates[this.curIndex]));
                if (this.startChild(animation3, this.curIndex)) {
                    animation3.impl_timePulse(this.durations[this.curIndex]);
                } else {
                    handler = animation3.getOnFinished();
                    if (handler != null) {
                        handler.handle(new ActionEvent(this, null));
                    }
                }
                this.oldTicks = this.startTimes[this.curIndex];
                --this.curIndex;
            }
            Animation newAnimation = this.cachedChildren[this.curIndex];
            newAnimation.clipEnvelope.jumpTo(Math.round((double)this.durations[this.curIndex] * this.rates[this.curIndex]));
            if (this.startChild(newAnimation, this.curIndex)) {
                if (newTicks <= TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex])) {
                    newAnimation.impl_timePulse(this.durations[this.curIndex]);
                    if (newTicks == 0L) {
                        this.curIndex = -1;
                    }
                } else {
                    long localTicks = TickCalculation.sub(this.startTimes[this.curIndex + 1], newTicks);
                    newAnimation.impl_timePulse(localTicks);
                }
            } else {
                handler = newAnimation.getOnFinished();
                if (handler != null) {
                    handler.handle(new ActionEvent(this, null));
                }
            }
        }
        this.oldTicks = newTicks;
    }

    @Override
    void impl_jumpTo(long currentTicks, long cycleTicks, boolean forceJump) {
        this.impl_setCurrentTicks(currentTicks);
        Animation.Status status = this.getStatus();
        if (status == Animation.Status.STOPPED && !forceJump) {
            return;
        }
        this.impl_sync(false);
        double frac = this.calculateFraction(currentTicks, cycleTicks);
        long newTicks = Math.max(0L, Math.min(this.getCachedInterpolator().interpolate(0L, cycleTicks, frac), cycleTicks));
        int oldIndex = this.curIndex;
        this.curIndex = this.findNewIndex(newTicks);
        Animation newAnimation = this.cachedChildren[this.curIndex];
        double currentRate = this.getCurrentRate();
        long currentDelay = TickCalculation.add(this.startTimes[this.curIndex], this.delays[this.curIndex]);
        if (this.curIndex != oldIndex && status != Animation.Status.STOPPED) {
            Animation oldChild;
            if (oldIndex != -1 && oldIndex != this.end && (oldChild = this.cachedChildren[oldIndex]).getStatus() != Animation.Status.STOPPED) {
                this.cachedChildren[oldIndex].impl_stop();
            }
            if (this.curIndex < oldIndex) {
                int i;
                int n = i = oldIndex == this.end ? this.end - 1 : oldIndex;
                while (i > this.curIndex) {
                    this.cachedChildren[i].impl_jumpTo(0L, this.durations[i], true);
                    --i;
                }
            } else {
                int i;
                int n = i = oldIndex == -1 ? 0 : oldIndex;
                while (i < this.curIndex) {
                    this.cachedChildren[i].impl_jumpTo(this.durations[i], this.durations[i], true);
                    ++i;
                }
            }
            if (newTicks >= currentDelay) {
                this.startChild(newAnimation, this.curIndex);
                if (status == Animation.Status.PAUSED) {
                    newAnimation.impl_pause();
                }
            }
        }
        this.offsetTicks = oldIndex == this.curIndex ? (currentRate == 0.0 ? (long)((double)this.offsetTicks + (double)(newTicks - this.oldTicks) * Math.signum(this.clipEnvelope.getCurrentRate())) : (this.offsetTicks += currentRate > 0.0 ? newTicks - this.oldTicks : this.oldTicks - newTicks)) : (currentRate == 0.0 ? (this.clipEnvelope.getCurrentRate() > 0.0 ? Math.max(0L, newTicks - currentDelay) : this.startTimes[this.curIndex] + this.durations[this.curIndex] - newTicks) : (currentRate > 0.0 ? Math.max(0L, newTicks - currentDelay) : this.startTimes[this.curIndex + 1] - newTicks));
        newAnimation.clipEnvelope.jumpTo(Math.round((double)TickCalculation.sub(newTicks, currentDelay) * this.rates[this.curIndex]));
        this.oldTicks = newTicks;
    }

    private void jumpToEnd() {
        for (int i = 0; i < this.end; ++i) {
            if (this.forceChildSync[i]) {
                this.cachedChildren[i].impl_sync(true);
            }
            this.cachedChildren[i].impl_jumpTo(this.durations[i], this.durations[i], true);
        }
    }

    private void jumpToBefore() {
        for (int i = this.end - 1; i >= 0; --i) {
            if (this.forceChildSync[i]) {
                this.cachedChildren[i].impl_sync(true);
            }
            this.cachedChildren[i].impl_jumpTo(0L, this.durations[i], true);
        }
    }

    @Override
    protected void interpolate(double frac) {
    }
}

