/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.prism.Graphics;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrRenderInfo;

public final class NodeEffectInput
extends Effect {
    private NGNode node;
    private RenderType renderType;
    private BaseBounds tempBounds = new RectBounds();
    private ImageData cachedIdentityImageData;
    private ImageData cachedTransformedImageData;
    private BaseTransform cachedTransform;

    public NodeEffectInput(NGNode node) {
        this(node, RenderType.EFFECT_CONTENT);
    }

    public NodeEffectInput(NGNode node, RenderType renderType) {
        this.node = node;
        this.renderType = renderType;
    }

    public NGNode getNode() {
        return this.node;
    }

    public void setNode(NGNode node) {
        if (this.node != node) {
            this.node = node;
            this.flush();
        }
    }

    static boolean contains(ImageData cachedImage, Rectangle imgbounds) {
        Rectangle cachedBounds = cachedImage.getUntransformedBounds();
        return cachedBounds.contains(imgbounds);
    }

    @Override
    public BaseBounds getBounds(BaseTransform transform, Effect defaultInput) {
        BaseTransform t = transform == null ? BaseTransform.IDENTITY_TRANSFORM : transform;
        this.tempBounds = this.node.getContentBounds(this.tempBounds, t);
        return this.tempBounds.copy();
    }

    @Override
    public ImageData filter(FilterContext fctx, BaseTransform transform, Rectangle outputClip, Object renderHelper, Effect defaultInput) {
        Graphics g;
        if (renderHelper instanceof PrRenderInfo && (g = ((PrRenderInfo)renderHelper).getGraphics()) != null) {
            this.render(g, transform);
            return null;
        }
        Rectangle bounds = NodeEffectInput.getImageBoundsForNode(this.node, this.renderType, transform, outputClip);
        if (transform.isIdentity()) {
            if (this.cachedIdentityImageData != null && NodeEffectInput.contains(this.cachedIdentityImageData, bounds) && this.cachedIdentityImageData.validate(fctx)) {
                this.cachedIdentityImageData.addref();
                return this.cachedIdentityImageData;
            }
        } else if (this.cachedTransformedImageData != null && NodeEffectInput.contains(this.cachedTransformedImageData, bounds) && this.cachedTransformedImageData.validate(fctx) && this.cachedTransform.equals(transform)) {
            this.cachedTransformedImageData.addref();
            return this.cachedTransformedImageData;
        }
        ImageData retData = NodeEffectInput.getImageDataForBoundedNode(fctx, this.node, this.renderType, transform, bounds);
        if (transform.isIdentity()) {
            this.flushIdentityImage();
            this.cachedIdentityImageData = retData;
            this.cachedIdentityImageData.addref();
        } else {
            this.flushTransformedImage();
            this.cachedTransform = transform.copy();
            this.cachedTransformedImageData = retData;
            this.cachedTransformedImageData.addref();
        }
        return retData;
    }

    @Override
    public Effect.AccelType getAccelType(FilterContext fctx) {
        return Effect.AccelType.INTRINSIC;
    }

    public void flushIdentityImage() {
        if (this.cachedIdentityImageData != null) {
            this.cachedIdentityImageData.unref();
            this.cachedIdentityImageData = null;
        }
    }

    public void flushTransformedImage() {
        if (this.cachedTransformedImageData != null) {
            this.cachedTransformedImageData.unref();
            this.cachedTransformedImageData = null;
        }
        this.cachedTransform = null;
    }

    public void flush() {
        this.flushIdentityImage();
        this.flushTransformedImage();
    }

    public void render(Graphics g, BaseTransform transform) {
        BaseTransform savetx = null;
        if (!transform.isIdentity()) {
            savetx = g.getTransformNoClone().copy();
            g.transform(transform);
        }
        this.node.renderContent(g);
        if (savetx != null) {
            g.setTransform(savetx);
        }
    }

    static ImageData getImageDataForNode(FilterContext fctx, NGNode node, boolean contentOnly, BaseTransform transform, Rectangle clip) {
        RenderType rendertype = contentOnly ? RenderType.EFFECT_CONTENT : RenderType.FULL_CONTENT;
        Rectangle r = NodeEffectInput.getImageBoundsForNode(node, rendertype, transform, clip);
        return NodeEffectInput.getImageDataForBoundedNode(fctx, node, rendertype, transform, r);
    }

    static Rectangle getImageBoundsForNode(NGNode node, RenderType type, BaseTransform transform, Rectangle clip) {
        BaseBounds bounds = new RectBounds();
        switch (type) {
            case EFFECT_CONTENT: {
                bounds = node.getContentBounds(bounds, transform);
                break;
            }
            case FULL_CONTENT: {
                bounds = node.getCompleteBounds(bounds, transform);
                break;
            }
            case CLIPPED_CONTENT: {
                bounds = node.getClippedBounds(bounds, transform);
            }
        }
        Rectangle r = new Rectangle(bounds);
        if (clip != null) {
            r.intersectWith(clip);
        }
        return r;
    }

    private static ImageData getImageDataForBoundedNode(FilterContext fctx, NGNode node, RenderType renderType, BaseTransform transform, Rectangle bounds) {
        PrDrawable ret = (PrDrawable)Effect.getCompatibleImage(fctx, bounds.width, bounds.height);
        if (ret != null) {
            Graphics g = ret.createGraphics();
            g.translate(-bounds.x, -bounds.y);
            if (transform != null) {
                g.transform(transform);
            }
            switch (renderType) {
                case EFFECT_CONTENT: {
                    node.renderContent(g);
                    break;
                }
                case FULL_CONTENT: {
                    node.render(g);
                    break;
                }
                case CLIPPED_CONTENT: {
                    node.renderForClip(g);
                }
            }
        }
        return new ImageData(fctx, ret, bounds);
    }

    @Override
    public boolean reducesOpaquePixels() {
        return false;
    }

    @Override
    public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
        return null;
    }

    public static enum RenderType {
        EFFECT_CONTENT,
        CLIPPED_CONTENT,
        FULL_CONTENT;

    }
}

