/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.TwoLevelFocusPopupBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.ContextMenuContent;
import com.sun.javafx.scene.control.skin.EmbeddedTextContextMenuContent;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.Collection;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.Skin;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.WindowEvent;

public class ContextMenuSkin
implements Skin<ContextMenu> {
    private ContextMenu popupMenu;
    private final Region root;
    private TwoLevelFocusPopupBehavior tlFocus;
    private final EventHandler<KeyEvent> keyListener = new EventHandler<KeyEvent>(){

        @Override
        public void handle(KeyEvent event) {
            if (event.getEventType() != KeyEvent.KEY_PRESSED) {
                return;
            }
            if (!ContextMenuSkin.this.root.isFocused()) {
                return;
            }
            KeyCode code = event.getCode();
            switch (code) {
                case ENTER: 
                case SPACE: {
                    ContextMenuSkin.this.popupMenu.hide();
                    return;
                }
            }
        }
    };

    public ContextMenuSkin(final ContextMenu popupMenu) {
        this.popupMenu = popupMenu;
        popupMenu.addEventHandler(Menu.ON_SHOWN, new EventHandler<Event>(){

            @Override
            public void handle(Event event) {
                Node cmContent = popupMenu.getSkin().getNode();
                if (cmContent != null) {
                    cmContent.requestFocus();
                    if (cmContent instanceof ContextMenuContent) {
                        VBox accMenu = ((ContextMenuContent)cmContent).getItemsContainer();
                        accMenu.notifyAccessibleAttributeChanged(AccessibleAttribute.VISIBLE);
                    }
                }
                ContextMenuSkin.this.root.addEventHandler(KeyEvent.KEY_PRESSED, ContextMenuSkin.this.keyListener);
            }
        });
        popupMenu.addEventHandler(Menu.ON_HIDDEN, new EventHandler<Event>(){

            @Override
            public void handle(Event event) {
                Node cmContent = popupMenu.getSkin().getNode();
                if (cmContent != null) {
                    cmContent.requestFocus();
                }
                ContextMenuSkin.this.root.removeEventHandler(KeyEvent.KEY_PRESSED, ContextMenuSkin.this.keyListener);
            }
        });
        popupMenu.addEventFilter(WindowEvent.WINDOW_HIDING, new EventHandler<Event>(){

            @Override
            public void handle(Event event) {
                Node cmContent = popupMenu.getSkin().getNode();
                if (cmContent instanceof ContextMenuContent) {
                    VBox accMenu = ((ContextMenuContent)cmContent).getItemsContainer();
                    accMenu.notifyAccessibleAttributeChanged(AccessibleAttribute.VISIBLE);
                }
            }
        });
        this.root = BehaviorSkinBase.IS_TOUCH_SUPPORTED && popupMenu.getStyleClass().contains("text-input-context-menu") ? new EmbeddedTextContextMenuContent(popupMenu) : new ContextMenuContent(popupMenu);
        this.root.idProperty().bind(popupMenu.idProperty());
        this.root.styleProperty().bind(popupMenu.styleProperty());
        this.root.getStyleClass().addAll((Collection<String>)popupMenu.getStyleClass());
        if (Utils.isTwoLevelFocus()) {
            this.tlFocus = new TwoLevelFocusPopupBehavior(popupMenu);
        }
    }

    @Override
    public ContextMenu getSkinnable() {
        return this.popupMenu;
    }

    @Override
    public Node getNode() {
        return this.root;
    }

    @Override
    public void dispose() {
        this.root.idProperty().unbind();
        this.root.styleProperty().unbind();
        if (this.tlFocus != null) {
            this.tlFocus.dispose();
        }
    }
}

