/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Line2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.transform.BaseTransform;
import java.util.NoSuchElementException;

class LineIterator
implements PathIterator {
    Line2D line;
    BaseTransform transform;
    int index;

    LineIterator(Line2D l, BaseTransform tx) {
        this.line = l;
        this.transform = tx;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > 1;
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public int currentSegment(float[] coords) {
        int type;
        if (this.isDone()) {
            throw new NoSuchElementException("line iterator out of bounds");
        }
        if (this.index == 0) {
            coords[0] = this.line.x1;
            coords[1] = this.line.y1;
            type = 0;
        } else {
            coords[0] = this.line.x2;
            coords[1] = this.line.y2;
            type = 1;
        }
        if (this.transform != null) {
            this.transform.transform(coords, 0, coords, 0, 1);
        }
        return type;
    }
}

