/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.Combinator;
import com.sun.javafx.css.CompoundSelector;
import com.sun.javafx.css.Match;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.SimpleSelector;
import com.sun.javafx.css.StringStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javafx.css.PseudoClass;
import javafx.css.Styleable;

public abstract class Selector {
    private Rule rule;
    private int ordinal = -1;
    private static final int TYPE_SIMPLE = 1;
    private static final int TYPE_COMPOUND = 2;

    public static Selector getUniversalSelector() {
        return UniversalSelector.INSTANCE;
    }

    void setRule(Rule rule) {
        this.rule = rule;
    }

    Rule getRule() {
        return this.rule;
    }

    void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    int getOrdinal() {
        return this.ordinal;
    }

    abstract Match createMatch();

    public abstract boolean applies(Styleable var1);

    abstract boolean applies(Styleable var1, Set<PseudoClass>[] var2, int var3);

    public abstract boolean stateMatches(Styleable var1, Set<PseudoClass> var2);

    protected void writeBinary(DataOutputStream os, StringStore stringStore) throws IOException {
        if (this instanceof SimpleSelector) {
            os.writeByte(1);
        } else {
            os.writeByte(2);
        }
    }

    static Selector readBinary(int bssVersion, DataInputStream is, String[] strings) throws IOException {
        byte type = is.readByte();
        if (type == 1) {
            return SimpleSelector.readBinary(bssVersion, is, strings);
        }
        return CompoundSelector.readBinary(bssVersion, is, strings);
    }

    public static Selector createSelector(String cssSelector) {
        int i;
        if (cssSelector == null || cssSelector.length() == 0) {
            return null;
        }
        ArrayList<SimpleSelector> selectors = new ArrayList<SimpleSelector>();
        ArrayList<Combinator> combinators = new ArrayList<Combinator>();
        ArrayList<String> parts = new ArrayList<String>();
        int start = 0;
        int end = -1;
        char combinator = '\u0000';
        for (i = 0; i < cssSelector.length(); ++i) {
            char ch = cssSelector.charAt(i);
            if (ch == ' ') {
                if (combinator != '\u0000') continue;
                combinator = ch;
                end = i;
                continue;
            }
            if (ch == '>') {
                if (combinator == '\u0000') {
                    end = i;
                }
                combinator = ch;
                continue;
            }
            if (combinator == '\u0000') continue;
            parts.add(cssSelector.substring(start, end));
            start = i;
            combinators.add(combinator == ' ' ? Combinator.DESCENDANT : Combinator.CHILD);
            combinator = '\u0000';
        }
        parts.add(cssSelector.substring(start));
        for (i = 0; i < parts.size(); ++i) {
            String part = (String)parts.get(i);
            if (part == null || part.equals("")) continue;
            String[] pseudoClassParts = part.split(":");
            ArrayList<String> pseudoClasses = new ArrayList<String>();
            for (int j = 1; j < pseudoClassParts.length; ++j) {
                if (pseudoClassParts[j] == null || pseudoClassParts[j].equals("")) continue;
                pseudoClasses.add(pseudoClassParts[j].trim());
            }
            String selector = pseudoClassParts[0].trim();
            String[] styleClassParts = selector.split("\\.");
            ArrayList<String> styleClasses = new ArrayList<String>();
            for (int j = 1; j < styleClassParts.length; ++j) {
                if (styleClassParts[j] == null || styleClassParts[j].equals("")) continue;
                styleClasses.add(styleClassParts[j].trim());
            }
            String name = null;
            String id = null;
            if (!styleClassParts[0].equals("")) {
                if (styleClassParts[0].charAt(0) == '#') {
                    id = styleClassParts[0].substring(1).trim();
                } else {
                    name = styleClassParts[0].trim();
                }
            }
            selectors.add(new SimpleSelector(name, styleClasses, pseudoClasses, id));
        }
        if (selectors.size() == 1) {
            return (Selector)selectors.get(0);
        }
        return new CompoundSelector(selectors, combinators);
    }

    private static class UniversalSelector {
        private static final Selector INSTANCE = new SimpleSelector("*", null, null, null);

        private UniversalSelector() {
        }
    }
}

