/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.providers.contexts;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.thymeleaf.lang.support.ThymeleafContextVariablesProvider;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafVariable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ThymeleafTopPackagesVariablesProvider
extends ThymeleafContextVariablesProvider {
    @Override
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/thymeleaf/providers/contexts/ThymeleafTopPackagesVariablesProvider", "getContextVariables"));
        }
        LinkedHashSet vars = ContainerUtil.newLinkedHashSet();
        Project project = contextElement.getProject();
        for (PsiPackage aPackage : ThymeleafTopPackagesVariablesProvider.getDefaultPackages(project)) {
            PsiClass[] psiClassArray = aPackage.getClasses();
            int n = psiClassArray.length;
            for (int i = 0; i < n; ++i) {
                PsiClass aClass = psiClassArray[i];
                vars.add(new ThymeleafVariable(aClass.getName(), (PsiType)PsiTypesUtil.getClassType((PsiClass)aClass), (PsiElement)aClass));
            }
        }
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)project).findPackage("");
        if (defaultPackage != null) {
            for (PsiPackage psiPackage : defaultPackage.getSubPackages()) {
            }
        }
        LinkedHashSet linkedHashSet = vars;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/providers/contexts/ThymeleafTopPackagesVariablesProvider", "getContextVariables"));
        }
        return linkedHashSet;
    }

    @NotNull
    public static Set<PsiPackage> getDefaultPackages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/thymeleaf/providers/contexts/ThymeleafTopPackagesVariablesProvider", "getDefaultPackages"));
        }
        HashSet imported = new HashSet();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        ContainerUtil.addIfNotNull((Collection)imported, (Object)facade.findPackage("java.lang"));
        HashSet hashSet = imported;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/providers/contexts/ThymeleafTopPackagesVariablesProvider", "getDefaultPackages"));
        }
        return hashSet;
    }
}

