/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.providers.contexts;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.intellij.thymeleaf.lang.psi.ThymesElExpression;
import com.intellij.thymeleaf.lang.psi.ThymesLocalVariablesInitExpression;
import com.intellij.thymeleaf.lang.psi.ThymesVariableInitExpression;
import com.intellij.thymeleaf.lang.support.ThymeleafContextVariablesProvider;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ThymeleafLocalVariablesProvider
extends ThymeleafContextVariablesProvider {
    @Override
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/thymeleaf/providers/contexts/ThymeleafLocalVariablesProvider", "getContextVariables"));
        }
        HashSet variables = new HashSet();
        for (ThymesElExpression expression : ThymeleafCommonUtil.findWithExpressions(contextElement)) {
            if (expression instanceof ThymesLocalVariablesInitExpression) {
                for (ThymesVariableInitExpression thymesElExpression : ((ThymesLocalVariablesInitExpression)expression).getVariableInitExpressionList()) {
                    variables.add(thymesElExpression);
                }
                continue;
            }
            if (!(expression instanceof ThymesVariableInitExpression)) continue;
            variables.add((ThymesVariableInitExpression)expression);
        }
        HashSet hashSet = variables;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/providers/contexts/ThymeleafLocalVariablesProvider", "getContextVariables"));
        }
        return hashSet;
    }
}

