/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.support;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.thymeleaf.lang.ThymeleafPsiFile;
import com.intellij.thymeleaf.lang.psi.ThymeleafPsiCompositeElement;
import com.intellij.thymeleaf.lang.psi.ThymesMessagePropertyKey;
import com.intellij.thymeleaf.lang.psi.ThymesVisitor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafResourcesFoldingBuilder
extends FoldingBuilderEx {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/thymeleaf/lang/support/ThymeleafResourcesFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/thymeleaf/lang/support/ThymeleafResourcesFoldingBuilder", "buildFoldRegions"));
        }
        if (!(root instanceof ThymeleafPsiFile) || quick || !JavaCodeFoldingSettings.getInstance().isCollapseI18nMessages()) {
            if (FoldingDescriptor.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/ThymeleafResourcesFoldingBuilder", "buildFoldRegions"));
            }
            return FoldingDescriptor.EMPTY;
        }
        SmartList regions = new SmartList();
        root.acceptChildren((PsiElementVisitor)new ThymesVisitor((List)regions){
            final /* synthetic */ List val$regions;
            {
                this.val$regions = list;
            }

            @Override
            public void visitMessagePropertyKey(@NotNull ThymesMessagePropertyKey key) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/thymeleaf/lang/support/ThymeleafResourcesFoldingBuilder$1", "visitMessagePropertyKey"));
                }
                PsiReference reference = key.getReference();
                if (reference instanceof PropertyReference) {
                    PropertyReference propertyReference = (PropertyReference)reference;
                    ContainerUtil.addIfNotNull((Collection)this.val$regions, (Object)ThymeleafResourcesFoldingBuilder.createDescriptor(key, propertyReference));
                }
            }

            @Override
            public void visitThymeleafPsiCompositeElement(@NotNull ThymeleafPsiCompositeElement o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/thymeleaf/lang/support/ThymeleafResourcesFoldingBuilder$1", "visitThymeleafPsiCompositeElement"));
                }
                o.acceptChildren(this);
            }
        });
        FoldingDescriptor[] foldingDescriptorArray = regions.isEmpty() ? FoldingDescriptor.EMPTY : regions.toArray(new FoldingDescriptor[regions.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/ThymeleafResourcesFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    @Nullable
    private static FoldingDescriptor createDescriptor(ThymesMessagePropertyKey element, PropertyReference propertyReference) {
        final ResolveResult[] results = propertyReference.multiResolve(false);
        if (results.length == 0) {
            return null;
        }
        return new FoldingDescriptor(element, propertyReference.getRangeInElement().shiftRight(element.getTextRange().getStartOffset())){

            @NotNull
            public Set<Object> getDependencies() {
                PsiElement property;
                if (results.length > 0 && (property = results[0].getElement()) != null) {
                    PsiFile containingFile = property.getContainingFile();
                    Set set = ContainerUtil.createMaybeSingletonSet((Object)containingFile);
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/ThymeleafResourcesFoldingBuilder$2", "getDependencies"));
                    }
                    return set;
                }
                Set set = super.getDependencies();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/ThymeleafResourcesFoldingBuilder$2", "getDependencies"));
                }
                return set;
            }
        };
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/thymeleaf/lang/support/ThymeleafResourcesFoldingBuilder", "getPlaceholderText"));
        }
        PsiElement element = node.getPsi();
        PsiElement property = ThymeleafResourcesFoldingBuilder.resolveProperty(element);
        String text = null;
        if (property instanceof IProperty) {
            text = ((IProperty)property).getUnescapedValue();
        }
        if (text == null) {
            return null;
        }
        return text.trim().isEmpty() ? "<empty>" : text;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/thymeleaf/lang/support/ThymeleafResourcesFoldingBuilder", "isCollapsedByDefault"));
        }
        return true;
    }

    @Nullable
    private static PsiElement resolveProperty(PsiElement element) {
        if (element != null) {
            for (PsiReference reference : element.getReferences()) {
                ResolveResult[] results;
                if (!(reference instanceof PropertyReference) || (results = ((PropertyReference)reference).multiResolve(false)).length <= 0) continue;
                return results[0].getElement();
            }
        }
        return null;
    }
}

