/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.support;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.BeanPropertyRenameHandler;
import com.intellij.thymeleaf.lang.psi.ThymesELMethodCallExpression;
import com.intellij.thymeleaf.lang.psi.ThymesELVariable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafPropertyRenameHandler
extends BeanPropertyRenameHandler {
    @Nullable
    protected BeanProperty getProperty(DataContext context) {
        return ThymeleafPropertyRenameHandler.getBeanProperty(context);
    }

    @Nullable
    public static BeanProperty getBeanProperty(DataContext dataContext) {
        Project project;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null && editor != null && ApplicationManager.getApplication().isUnitTestMode() && (project = editor.getProject()) != null) {
            file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        if (editor != null && file != null) {
            return ThymeleafPropertyRenameHandler.getBeanProperty(editor, file);
        }
        return null;
    }

    @Nullable
    private static BeanProperty getBeanProperty(@NotNull Editor editor, @NotNull PsiFile file) {
        ThymesELVariable elVariable;
        ThymesELMethodCallExpression methodCallExpression;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/thymeleaf/lang/support/ThymeleafPropertyRenameHandler", "getBeanProperty"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/thymeleaf/lang/support/ThymeleafPropertyRenameHandler", "getBeanProperty"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiReference reference = file.findReferenceAt(offset);
        if (reference instanceof ThymesELVariable && ((methodCallExpression = (ThymesELMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)(elVariable = (ThymesELVariable)reference), ThymesELMethodCallExpression.class)) == null || methodCallExpression.getMethod() != elVariable)) {
            PsiElement psiElement = reference.resolve();
            return ThymeleafPropertyRenameHandler.getBeanProperty(psiElement);
        }
        return null;
    }

    @Nullable
    public static BeanProperty getBeanProperty(PsiElement psiElement) {
        if (psiElement instanceof PsiMethod && PropertyUtil.isSimplePropertyAccessor((PsiMethod)((PsiMethod)psiElement))) {
            return BeanProperty.createBeanProperty((PsiMethod)((PsiMethod)psiElement));
        }
        return null;
    }
}

