/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.injectors;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.thymeleaf.dialects.ThymeleafDialect;
import com.intellij.thymeleaf.dialects.ThymeleafDialects;
import com.intellij.thymeleaf.lang.ThymeleafLanguage;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafExpressionsInjector
implements MultiHostInjector {
    private static Map<Condition<String>, ThymeleafLanguage> injectors = new HashMap();

    private static Condition<String> createAttrNameCondition(String ... attrNames) {
        return localName -> {
            for (String name : attrNames) {
                if (!localName.equals(name)) continue;
                return true;
            }
            return false;
        };
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        int endOffset;
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/thymeleaf/lang/injectors/ThymeleafExpressionsInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/thymeleaf/lang/injectors/ThymeleafExpressionsInjector", "getLanguagesToInject"));
        }
        if (!ThymeleafCommonUtil.hasThymeleafLibrary(host.getProject())) {
            return;
        }
        ThymeleafLanguage languageToInject = this.getLanguageToInject((XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)host, XmlAttribute.class));
        if (languageToInject != null && (endOffset = host.getTextLength() - 1) > 0) {
            registrar.startInjecting((Language)languageToInject).addPlace(null, null, (PsiLanguageInjectionHost)host, TextRange.create((int)1, (int)endOffset)).doneInjecting();
        }
    }

    @Nullable
    public ThymeleafLanguage getLanguageToInject(@Nullable XmlAttribute xmlAttribute) {
        if (xmlAttribute == null) {
            return null;
        }
        String attrName = this.getThymeleafAttrName(xmlAttribute);
        if (attrName != null) {
            for (Map.Entry<Condition<String>, ThymeleafLanguage> entry : injectors.entrySet()) {
                if (!entry.getKey().value((Object)attrName)) continue;
                return entry.getValue();
            }
            String namespace = xmlAttribute.getNamespace();
            for (ThymeleafDialect dialect : ThymeleafDialects.getDialects(xmlAttribute.getProject())) {
                for (String ns : dialect.getNamespaces()) {
                    if (!ns.equals(namespace)) continue;
                    return dialect.getLanguage();
                }
            }
            return ThymeleafLanguage.EXPRESSIONS;
        }
        return null;
    }

    @Nullable
    public String getThymeleafAttrName(@NotNull XmlAttribute xmlAttribute) {
        if (xmlAttribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttribute", "com/intellij/thymeleaf/lang/injectors/ThymeleafExpressionsInjector", "getThymeleafAttrName"));
        }
        String localName = xmlAttribute.getLocalName();
        if (ThymeleafCommonUtil.isThymeleafNamespace(xmlAttribute.getNamespace(), xmlAttribute.getProject())) {
            return localName;
        }
        return ThymeleafExpressionsInjector.getThymeleafAttrNameHtml5(xmlAttribute);
    }

    @Nullable
    public static String getThymeleafAttrNameHtml5(@NotNull XmlAttribute xmlAttribute) {
        String prefix;
        String prefixByNamespace;
        if (xmlAttribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttribute", "com/intellij/thymeleaf/lang/injectors/ThymeleafExpressionsInjector", "getThymeleafAttrNameHtml5"));
        }
        String localName = xmlAttribute.getLocalName();
        XmlTag tag = xmlAttribute.getParent();
        if (tag != null && (prefixByNamespace = ThymeleafCommonUtil.getPrefixByThymeleafNamespace(tag)) != null && localName.startsWith(prefix = "data-" + prefixByNamespace + "-")) {
            return localName.substring(prefix.length());
        }
        return null;
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlAttributeValue.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/injectors/ThymeleafExpressionsInjector", "elementsToInjectIn"));
        }
        return list;
    }

    static {
        injectors.put(ThymeleafExpressionsInjector.createAttrNameCondition("each"), ThymeleafLanguage.EACH_EXPRESSIONS);
        injectors.put(ThymeleafExpressionsInjector.createAttrNameCondition("href", "src", "action"), ThymeleafLanguage.URL_EXPRESSIONS);
        injectors.put(ThymeleafExpressionsInjector.createAttrNameCondition("include", "remove", "replace", "fragment", "substituteby"), ThymeleafLanguage.TEMPLATES_EXPRESSIONS);
    }
}

