/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections.htmltagreplace;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.htmlInspections.htmltagreplace.HtmlTagReplaceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.xml.XmlBundle;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceAppletTagAction
implements LocalQuickFix {
    @NonNls
    private static final Set<String> ourObjectAttributes = new HashSet();

    @NotNull
    public String getName() {
        String string = XmlBundle.message((String)"html.replace.tag.with.another.quickfix.text", (Object[])new Object[]{"applet", "object"});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceAppletTagAction", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        if ("ReplaceDeprecatedTag" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceAppletTagAction", "getFamilyName"));
        }
        return "ReplaceDeprecatedTag";
    }

    private static PsiElement[] generateContainingElements(@NotNull Project project, String tagName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceAppletTagAction", "generateContainingElements"));
        }
        XmlFile xmlFile = HtmlTagReplaceUtil.genereateXmlFileWithSingleTag(project, "object");
        return HtmlTagReplaceUtil.getXmlNamesFromSingleTagFile(xmlFile);
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        void var11_18;
        PsiElement parent;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceAppletTagAction", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/htmlInspections/htmltagreplace/ReplaceAppletTagAction", "applyFix"));
        }
        for (parent = descriptor.getPsiElement(); !(parent == null || parent instanceof XmlTag && "applet".equals(((XmlTag)parent).getLocalName().toLowerCase())); parent = parent.getParent()) {
        }
        if (parent == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(parent.getContainingFile())) {
            return;
        }
        String name = ((XmlTag)parent).getLocalName().toLowerCase();
        XmlTag tag = (XmlTag)parent;
        PsiElement[] replacePsiElements = ReplaceAppletTagAction.generateContainingElements(project, name);
        int cnt = 0;
        for (PsiElement psiElement : tag.getChildren()) {
            XmlToken token;
            IElementType type;
            if (!(psiElement instanceof XmlToken) || (type = (token = (XmlToken)psiElement).getTokenType()) != XmlTokenType.XML_NAME) continue;
            token.replace(replacePsiElements[cnt++]);
        }
        for (PsiElement psiElement : tag.getAttributes()) {
            String attName = psiElement.getName();
            if (!"object".equals(attName) && !ourObjectAttributes.contains(attName)) {
                String value;
                String attributeValue = psiElement.getValue();
                String string = value = attributeValue != null ? attributeValue.trim() : "";
                if ("code".equals(attName) && value.endsWith(".class")) {
                    value = value.substring(0, value.length() - ".class".length());
                }
                XmlFile file = HtmlTagReplaceUtil.generateXmlFile(project, "<param name=\"" + attName + "\" value=\"" + value + "\" />");
                XmlTag element = file.getDocument().getRootTag();
                assert (element != null);
                PsiElement[] psiElementArray = tag.getChildren();
                int n = psiElementArray.length;
                for (int i = 0; i < n; ++i) {
                    IElementType type;
                    PsiElement psiElement2 = psiElementArray[i];
                    if (!(psiElement2 instanceof XmlToken) || (type = ((XmlToken)psiElement2).getTokenType()) != XmlTokenType.XML_TAG_END) continue;
                    tag.add((PsiElement)element);
                    break;
                }
                if ("name".equals(attName)) continue;
                psiElement.delete();
                continue;
            }
            if (!"object".equals(attName)) continue;
            psiElement.setName("data");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<a>");
        builder.append("\n<!--[if !IE]> -->");
        builder.append("<object");
        XmlAttribute[] xmlAttributeArray = tag.getAttributes();
        int n = xmlAttributeArray.length;
        boolean bl = false;
        while (var11_18 < n) {
            XmlAttribute attribute = xmlAttributeArray[var11_18];
            if (!"classid".equals(attribute.getName().toLowerCase()) && !"codebase".equals(attribute.getName().toLowerCase())) {
                builder.append(" ");
                builder.append(attribute.getName().toLowerCase());
                builder.append("=\"");
                builder.append(attribute.getValue());
                builder.append("\"");
            }
            ++var11_18;
        }
        builder.append(">");
        boolean contentStarted = false;
        for (PsiElement element : tag.getChildren()) {
            if (element instanceof XmlToken) {
                if (((XmlToken)element).getTokenType() == XmlTokenType.XML_TAG_END) {
                    contentStarted = true;
                    continue;
                }
                if (((XmlToken)element).getTokenType() != XmlTokenType.XML_END_TAG_START) continue;
                break;
            }
            if (!contentStarted) continue;
            builder.append(element.getText());
        }
        builder.append("</object>");
        builder.append("\n<!-- <![endif]-->\n");
        builder.append("</a>");
        XmlFile file = HtmlTagReplaceUtil.generateXmlFile(project, builder.toString());
        XmlTag xmlTag = file.getDocument().getRootTag();
        assert (xmlTag != null);
        block6: for (PsiElement element : tag.getChildren()) {
            if (!(element instanceof XmlToken) || ((XmlToken)element).getTokenType() != XmlTokenType.XML_END_TAG_START) continue;
            contentStarted = false;
            for (PsiElement psiElement : xmlTag.getChildren()) {
                if (psiElement instanceof XmlToken) {
                    if (((XmlToken)psiElement).getTokenType() == XmlTokenType.XML_TAG_END) {
                        contentStarted = true;
                        continue;
                    }
                    if (((XmlToken)psiElement).getTokenType() != XmlTokenType.XML_END_TAG_START) continue;
                    continue block6;
                }
                if (!contentStarted) continue;
                if (psiElement instanceof XmlTag) {
                    ((XmlTag)psiElement).setAttribute("type", "application/x-java-applet");
                }
                tag.addBefore(psiElement, element);
            }
        }
        tag.setAttribute("classid", "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93");
        tag.setAttribute("codebase", "http://java.sun.com/products/plugin/autodl/jinstall-1_4-windows-i586.cab#Version=1,4,0,0");
    }

    static {
        ourObjectAttributes.addAll(Arrays.asList("align", "height", "hspace", "title", "vspace", "width"));
    }
}

