/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.codeInsight.preview.BaseHtmlPreviewHintProvider;
import com.intellij.codeInsight.preview.ColorPreviewComponent;
import com.intellij.codeInsight.preview.ImagePreviewComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.io.URLUtil;
import com.intellij.xml.util.ColorMap;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Locale;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlPreviewHintProvider
extends BaseHtmlPreviewHintProvider {
    public JComponent getPreviewComponent(@NotNull PsiElement element) {
        PsiElement parentParent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/preview/HtmlPreviewHintProvider", "getPreviewComponent"));
        }
        if (element.getParent() instanceof XmlAttributeValue && (parentParent = element.getParent().getParent()) instanceof XmlAttribute) {
            PsiElement attributeValue;
            String s;
            XmlAttribute attribute = (XmlAttribute)parentParent;
            String attrName = attribute.getName();
            if (("alink".equalsIgnoreCase(attrName) || "link".equalsIgnoreCase(attrName) || "text".equalsIgnoreCase(attrName) || "vlink".equalsIgnoreCase(attrName) || StringUtil.containsIgnoreCase((String)attrName, (String)"color")) && (s = element.getText()).length() > 0) {
                String hexColor;
                String string = hexColor = s.charAt(0) == '#' ? s : ColorMap.getHexCodeForColorName((String)s.toLowerCase(Locale.US));
                if (hexColor != null) {
                    try {
                        return new ColorPreviewComponent(Color.decode("0x" + hexColor.substring(1)));
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
            }
            if ((attributeValue = element.getParent()).getParent() instanceof XmlAttribute && ("background".equalsIgnoreCase(attrName) || "src".equalsIgnoreCase(attrName) || "href".equalsIgnoreCase(attrName))) {
                String attrValue = attribute.getValue();
                if (attrValue != null && URLUtil.isDataUri((String)attrValue)) {
                    return HtmlPreviewHintProvider.getPreviewFromDataUri(attrValue);
                }
                for (PsiElement parent = element; parent != null && parent != attribute; parent = parent.getParent()) {
                    JComponent c = ImagePreviewComponent.getPreviewComponent((PsiElement)parent);
                    if (c == null) continue;
                    return c;
                }
            }
        }
        return null;
    }

    @Nullable
    private static JComponent getPreviewFromDataUri(@NotNull String dataUri) {
        if (dataUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataUri", "com/intellij/codeInsight/preview/HtmlPreviewHintProvider", "getPreviewFromDataUri"));
        }
        ImagePreviewComponent preview = null;
        byte[] imageBytes = URLUtil.getBytesFromDataUri((String)dataUri);
        if (imageBytes != null) {
            try {
                preview = ImagePreviewComponent.getPreviewComponent((BufferedImage)ImagePreviewComponent.readImageFromBytes((byte[])imageBytes), (long)imageBytes.length);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return preview;
    }
}

