/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;

public class OsgiUiUtil {

    public static class FrameworkInstanceRenderer
    extends ColoredListCellRenderer<FrameworkInstanceDefinition> {
        private final String myDefaultText;

        public FrameworkInstanceRenderer() {
            this(null);
        }

        public FrameworkInstanceRenderer(@Nullable String defaultText) {
            this.myDefaultText = defaultText;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends FrameworkInstanceDefinition> list, FrameworkInstanceDefinition instance, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/osmorc/util/OsgiUiUtil$FrameworkInstanceRenderer", "customizeCellRenderer"));
            }
            if (instance != null) {
                this.append(instance.getName());
                if (this.isInstanceDefined(instance)) {
                    String version = instance.getVersion();
                    if (StringUtil.isEmptyOrSpaces((String)version)) {
                        version = "unknown";
                    }
                    this.append(" [" + instance.getFrameworkIntegratorName() + ", " + version + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
                } else {
                    this.append(" [invalid]", SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
            } else if (this.myDefaultText != null) {
                this.append(this.myDefaultText, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }

        protected boolean isInstanceDefined(@NotNull FrameworkInstanceDefinition instance) {
            if (instance == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "org/osmorc/util/OsgiUiUtil$FrameworkInstanceRenderer", "isInstanceDefined"));
            }
            return true;
        }
    }
}

