/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="Osmorc")
public class ProjectSettings
implements PersistentStateComponent<ProjectSettings> {
    private EventDispatcher<ProjectSettingsListener> myDispatcher = EventDispatcher.create(ProjectSettingsListener.class);
    private String myFrameworkInstanceName;
    private String myDefaultManifestFileLocation = "META-INF/MANIFEST.MF";
    private String myBundlesOutputPath;
    private boolean myBndAutoImport = false;

    @NotNull
    public static String getDefaultBundlesOutputPath(Project project) {
        VirtualFilePointer compilerOutput;
        CompilerProjectExtension instance = CompilerProjectExtension.getInstance((Project)project);
        if (instance != null && (compilerOutput = instance.getCompilerOutputPointer()) != null) {
            String string = VfsUtilCore.urlToPath((String)compilerOutput.getUrl()) + "/bundles";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/settings/ProjectSettings", "getDefaultBundlesOutputPath"));
            }
            return string;
        }
        String string = FileUtil.getTempDirectory();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/settings/ProjectSettings", "getDefaultBundlesOutputPath"));
        }
        return string;
    }

    public static ProjectSettings getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/osmorc/settings/ProjectSettings", "getInstance"));
        }
        return (ProjectSettings)ServiceManager.getService((Project)project, ProjectSettings.class);
    }

    @Nullable
    public String getBundlesOutputPath() {
        return this.myBundlesOutputPath;
    }

    public void setBundlesOutputPath(@Nullable String bundlesOutputPath) {
        this.myBundlesOutputPath = bundlesOutputPath;
    }

    @Nullable
    public String getFrameworkInstanceName() {
        return this.myFrameworkInstanceName;
    }

    public void setFrameworkInstanceName(@Nullable String frameworkInstanceName) {
        this.myFrameworkInstanceName = frameworkInstanceName;
        ((ProjectSettingsListener)this.myDispatcher.getMulticaster()).projectSettingsChanged();
    }

    @NotNull
    public String getDefaultManifestFileLocation() {
        String string = this.myDefaultManifestFileLocation;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/settings/ProjectSettings", "getDefaultManifestFileLocation"));
        }
        return string;
    }

    public void setDefaultManifestFileLocation(@NotNull String location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/osmorc/settings/ProjectSettings", "setDefaultManifestFileLocation"));
        }
        this.myDefaultManifestFileLocation = location.equals("META-INF") ? "META-INF/MANIFEST.MF" : location;
        ((ProjectSettingsListener)this.myDispatcher.getMulticaster()).projectSettingsChanged();
    }

    public boolean isBndAutoImport() {
        return this.myBndAutoImport;
    }

    public void setBndAutoImport(boolean bndAutoImport) {
        this.myBndAutoImport = bndAutoImport;
    }

    @NotNull
    public ProjectSettings getState() {
        ProjectSettings projectSettings = this;
        if (projectSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/settings/ProjectSettings", "getState"));
        }
        return projectSettings;
    }

    public void loadState(@NotNull ProjectSettings state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/osmorc/settings/ProjectSettings", "loadState"));
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public void addProjectSettingsListener(@NotNull ProjectSettingsListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/osmorc/settings/ProjectSettings", "addProjectSettingsListener"));
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeProjectSettingsListener(@NotNull ProjectSettingsListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/osmorc/settings/ProjectSettings", "removeProjectSettingsListener"));
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public static interface ProjectSettingsListener
    extends EventListener {
        public void projectSettingsChanged();
    }
}

