/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run.ui;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectedBundle {
    private final BundleType myBundleType;
    private String myDisplayName;
    private String myBundlePath;
    private int myStartLevel;
    private boolean myStartAfterInstallation;

    public SelectedBundle(@NotNull BundleType bundleType, @NotNull String displayName, @Nullable String path) {
        if (bundleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundleType", "org/osmorc/run/ui/SelectedBundle", "<init>"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "org/osmorc/run/ui/SelectedBundle", "<init>"));
        }
        this.myBundleType = bundleType;
        this.myDisplayName = displayName;
        this.myBundlePath = path;
        this.myStartLevel = 1;
        this.myStartAfterInstallation = bundleType.autoStart;
    }

    public BundleType getBundleType() {
        return this.myBundleType;
    }

    public boolean isModule() {
        return this.myBundleType == BundleType.Module;
    }

    @NotNull
    public String getName() {
        String string = this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/run/ui/SelectedBundle", "getName"));
        }
        return string;
    }

    public void setName(@NotNull String displayName) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "org/osmorc/run/ui/SelectedBundle", "setName"));
        }
        this.myDisplayName = displayName;
    }

    @Nullable
    public String getBundlePath() {
        return this.myBundlePath;
    }

    public void setBundlePath(@Nullable String path) {
        this.myBundlePath = path;
    }

    public int getStartLevel() {
        return this.myStartLevel;
    }

    public boolean isDefaultStartLevel() {
        return this.myStartLevel == 0;
    }

    public void setStartLevel(int startLevel) {
        this.myStartLevel = startLevel;
    }

    public boolean isStartAfterInstallation() {
        return this.myStartAfterInstallation;
    }

    public void setStartAfterInstallation(boolean startAfterInstallation) {
        this.myStartAfterInstallation = startAfterInstallation;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof SelectedBundle) {
            SelectedBundle other = (SelectedBundle)o;
            return this.isModule() ? SelectedBundle.isEqual(this.myDisplayName, other.myDisplayName) : SelectedBundle.isEqual(this.myBundlePath, other.myBundlePath);
        }
        return false;
    }

    private static boolean isEqual(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o2 != null && o1.equals(o2) && o2.equals(o1);
    }

    public int hashCode() {
        return this.isModule() ? this.myDisplayName.hashCode() : (this.myBundlePath != null ? this.myBundlePath.hashCode() : 0);
    }

    public String toString() {
        return this.myDisplayName + (this.myBundlePath != null ? " (" + this.myBundlePath.substring(this.myBundlePath.lastIndexOf("/") + 1) + ")" : "");
    }

    public static enum BundleType {
        Module(true),
        FrameworkBundle(true),
        StartLibrary(true),
        PlainLibrary(false);

        public final boolean autoStart;

        private BundleType(boolean autoStart) {
            this.autoStart = autoStart;
        }
    }
}

