/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run.ui;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.impl.GenericRunProperties;
import org.osmorc.run.OsgiRunConfiguration;
import org.osmorc.run.ui.FrameworkRunPropertiesEditor;

public class GenericRunPropertiesEditor
implements FrameworkRunPropertiesEditor {
    private JPanel myMainPanel;
    private JTextField mySystemPackages;
    private JTextField myBootDelegation;
    private JCheckBox myDebugCheckbox;
    private JCheckBox myStartConsoleCheckbox;

    public GenericRunPropertiesEditor() {
        this.$$$setupUI$$$();
    }

    @Override
    public JPanel getUI() {
        return this.myMainPanel;
    }

    @Override
    public void resetEditorFrom(@NotNull OsgiRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "org/osmorc/run/ui/GenericRunPropertiesEditor", "resetEditorFrom"));
        }
        Map<String, String> properties = runConfiguration.getAdditionalProperties();
        this.mySystemPackages.setText(GenericRunProperties.getSystemPackages(properties));
        this.myBootDelegation.setText(GenericRunProperties.getBootDelegation(properties));
        this.myDebugCheckbox.setSelected(GenericRunProperties.isDebugMode(properties));
        this.myStartConsoleCheckbox.setSelected(GenericRunProperties.isStartConsole(properties));
    }

    @Override
    public void applyEditorTo(@NotNull OsgiRunConfiguration runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "org/osmorc/run/ui/GenericRunPropertiesEditor", "applyEditorTo"));
        }
        HashMap properties = ContainerUtil.newHashMap();
        GenericRunProperties.setSystemPackages(properties, this.mySystemPackages.getText());
        GenericRunProperties.setBootDelegation(properties, this.myBootDelegation.getText());
        GenericRunProperties.setDebugMode(properties, this.myDebugCheckbox.isSelected());
        GenericRunProperties.setStartConsole(properties, this.myStartConsoleCheckbox.isSelected());
        runConfiguration.putAdditionalProperties(properties);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("System Packages");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(107, 19), null));
        this.mySystemPackages = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, 19), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Boot Delegation");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBootDelegation = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myDebugCheckbox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(false);
        jCheckBox2.setText("Debug Mode");
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myStartConsoleCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        jCheckBox.setText("Start OSGi Console");
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

