/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.obrimport.springsource;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.osmorc.obrimport.MavenRepository;
import org.osmorc.obrimport.Obr;
import org.osmorc.obrimport.springsource.ObrMavenResult;

public class SpringSourceObr
implements Obr {
    private static final Pattern RESULT_PARSING_PATTERN = Pattern.compile("<a\\s+href=\"([^\"]+)\"[^>]*>([^<]+)");
    private static final Pattern GROUP_ID_PATTERN = Pattern.compile("&lt;groupId&gt;(.*?)&lt;/groupId&gt;");
    private static final Pattern ARTIFACT_ID_PATTERN = Pattern.compile("&lt;artifactId&gt;(.*?)&lt;/artifactId&gt;");
    private static final Pattern VERSION_PATTERN = Pattern.compile("&lt;version&gt;(.*?)&lt;/version&gt;");
    private static final Pattern CLASSIFIER_PATTERN = Pattern.compile("&lt;classifier&gt;(.*?)&lt;/classifier&gt;");
    private static final MavenRepository[] SPRINGSOURCE_REPOS = new MavenRepository[]{new MavenRepository("repository.springsource.com.release", "SpringSource OBR - Release", "http://repository.springsource.com/maven/bundles/release"), new MavenRepository("repository.springsource.com.external", "SpringSource OBR - External", "http://repository.springsource.com/maven/bundles/external")};

    @Override
    public String getDisplayName() {
        return "Springsource Enterprise Bundle Repository";
    }

    @Override
    public boolean supportsMaven() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ObrMavenResult[] queryForMavenArtifact(@NotNull String queryString, @NotNull ProgressIndicator indicator) throws IOException {
        ObrMavenResult[] obrMavenResultArray;
        block10: {
            if (queryString == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryString", "org/osmorc/obrimport/springsource/SpringSourceObr", "queryForMavenArtifact"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/osmorc/obrimport/springsource/SpringSourceObr", "queryForMavenArtifact"));
            }
            try {
                ArrayList<ObrMavenResult> result = new ArrayList<ObrMavenResult>();
                indicator.setText("Connecting to " + this.getDisplayName() + "...");
                String url = "http://www.springsource.com/repository/app/search?query=" + URLEncoder.encode(queryString, "utf-8");
                String contents = HttpRequests.request((String)url).readString(indicator);
                indicator.setText("Search completed. Getting results.");
                indicator.checkCanceled();
                int start = contents.indexOf("<div id=\"results-fragment\">");
                int end = contents.indexOf("</div>", start);
                contents = contents.substring(start, end);
                Matcher m = RESULT_PARSING_PATTERN.matcher(contents);
                while (m.find()) {
                    String detailUrl = m.group(1);
                    detailUrl = detailUrl.replaceAll(";jsessionid.*?\\?", "?");
                    detailUrl = detailUrl.replace("&amp;", "&");
                    String packageName = m.group(2);
                    indicator.setText("Loading details for result " + packageName + "...");
                    String detail = HttpRequests.request((String)("http://www.springsource.com" + detailUrl)).readString(indicator);
                    indicator.checkCanceled();
                    indicator.setText("Details retrieved. Getting detail information...");
                    String classifier = null;
                    Matcher groupMatcher = GROUP_ID_PATTERN.matcher(detail);
                    if (!groupMatcher.find()) continue;
                    String groupId = groupMatcher.group(1);
                    Matcher artifactMatcher = ARTIFACT_ID_PATTERN.matcher(detail);
                    if (!artifactMatcher.find()) continue;
                    String artifactId = artifactMatcher.group(1);
                    Matcher versionMatcher = VERSION_PATTERN.matcher(detail);
                    if (!versionMatcher.find()) continue;
                    String version = versionMatcher.group(1);
                    Matcher classifierMatcher = CLASSIFIER_PATTERN.matcher(detail);
                    if (classifierMatcher.find()) {
                        classifier = classifierMatcher.group(1);
                    }
                    result.add(new ObrMavenResult(groupId, artifactId, version, classifier, this));
                }
                indicator.setText("Done. " + result.size() + " artifacts found.");
                obrMavenResultArray = result.toArray(new ObrMavenResult[result.size()]);
                if (obrMavenResultArray != null) break block10;
            }
            catch (ProcessCanceledException ignored) {
                indicator.setText("Canceled.");
                ObrMavenResult[] obrMavenResultArray2 = new ObrMavenResult[]{};
                if (obrMavenResultArray2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/obrimport/springsource/SpringSourceObr", "queryForMavenArtifact"));
                }
                return obrMavenResultArray2;
            }
            finally {
                indicator.setIndeterminate(false);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/obrimport/springsource/SpringSourceObr", "queryForMavenArtifact"));
        }
        return obrMavenResultArray;
    }

    @Override
    @NotNull
    public MavenRepository[] getMavenRepositories() {
        if (SPRINGSOURCE_REPOS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/obrimport/springsource/SpringSourceObr", "getMavenRepositories"));
        }
        return SPRINGSOURCE_REPOS;
    }
}

