/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.maven.facet;

import com.intellij.facet.FacetType;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.FacetImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.osgi.jps.model.ManifestGenerationMode;
import org.jetbrains.osgi.jps.model.OutputPathType;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.facet.OsmorcFacetType;
import org.osmorc.maven.facet.ImporterUtil;

public class OsmorcFacetImporter
extends FacetImporter<OsmorcFacet, OsmorcFacetConfiguration, OsmorcFacetType> {
    private static final String INCLUDE_MANIFEST = "_include";

    public OsmorcFacetImporter() {
        super("org.apache.felix", "maven-bundle-plugin", (FacetType)OsmorcFacetType.getInstance());
    }

    public boolean isApplicable(MavenProject mavenProject) {
        return super.isApplicable(mavenProject) && "bundle".equals(mavenProject.getPackaging());
    }

    protected void setupFacet(OsmorcFacet osmorcFacet, MavenProject mavenProjectModel) {
    }

    protected void reimportFacet(IdeModifiableModelsProvider modelsProvider, Module module, MavenRootModelAdapter mavenRootModelAdapter, OsmorcFacet osmorcFacet, MavenProjectsTree mavenProjectsTree, MavenProject mavenProject, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectStringMap, List<MavenProjectsProcessorTask> mavenProjectsProcessorPostConfigurationTasks) {
        String docUrl;
        String vendor;
        String licenses;
        OsmorcFacetConfiguration conf = (OsmorcFacetConfiguration)osmorcFacet.getConfiguration();
        if (conf.isDoNotSynchronizeWithMaven()) {
            return;
        }
        MavenId id = mavenProject.getMavenId();
        conf.setBundleSymbolicName(id.getGroupId() + "." + id.getArtifactId());
        conf.setBundleVersion(ImporterUtil.cleanupVersion(id.getVersion()));
        MavenPlugin plugin = mavenProject.findPlugin(this.myPluginGroupID, this.myPluginArtifactID);
        if (plugin == null) {
            return;
        }
        conf.setBundleSymbolicName(this.computeSymbolicName(mavenProject));
        LinkedHashMap props = ContainerUtil.newLinkedHashMap();
        Map modelMap = mavenProject.getModelMap();
        String description = (String)modelMap.get("description");
        if (!StringUtil.isEmptyOrSpaces((String)description)) {
            props.put("Bundle-Description", description);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(licenses = (String)modelMap.get("licenses")))) {
            props.put("Bundle-License", licenses);
        }
        if (!StringUtil.isEmpty((String)(vendor = (String)modelMap.get("organization.name")))) {
            props.put("Bundle-Vendor", vendor);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(docUrl = (String)modelMap.get("organization.url")))) {
            props.put("Bundle-DocURL", docUrl);
        }
        Map<String, String> versions = OsmorcFacetImporter.cleanVersions(plugin);
        Element instructionsNode = this.getConfig(mavenProject, "instructions");
        if (instructionsNode != null) {
            boolean useExistingManifest = false;
            for (Element child : instructionsNode.getChildren()) {
                String name = child.getName();
                String value = child.getTextTrim();
                value = value.replaceAll("\\p{Blank}*[\r\n]\\p{Blank}*", "");
                value = OsmorcFacetImporter.substituteVersions(value, versions);
                if (INCLUDE_MANIFEST.equals(name)) {
                    conf.setManifestLocation(value);
                    conf.setManifestGenerationMode(ManifestGenerationMode.Manually);
                    conf.setUseProjectDefaultManifestFileLocation(false);
                    useExistingManifest = true;
                    continue;
                }
                if ("Bundle-Version".equals(name)) {
                    conf.setBundleVersion(value);
                    continue;
                }
                if ("Bundle-Activator".equals(name)) {
                    conf.setBundleActivator(value);
                    continue;
                }
                if (StringUtil.isEmpty((String)value) || "Bundle-SymbolicName".equals(name)) continue;
                if (StringUtil.startsWithChar((CharSequence)name, (char)'_')) {
                    name = "-" + name.substring(1);
                }
                props.put(name, value);
            }
            if (!useExistingManifest) {
                conf.setManifestLocation("");
                conf.setManifestGenerationMode(ManifestGenerationMode.OsmorcControlled);
                conf.setUseProjectDefaultManifestFileLocation(true);
            }
        }
        if (!props.containsKey("Bundle-Name")) {
            props.put("Bundle-Name", this.computeBundleName(mavenProject));
        }
        ImporterUtil.postProcessAdditionalProperties(props, mavenProject, module.getProject());
        conf.importAdditionalProperties(props, true);
        String jarFileName = mavenProject.getFinalName() + ".jar";
        switch (conf.getOutputPathType()) {
            case OsgiOutputPath: {
                conf.setJarFileLocation(jarFileName, OutputPathType.OsgiOutputPath);
                break;
            }
            case SpecificOutputPath: {
                String path = new File(conf.getJarFilePath(), jarFileName).getPath();
                conf.setJarFileLocation(path, OutputPathType.SpecificOutputPath);
                break;
            }
            default: {
                conf.setJarFileLocation(jarFileName, OutputPathType.CompilerOutputPath);
            }
        }
    }

    @NotNull
    private String computeBundleName(MavenProject mavenProject) {
        String bundleName = this.findConfigValue(mavenProject, "instructions.Bundle-Name");
        if (!StringUtil.isEmpty((String)bundleName)) {
            String string = bundleName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/maven/facet/OsmorcFacetImporter", "computeBundleName"));
            }
            return string;
        }
        String projectName = mavenProject.getName();
        if (!StringUtil.isEmpty((String)projectName)) {
            String string = projectName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/maven/facet/OsmorcFacetImporter", "computeBundleName"));
            }
            return string;
        }
        String artifactId = mavenProject.getMavenId().getArtifactId();
        if (!StringUtil.isEmpty((String)artifactId)) {
            String string = artifactId;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/maven/facet/OsmorcFacetImporter", "computeBundleName"));
            }
            return string;
        }
        String string = this.computeSymbolicName(mavenProject);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/maven/facet/OsmorcFacetImporter", "computeBundleName"));
        }
        return string;
    }

    @NotNull
    private String computeSymbolicName(MavenProject mavenProject) {
        String bundleSymbolicName = this.findConfigValue(mavenProject, "instructions.Bundle-SymbolicName");
        if (!StringUtil.isEmpty((String)bundleSymbolicName)) {
            String string = bundleSymbolicName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/maven/facet/OsmorcFacetImporter", "computeSymbolicName"));
            }
            return string;
        }
        MavenId mavenId = mavenProject.getMavenId();
        String groupId = mavenId.getGroupId();
        String artifactId = mavenId.getArtifactId();
        if (groupId == null || artifactId == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/maven/facet/OsmorcFacetImporter", "computeSymbolicName"));
            }
            return "";
        }
        String lastSectionOfGroupId = groupId.substring(groupId.lastIndexOf(".") + 1);
        if (lastSectionOfGroupId.endsWith(artifactId)) {
            String string = groupId;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/maven/facet/OsmorcFacetImporter", "computeSymbolicName"));
            }
            return string;
        }
        String doubledNamePart = lastSectionOfGroupId + "-";
        if (artifactId.startsWith(doubledNamePart) && artifactId.length() > doubledNamePart.length()) {
            String string = groupId + "." + artifactId.substring(doubledNamePart.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/maven/facet/OsmorcFacetImporter", "computeSymbolicName"));
            }
            return string;
        }
        String string = groupId + "." + artifactId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/maven/facet/OsmorcFacetImporter", "computeSymbolicName"));
        }
        return string;
    }

    @Nullable
    private static Map<String, String> cleanVersions(MavenPlugin plugin) {
        Element versionsNode = MavenJDOMUtil.findChildByPath((Element)plugin.getGoalConfiguration("cleanVersions"), (String)"versions");
        if (versionsNode == null) {
            return null;
        }
        HashMap versions = ContainerUtil.newHashMap();
        for (Element child : versionsNode.getChildren()) {
            String name = child.getName();
            String value = child.getValue();
            if (StringUtil.isEmpty((String)value)) continue;
            versions.put(name, ImporterUtil.cleanupVersion(value));
        }
        return versions;
    }

    @NotNull
    private static String substituteVersions(@NotNull String value, @Nullable Map<String, String> versions) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/osmorc/maven/facet/OsmorcFacetImporter", "substituteVersions"));
        }
        if (versions != null) {
            for (Map.Entry<String, String> entry : versions.entrySet()) {
                String property = "${" + entry.getKey() + "}";
                value = StringUtil.replace((String)value, (String)property, (String)entry.getValue());
            }
        }
        String string = value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/maven/facet/OsmorcFacetImporter", "substituteVersions"));
        }
        return string;
    }

    public void getSupportedDependencyTypes(Collection<String> result, SupportedRequestType type) {
        result.add("bundle");
    }
}

