/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.maven.facet;

import aQute.bnd.osgi.Analyzer;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.osmorc.maven.facet.AbstractDependencyFilter;
import org.osmorc.maven.facet.DependencyEmbedderException;
import org.osmorc.maven.facet.ImporterUtil;

public final class DependencyEmbedder
extends AbstractDependencyFilter {
    public static final String EMBED_DEPENDENCY = "Embed-Dependency";
    public static final String EMBED_DIRECTORY = "Embed-Directory";
    public static final String EMBED_STRIP_GROUP = "Embed-StripGroup";
    public static final String EMBED_STRIP_VERSION = "Embed-StripVersion";
    public static final String EMBED_TRANSITIVE = "Embed-Transitive";
    public static final String EMBEDDED_ARTIFACTS = "Embedded-Artifacts";
    public static final String MAVEN_DEPENDENCIES = "{maven-dependencies}";
    private String myEmbedDirectory;
    private String myEmbedStripGroup;
    private String myEmbedStripVersion;
    private final LinkedHashSet<String> myInlinePaths = new LinkedHashSet();
    private final Collection<MavenArtifact> myEmbeddedArtifacts = new LinkedHashSet<MavenArtifact>();

    public DependencyEmbedder(Collection<MavenArtifact> dependencyArtifacts) {
        super(dependencyArtifacts);
    }

    public void processHeaders(Analyzer analyzer) throws DependencyEmbedderException {
        StringBuilder includeResource = new StringBuilder();
        StringBuilder bundleClassPath = new StringBuilder();
        StringBuilder embeddedArtifacts = new StringBuilder();
        this.myInlinePaths.clear();
        this.myEmbeddedArtifacts.clear();
        String embedDependencyHeader = analyzer.getProperty(EMBED_DEPENDENCY);
        if (StringUtil.isNotEmpty((String)embedDependencyHeader)) {
            this.myEmbedDirectory = analyzer.getProperty(EMBED_DIRECTORY);
            this.myEmbedStripGroup = analyzer.getProperty(EMBED_STRIP_GROUP, "true");
            this.myEmbedStripVersion = analyzer.getProperty(EMBED_STRIP_VERSION);
            this.processInstructions(embedDependencyHeader);
            for (String inlinePath : this.myInlinePaths) {
                DependencyEmbedder.inlineDependency(inlinePath, includeResource);
            }
            for (MavenArtifact embeddedArtifact : this.myEmbeddedArtifacts) {
                this.embedDependency(embeddedArtifact, includeResource, bundleClassPath, embeddedArtifacts);
            }
        }
        if (analyzer.getProperty("-wab") == null && bundleClassPath.length() > 0 && analyzer.getProperty("Bundle-ClassPath") == null) {
            analyzer.setProperty("Bundle-ClassPath", ".");
        }
        DependencyEmbedder.appendDependencies(analyzer, "Include-Resource", includeResource.toString());
        DependencyEmbedder.appendDependencies(analyzer, "Bundle-ClassPath", bundleClassPath.toString());
        DependencyEmbedder.appendDependencies(analyzer, EMBEDDED_ARTIFACTS, embeddedArtifacts.toString());
    }

    @Override
    protected void processDependencies(Collection<MavenArtifact> dependencies, String inline) {
        if (null == inline || "false".equalsIgnoreCase(inline)) {
            this.myEmbeddedArtifacts.addAll(dependencies);
        } else {
            for (MavenArtifact dependency : dependencies) {
                DependencyEmbedder.addInlinePaths(dependency, inline, this.myInlinePaths);
            }
        }
    }

    private static void addInlinePaths(MavenArtifact dependency, String inline, Collection<String> inlinePaths) {
        File path = dependency.getFile();
        if (path.exists()) {
            if ("true".equalsIgnoreCase(inline) || inline.length() == 0) {
                inlinePaths.add(path.getPath());
            } else {
                String[] filters;
                for (String filter : filters = inline.split("\\|")) {
                    if (filter.length() <= 0) continue;
                    inlinePaths.add(path + "!/" + filter);
                }
            }
        }
    }

    private void embedDependency(MavenArtifact dependency, StringBuilder includeResource, StringBuilder bundleClassPath, StringBuilder embeddedArtifacts) {
        File sourceFile = dependency.getFile();
        if (sourceFile.exists()) {
            String extension;
            String embedDirectory = this.myEmbedDirectory;
            if (this.myEmbedDirectory == null || embedDirectory.isEmpty() || ".".equals(embedDirectory)) {
                embedDirectory = null;
            }
            if (!Boolean.valueOf(this.myEmbedStripGroup).booleanValue()) {
                embedDirectory = new File(embedDirectory, dependency.getGroupId()).getPath();
            }
            StringBuilder targetFileName = new StringBuilder();
            targetFileName.append(dependency.getArtifactId());
            if (!Boolean.valueOf(this.myEmbedStripVersion).booleanValue()) {
                targetFileName.append('-').append(dependency.getVersion());
                if (StringUtil.isNotEmpty((String)dependency.getClassifier())) {
                    targetFileName.append('-').append(dependency.getClassifier());
                }
            }
            if (StringUtil.isNotEmpty((String)(extension = dependency.getExtension()))) {
                targetFileName.append('.').append(extension);
            }
            File targetFile = new File(embedDirectory, targetFileName.toString());
            String targetFilePath = targetFile.getPath();
            if (File.separatorChar != '/') {
                targetFilePath = targetFilePath.replace(File.separatorChar, '/');
            }
            if (includeResource.length() > 0) {
                includeResource.append(',');
            }
            includeResource.append(targetFilePath);
            includeResource.append('=');
            includeResource.append(sourceFile);
            if (bundleClassPath.length() > 0) {
                bundleClassPath.append(',');
            }
            bundleClassPath.append(targetFilePath);
            if (embeddedArtifacts.length() > 0) {
                embeddedArtifacts.append(',');
            }
            embeddedArtifacts.append(targetFilePath).append(';');
            embeddedArtifacts.append("g=\"").append(dependency.getGroupId()).append('\"');
            embeddedArtifacts.append(";a=\"").append(dependency.getArtifactId()).append('\"');
            embeddedArtifacts.append(";v=\"").append(dependency.getVersion()).append('\"');
            if (StringUtil.isNotEmpty((String)dependency.getClassifier())) {
                embeddedArtifacts.append(";c=\"").append(dependency.getClassifier()).append('\"');
            }
        }
    }

    private static void inlineDependency(String path, StringBuilder includeResource) {
        if (includeResource.length() > 0) {
            includeResource.append(',');
        }
        includeResource.append('@');
        includeResource.append(path);
    }

    private static void appendDependencies(Analyzer analyzer, String directiveName, String mavenDependencies) {
        String instruction = analyzer.getProperty(directiveName);
        if (StringUtil.isNotEmpty((String)instruction)) {
            if (instruction.contains(MAVEN_DEPENDENCIES)) {
                if (mavenDependencies.length() == 0) {
                    String cleanInstruction = ImporterUtil.removeTagFromInstruction(instruction, MAVEN_DEPENDENCIES);
                    analyzer.setProperty(directiveName, cleanInstruction);
                } else {
                    String mergedInstruction = StringUtil.replace((String)instruction, (String)MAVEN_DEPENDENCIES, (String)mavenDependencies);
                    analyzer.setProperty(directiveName, mergedInstruction);
                }
            } else if (mavenDependencies.length() > 0) {
                if ("Include-Resource".equalsIgnoreCase(directiveName)) {
                    analyzer.setProperty(directiveName, mavenDependencies + ',' + instruction);
                } else {
                    analyzer.setProperty(directiveName, instruction + ',' + mavenDependencies);
                }
            }
        } else if (mavenDependencies.length() > 0) {
            analyzer.setProperty(directiveName, mavenDependencies);
        }
    }
}

