/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.lang.header;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.impl.StandardHeaderParser;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValue;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;
import org.osgi.framework.Version;

public class BundleVersionParser
extends StandardHeaderParser {
    public static final HeaderParser INSTANCE = new BundleVersionParser();

    private BundleVersionParser() {
    }

    public boolean annotate(@NotNull Header header, @NotNull AnnotationHolder holder) {
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "org/osmorc/manifest/lang/header/BundleVersionParser", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/osmorc/manifest/lang/header/BundleVersionParser", "annotate"));
        }
        HeaderValue value = header.getHeaderValue();
        if (value instanceof HeaderValuePart) {
            try {
                new Version(value.getUnwrappedText());
            }
            catch (IllegalArgumentException e) {
                TextRange range = ((HeaderValuePart)value).getHighlightingRange();
                holder.createErrorAnnotation(range, e.getMessage());
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Object getConvertedValue(@NotNull Header header) {
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "org/osmorc/manifest/lang/header/BundleVersionParser", "getConvertedValue"));
        }
        HeaderValue value = header.getHeaderValue();
        if (value instanceof HeaderValuePart) {
            try {
                return new Version(value.getUnwrappedText());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }
}

