/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.i18n.OsmorcBundle;

public abstract class AbstractOsgiQuickFix
implements LocalQuickFix {
    @NotNull
    public final String getFamilyName() {
        String string = OsmorcBundle.message("inspection.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/inspection/AbstractOsgiQuickFix", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    protected ManifestFile getVerifiedManifestFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/osmorc/inspection/AbstractOsgiQuickFix", "getVerifiedManifestFile"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        assert (module != null) : element;
        OsmorcFacet facet = OsmorcFacet.getInstance(module);
        if (facet != null) {
            OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)facet.getConfiguration();
            for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                PsiFile psiFile;
                VirtualFile file = root.findFileByRelativePath(configuration.getManifestLocation());
                if (file == null || !((psiFile = element.getManager().findFile(file)) instanceof ManifestFile) || !CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)psiFile)) continue;
                return (ManifestFile)psiFile;
            }
        }
        String message = OsmorcBundle.message("inspection.fix.no.manifest", new Object[0]);
        Notifications.Bus.notify((Notification)new Notification("osmorc", this.getFamilyName(), message, NotificationType.WARNING));
        return null;
    }
}

