/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.equinox;

import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.impl.DefaultOsgiRunConfigurationChecker;
import org.osmorc.frameworkintegration.impl.GenericRunProperties;
import org.osmorc.frameworkintegration.impl.equinox.EquinoxRunProperties;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.run.OsgiRunConfiguration;

public class EquinoxOsgiRunConfigurationChecker
extends DefaultOsgiRunConfigurationChecker {
    @Override
    protected void checkFrameworkSpecifics(@NotNull OsgiRunConfiguration runConfiguration) throws RuntimeConfigurationWarning {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "org/osmorc/frameworkintegration/impl/equinox/EquinoxOsgiRunConfigurationChecker", "checkFrameworkSpecifics"));
        }
        Map<String, String> properties = runConfiguration.getAdditionalProperties();
        String product = EquinoxRunProperties.getEquinoxProduct(properties);
        String application = EquinoxRunProperties.getEquinoxApplication(properties);
        if (!StringUtil.isEmptyOrSpaces((String)product) || !StringUtil.isEmptyOrSpaces((String)application)) {
            if (SystemInfo.isMac && !runConfiguration.getVmParameters().contains("-XstartOnFirstThread")) {
                throw new RuntimeConfigurationWarning(OsmorcBundle.message("run.configuration.equinox.jvm", new Object[0]));
            }
            if (GenericRunProperties.isStartConsole(properties)) {
                throw new RuntimeConfigurationWarning(OsmorcBundle.message("run.configuration.equinox.runningWithConsole", new Object[0]));
            }
        }
    }
}

