/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.equinox;

import com.intellij.util.text.VersionComparatorUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.frameworkintegration.impl.AbstractFrameworkInstanceManager;
import org.osmorc.run.ui.SelectedBundle;

public class EquinoxInstanceManager
extends AbstractFrameworkInstanceManager {
    private static final String[] BUNDLE_DIRS = new String[]{"plugins", "bundles"};
    private static final Pattern SYSTEM_BUNDLE = Pattern.compile("org.eclipse.osgi_.*\\.jar");
    private static final Pattern SHELL_BUNDLES = Pattern.compile(".*\\.gogo\\.(command|runtime|shell)_.*\\.jar");

    @Override
    @NotNull
    public Collection<SelectedBundle> getFrameworkBundles(@NotNull FrameworkInstanceDefinition instance, @NotNull FrameworkInstanceManager.FrameworkBundleType type) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "org/osmorc/frameworkintegration/impl/equinox/EquinoxInstanceManager", "getFrameworkBundles"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/osmorc/frameworkintegration/impl/equinox/EquinoxInstanceManager", "getFrameworkBundles"));
        }
        if (type == FrameworkInstanceManager.FrameworkBundleType.SHELL && VersionComparatorUtil.compare((String)instance.getVersion(), (String)"3.8") < 0) {
            Set<SelectedBundle> set = Collections.singleton(new SelectedBundle(SelectedBundle.BundleType.FrameworkBundle, "Equinox built-in console", null));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/frameworkintegration/impl/equinox/EquinoxInstanceManager", "getFrameworkBundles"));
            }
            return set;
        }
        Collection<SelectedBundle> collection = this.collectBundles(instance, type, BUNDLE_DIRS, SYSTEM_BUNDLE, "org.eclipse.core.runtime.adaptor.EclipseStarter", 1, SHELL_BUNDLES, null, 3);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/frameworkintegration/impl/equinox/EquinoxInstanceManager", "getFrameworkBundles"));
        }
        return collection;
    }
}

