/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.concierge;

import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.jps.build.CachingBundleInfoProvider;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.frameworkintegration.impl.AbstractFrameworkInstanceManager;
import org.osmorc.run.ui.SelectedBundle;

public class ConciergeInstanceManager
extends AbstractFrameworkInstanceManager {
    private static final String[] BUNDLE_DIRS = new String[]{"", "bundles"};
    private static final Pattern SYSTEM_BUNDLE = Pattern.compile("concierge.*\\.jar");
    private static final Pattern SHELL_BUNDLE = Pattern.compile("shell.*\\.jar");

    @Override
    @Nullable
    public String getVersion(@NotNull FrameworkInstanceDefinition instance) {
        String path;
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "org/osmorc/frameworkintegration/impl/concierge/ConciergeInstanceManager", "getVersion"));
        }
        Collection<SelectedBundle> bundles = this.getFrameworkBundles(instance, FrameworkInstanceManager.FrameworkBundleType.SYSTEM);
        if (bundles.size() == 1 && (path = bundles.iterator().next().getBundlePath()) != null) {
            return CachingBundleInfoProvider.getBundleAttribute((String)path, (String)"PproApp-Version");
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<SelectedBundle> getFrameworkBundles(@NotNull FrameworkInstanceDefinition instance, @NotNull FrameworkInstanceManager.FrameworkBundleType type) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "org/osmorc/frameworkintegration/impl/concierge/ConciergeInstanceManager", "getFrameworkBundles"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/osmorc/frameworkintegration/impl/concierge/ConciergeInstanceManager", "getFrameworkBundles"));
        }
        Collection<SelectedBundle> collection = this.collectBundles(instance, type, BUNDLE_DIRS, SYSTEM_BUNDLE, "ch.ethz.iks.concierge.framework.Framework", 1, SHELL_BUNDLE, null, 1);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/frameworkintegration/impl/concierge/ConciergeInstanceManager", "getFrameworkBundles"));
        }
        return collection;
    }
}

