/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.run.OsgiRunConfiguration;
import org.osmorc.run.OsgiRunConfigurationChecker;

public class DefaultOsgiRunConfigurationChecker
implements OsgiRunConfigurationChecker {
    @Override
    public final void checkConfiguration(@NotNull OsgiRunConfiguration runConfiguration) throws RuntimeConfigurationException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "org/osmorc/frameworkintegration/impl/DefaultOsgiRunConfigurationChecker", "checkConfiguration"));
        }
        if (!runConfiguration.isGenerateWorkingDir()) {
            if (StringUtil.isEmptyOrSpaces((String)runConfiguration.getWorkingDir())) {
                throw new RuntimeConfigurationError(OsmorcBundle.message("run.configuration.working.dir.set", new Object[0]));
            }
            File dir = new File(runConfiguration.getWorkingDir());
            if (!dir.isDirectory()) {
                if (!dir.mkdirs()) {
                    throw new RuntimeConfigurationError(OsmorcBundle.message("run.configuration.working.dir.create", new Object[0]));
                }
                FileUtil.delete((File)dir);
            }
        }
        this.checkFrameworkSpecifics(runConfiguration);
    }

    protected void checkFrameworkSpecifics(@NotNull OsgiRunConfiguration runConfiguration) throws RuntimeConfigurationException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "org/osmorc/frameworkintegration/impl/DefaultOsgiRunConfigurationChecker", "checkFrameworkSpecifics"));
        }
    }
}

