/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.Extensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkIntegrator;

public class FrameworkIntegratorRegistry {
    public static FrameworkIntegratorRegistry getInstance() {
        return (FrameworkIntegratorRegistry)ServiceManager.getService(FrameworkIntegratorRegistry.class);
    }

    @NotNull
    public FrameworkIntegrator[] getFrameworkIntegrators() {
        FrameworkIntegrator[] frameworkIntegratorArray = (FrameworkIntegrator[])Extensions.getExtensions(FrameworkIntegrator.EP_NAME);
        if (frameworkIntegratorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/frameworkintegration/FrameworkIntegratorRegistry", "getFrameworkIntegrators"));
        }
        return frameworkIntegratorArray;
    }

    @Nullable
    public FrameworkIntegrator findIntegratorByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/osmorc/frameworkintegration/FrameworkIntegratorRegistry", "findIntegratorByName"));
        }
        for (FrameworkIntegrator integrator : this.getFrameworkIntegrators()) {
            if (!name.equals(integrator.getDisplayName())) continue;
            return integrator;
        }
        return null;
    }

    @Nullable
    public FrameworkIntegrator findIntegratorByInstanceDefinition(@NotNull FrameworkInstanceDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "org/osmorc/frameworkintegration/FrameworkIntegratorRegistry", "findIntegratorByInstanceDefinition"));
        }
        return this.findIntegratorByName(definition.getFrameworkIntegratorName());
    }
}

