/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet;

import com.intellij.facet.FacetType;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestFileTypeFactory;
import org.jetbrains.osgi.jps.model.ManifestGenerationMode;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.facet.OsmorcFacetType;

public class OsmorcFrameworkDetector
extends FacetBasedFrameworkDetector<OsmorcFacet, OsmorcFacetConfiguration> {
    private final Logger logger = Logger.getInstance((String)"#org.osmorc.facet.OsmorcFrameworkDetector");
    private final String[] DETECTION_HEADERS = new String[]{"Bundle-SymbolicName"};

    public OsmorcFrameworkDetector() {
        super("osmorc");
    }

    @NotNull
    public FacetType<OsmorcFacet, OsmorcFacetConfiguration> getFacetType() {
        OsmorcFacetType osmorcFacetType = OsmorcFacetType.getInstance();
        if (osmorcFacetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/facet/OsmorcFrameworkDetector", "getFacetType"));
        }
        return osmorcFacetType;
    }

    protected OsmorcFacetConfiguration createConfiguration(Collection<VirtualFile> files) {
        OsmorcFacetConfiguration osmorcFacetConfiguration = (OsmorcFacetConfiguration)this.getFacetType().createDefaultConfiguration();
        osmorcFacetConfiguration.setManifestGenerationMode(ManifestGenerationMode.Manually);
        osmorcFacetConfiguration.setManifestLocation(((VirtualFile)ContainerUtil.getFirstItem(files)).getPath());
        osmorcFacetConfiguration.setUseProjectDefaultManifestFileLocation(false);
        return osmorcFacetConfiguration;
    }

    public void setupFacet(@NotNull OsmorcFacet facet, ModifiableRootModel model) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/osmorc/facet/OsmorcFrameworkDetector", "setupFacet"));
        }
        VirtualFile[] contentRoots = model.getContentRoots();
        OsmorcFacetConfiguration osmorcFacetConfiguration = (OsmorcFacetConfiguration)facet.getConfiguration();
        VirtualFile manifestFile = LocalFileSystem.getInstance().findFileByPath(osmorcFacetConfiguration.getManifestLocation());
        if (manifestFile != null) {
            for (VirtualFile contentRoot : contentRoots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)manifestFile, (boolean)false)) continue;
                osmorcFacetConfiguration.setManifestLocation(VfsUtilCore.getRelativePath((VirtualFile)manifestFile, (VirtualFile)contentRoot, (char)'/'));
                break;
            }
        } else {
            osmorcFacetConfiguration.setManifestLocation("");
            osmorcFacetConfiguration.setUseProjectDefaultManifestFileLocation(true);
        }
        String manifestFileName = osmorcFacetConfiguration.getManifestLocation();
        if (manifestFileName.endsWith("template.mf")) {
            osmorcFacetConfiguration.setManifestLocation("");
            osmorcFacetConfiguration.setBundlorFileLocation(manifestFileName);
            osmorcFacetConfiguration.setManifestGenerationMode(ManifestGenerationMode.Bundlor);
        }
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        ObjectPattern objectPattern = FileContentPattern.fileContent().with((PatternCondition)new PatternCondition<FileContent>("osmorc manifest file"){

            public boolean accepts(@NotNull FileContent content, ProcessingContext context) {
                if (content == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/osmorc/facet/OsmorcFrameworkDetector$1", "accepts"));
                }
                return OsmorcFrameworkDetector.this.isSuitableFile(content.getFile());
            }
        });
        if (objectPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/facet/OsmorcFrameworkDetector", "createSuitableFilePattern"));
        }
        return objectPattern;
    }

    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType = ManifestFileTypeFactory.MANIFEST;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/facet/OsmorcFrameworkDetector", "getFileType"));
        }
        return languageFileType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSuitableFile(VirtualFile file) {
        ArrayList<String> headersToDetect = new ArrayList<String>(Arrays.asList(this.DETECTION_HEADERS));
        if (file != null && file.exists() && !file.isDirectory()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getInputStream()));){
                String line;
                block5: while ((line = reader.readLine()) != null && headersToDetect.size() > 0) {
                    Iterator iterator = headersToDetect.iterator();
                    while (iterator.hasNext()) {
                        String headerToDetect = (String)iterator.next();
                        if (!line.startsWith(headerToDetect)) continue;
                        iterator.remove();
                        continue block5;
                    }
                }
            }
            catch (IOException e) {
                this.logger.warn("There was an unexpected exception when accessing " + file.getName() + " (" + e.getMessage() + ")");
                return false;
            }
        }
        return headersToDetect.size() == 0;
    }
}

