/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.bnd.run;

import aQute.bnd.build.ProjectLauncher;
import aQute.bnd.build.ProjectTester;
import aQute.bnd.build.Run;
import aQute.bnd.build.Workspace;
import aQute.bnd.service.EclipseJUnitTester;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.JavaTestLocator;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.bnd.run.BndLaunchUtil;
import org.jetbrains.osgi.bnd.run.BndRunConfigurationBase;
import org.osmorc.i18n.OsmorcBundle;

public class BndTestState
extends JavaCommandLineState {
    private static final String TEST_FRAMEWORK_NAME = "Bnd-OSGi-JUnit";
    private static final Logger LOG = Logger.getInstance(BndTestState.class);
    private final BndRunConfigurationBase.Test myConfiguration;
    private final ProjectTester myTester;
    private final ServerSocket mySocket;

    public BndTestState(@NotNull ExecutionEnvironment environment, @NotNull BndRunConfigurationBase.Test configuration) throws ExecutionException {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/osgi/bnd/run/BndTestState", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/osgi/bnd/run/BndTestState", "<init>"));
        }
        super(environment);
        this.myConfiguration = configuration;
        final File runFile = new File(this.myConfiguration.bndRunFile);
        if (!runFile.isFile()) {
            throw new CantRunException(OsmorcBundle.message("bnd.run.configuration.invalid", runFile));
        }
        try {
            String title = OsmorcBundle.message("bnd.run.configuration.progress", new Object[0]);
            this.myTester = (ProjectTester)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<ProjectTester, Exception>(this.myConfiguration.getProject(), title, false){

                protected ProjectTester compute(@NotNull ProgressIndicator indicator) throws Exception {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/osgi/bnd/run/BndTestState$1", "compute"));
                    }
                    indicator.setIndeterminate(true);
                    Run run = Workspace.getRun((File)runFile);
                    if (run == null) {
                        throw new IllegalStateException("Failed to locate Bnd workspace at " + runFile.getParentFile().getParent());
                    }
                    return run.getProjectTester();
                }
            });
        }
        catch (Throwable t) {
            LOG.info(t);
            throw new CantRunException(OsmorcBundle.message("bnd.run.configuration.cannot.run", runFile, BndLaunchUtil.message(t)));
        }
        if (!(this.myTester instanceof EclipseJUnitTester)) {
            throw new CantRunException(OsmorcBundle.message("bnd.test.runner.unsupported", this.myTester.getClass().getName()));
        }
        try {
            this.mySocket = new ServerSocket(0);
            ((EclipseJUnitTester)this.myTester).setPort(this.mySocket.getLocalPort());
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            throw new CantRunException(OsmorcBundle.message("bnd.test.cannot.run", e.getMessage()));
        }
        try {
            this.myTester.prepare();
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            throw new CantRunException(OsmorcBundle.message("bnd.run.configuration.cannot.run", runFile, e.getMessage()));
        }
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        ProjectLauncher launcher = this.myTester.getProjectLauncher();
        return BndLaunchUtil.createJavaParameters(this.myConfiguration, launcher);
    }

    @Nullable
    protected ConsoleView createConsole(@NotNull Executor executor) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/osgi/bnd/run/BndTestState", "createConsole"));
        }
        MyTestConsoleProperties consoleProperties = new MyTestConsoleProperties(this, executor);
        return SMTestRunnerConnectionUtil.createConsole((String)TEST_FRAMEWORK_NAME, (TestConsoleProperties)consoleProperties);
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        OSProcessHandler processHandler = super.startProcess();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                BndTestState.this.cleanup();
            }
        });
        OSProcessHandler oSProcessHandler = processHandler;
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/bnd/run/BndTestState", "startProcess"));
        }
        return oSProcessHandler;
    }

    private void cleanup() {
        try {
            this.mySocket.close();
            FileUtil.delete((File)this.myTester.getReportDir());
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static class MyProcessOutputConsumer
    extends OutputToGeneralTestEventsConverter {
        private final ServerSocket mySocket;
        private GeneralTestEventsProcessor myProcessor;
        private final Object myTestLock;
        private String myCurrentTest;
        private static final int EVENT_TYPE_LEN = 8;
        private int myTestCount;
        private String myCurrentSuite;
        private long myTestStarted;
        private String myReason;
        private String myFailingTest;
        private List<String> myTrace;

        public MyProcessOutputConsumer(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull ServerSocket socket) {
            if (testFrameworkName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "org/jetbrains/osgi/bnd/run/BndTestState$MyProcessOutputConsumer", "<init>"));
            }
            if (consoleProperties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleProperties", "org/jetbrains/osgi/bnd/run/BndTestState$MyProcessOutputConsumer", "<init>"));
            }
            if (socket == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "socket", "org/jetbrains/osgi/bnd/run/BndTestState$MyProcessOutputConsumer", "<init>"));
            }
            super(testFrameworkName, consoleProperties);
            this.myTestLock = new Object();
            this.myCurrentTest = null;
            this.myTestCount = 0;
            this.myCurrentSuite = null;
            this.myTestStarted = 0L;
            this.myReason = null;
            this.myFailingTest = null;
            this.myTrace = null;
            this.mySocket = socket;
        }

        public void setProcessor(GeneralTestEventsProcessor processor) {
            this.myProcessor = processor;
            this.startProtocolListener();
        }

        private void startProtocolListener() {
            new Thread("Bnd test state"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try (Socket socket = mySocket.accept();
                         BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            this.processEventLine(line);
                        }
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(String text, Key outputType) {
            GeneralTestEventsProcessor processor = this.myProcessor;
            Object object = this.myTestLock;
            synchronized (object) {
                if (this.myCurrentTest != null) {
                    processor.onTestOutput(new TestOutputEvent(this.myCurrentTest, text, outputType == ProcessOutputTypes.STDOUT));
                } else {
                    processor.onUncapturedOutput(text, outputType);
                }
            }
        }

        public void flushBufferBeforeTerminating() {
        }

        public void dispose() {
            this.myProcessor = null;
        }

        private void processEventLine(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/osgi/bnd/run/BndTestState$MyProcessOutputConsumer", "processEventLine"));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(">> " + line);
            }
            if (this.myTrace != null) {
                if ("%TRACEE ".equals(line)) {
                    this.processTrace();
                } else {
                    this.myTrace.add(line);
                }
                return;
            }
            if (line.length() >= 8 && line.charAt(0) == '%') {
                if (line.startsWith("%TESTC  ")) {
                    MyProcessOutputConsumer.processInit(line);
                } else if (line.startsWith("%TSTTREE")) {
                    this.processTreeLine(line);
                } else if (line.startsWith("%TESTS  ")) {
                    this.processTestStart(line);
                } else if (line.startsWith("%FAILED ")) {
                    this.myReason = "%FAILED ";
                    this.myFailingTest = line;
                } else if (line.startsWith("%ERROR  ")) {
                    this.myReason = "%ERROR  ";
                    this.myFailingTest = line;
                } else if ("%TRACES ".equals(line)) {
                    this.myTrace = ContainerUtil.newArrayListWithCapacity((int)20);
                } else if (line.startsWith("%TESTE  ")) {
                    this.processTestEnd(line);
                } else if (line.startsWith("%RUNTIME")) {
                    this.processDone();
                }
            }
        }

        private static void processInit(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/osgi/bnd/run/BndTestState$MyProcessOutputConsumer", "processInit"));
            }
            int p = line.indexOf(32, 8);
            if (p < 0 || !" v2".equals(line.substring(p))) {
                LOG.warn("unsupported protocol: " + line);
            }
        }

        private void processTreeLine(@NotNull String line) {
            Pair<String, String> names;
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/osgi/bnd/run/BndTestState$MyProcessOutputConsumer", "processTreeLine"));
            }
            List parts = StringUtil.split((String)line, (String)",");
            if (parts.size() == 4 && "false".equals(parts.get(2)) && (names = MyProcessOutputConsumer.parseTestName((String)parts.get(1), true)) != null) {
                ++this.myTestCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTestStart(@NotNull String line) {
            String suite;
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/osgi/bnd/run/BndTestState$MyProcessOutputConsumer", "processTestStart"));
            }
            this.myTestStarted = System.currentTimeMillis();
            Pair<String, String> names = MyProcessOutputConsumer.parseTestName(line, false);
            String testName = MyProcessOutputConsumer.fullTestName(names, line);
            if (this.myTestCount > 0) {
                this.myProcessor.onTestsCountInSuite(this.myTestCount);
                this.myTestCount = -1;
            }
            if (names != null && !(suite = (String)names.first).equals(this.myCurrentSuite)) {
                if (this.myCurrentSuite != null) {
                    this.myProcessor.onSuiteFinished(new TestSuiteFinishedEvent(this.myCurrentSuite));
                }
                this.myProcessor.onSuiteStarted(new TestSuiteStartedEvent(suite, "java:suite://" + suite));
                this.myCurrentSuite = suite;
            }
            GeneralTestEventsProcessor processor = this.myProcessor;
            Object object = this.myTestLock;
            synchronized (object) {
                this.myCurrentTest = testName;
                processor.onTestStarted(new TestStartedEvent(testName, "java:test://" + testName));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTestEnd(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/osgi/bnd/run/BndTestState$MyProcessOutputConsumer", "processTestEnd"));
            }
            long t = System.currentTimeMillis() - this.myTestStarted;
            String testName = MyProcessOutputConsumer.fullTestName(MyProcessOutputConsumer.parseTestName(line, false), line);
            GeneralTestEventsProcessor processor = this.myProcessor;
            Object object = this.myTestLock;
            synchronized (object) {
                processor.onTestFinished(new TestFinishedEvent(testName, t));
                this.myCurrentTest = null;
            }
        }

        private void processTrace() {
            if (this.myTrace != null) {
                StringBuilder header = new StringBuilder();
                StringBuilder stack = new StringBuilder();
                boolean inStack = false;
                for (String line : this.myTrace) {
                    if (!inStack && line.startsWith("\tat ")) {
                        inStack = true;
                    }
                    (inStack ? stack : header).append(line).append('\n');
                }
                Pair<String, String> pair = null;
                String message = header.toString();
                if ((message.startsWith("org.junit.") || message.startsWith("junit.framework.")) && (pair = MyProcessOutputConsumer.matchComparison(message)) != null) {
                    this.myReason = "%FAILED ";
                }
                if (this.myFailingTest != null) {
                    String testName = MyProcessOutputConsumer.fullTestName(MyProcessOutputConsumer.parseTestName(this.myFailingTest, false), this.myFailingTest);
                    boolean testError = this.myReason != "%FAILED ";
                    String expected = pair != null ? (String)pair.first : null;
                    String actual = pair != null ? (String)pair.second : null;
                    this.myProcessor.onTestFailure(new TestFailedEvent(testName, message, stack.toString(), testError, actual, expected));
                } else {
                    this.myProcessor.onError(message, stack.toString(), false);
                }
            }
            this.myTrace = null;
            this.myReason = null;
        }

        private void processDone() {
            if (this.myCurrentSuite != null) {
                this.myProcessor.onSuiteFinished(new TestSuiteFinishedEvent(this.myCurrentSuite));
                this.myCurrentSuite = null;
            }
        }

        @Nullable
        private static Pair<String, String> parseTestName(@NotNull String line, boolean fromStart) {
            int paren;
            int comma;
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/osgi/bnd/run/BndTestState$MyProcessOutputConsumer", "parseTestName"));
            }
            int n = comma = fromStart ? 0 : line.indexOf(44, 8);
            if (comma >= 0 && (paren = line.indexOf(40, comma + 1)) > 0 && paren < line.length() - 1) {
                String test = line.substring(comma + 1, paren);
                String suite = line.substring(paren + 1, line.length() - 1);
                return Pair.pair((Object)suite, (Object)test);
            }
            return null;
        }

        @NotNull
        private static String fullTestName(@Nullable Pair<String, String> names, @NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/osgi/bnd/run/BndTestState$MyProcessOutputConsumer", "fullTestName"));
            }
            String string = names != null ? (String)names.first + '.' + (String)names.second : line.substring(8);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/bnd/run/BndTestState$MyProcessOutputConsumer", "fullTestName"));
            }
            return string;
        }

        @Nullable
        private static Pair<String, String> matchComparison(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/osgi/bnd/run/BndTestState$MyProcessOutputConsumer", "matchComparison"));
            }
            for (Pattern pattern : Comparisons.PATTERNS) {
                Matcher matcher = pattern.matcher(message);
                if (!matcher.find()) continue;
                return Pair.pair((Object)matcher.group(1).replaceAll("\\\\n", "\n"), (Object)matcher.group(2).replaceAll("\\\\n", "\n"));
            }
            return null;
        }

        private static final class Comparisons {
            private static final List<Pattern> PATTERNS = ContainerUtil.newArrayList((Object[])new Pattern[]{Comparisons.compile("\nExpected: is \"(.*)\"\n\\s*got: \"(.*)\"\n"), Comparisons.compile("\nExpected: is \"(.*)\"\n\\s*but: was \"(.*)\""), Comparisons.compile("\nExpected: (.*)\n\\s*got: (.*)"), Comparisons.compile(".*?\\s*expected same:<(.*)> was not:<(.*)>"), Comparisons.compile(".*?\\s*expected:<(.*?)> but was:<(.*?)>"), Comparisons.compile("\nExpected: \"(.*)\"\n\\s*but: was \"(.*)\""), Comparisons.compile("\\s*Expected: (.*)\\s*but: was (.*)")});

            private Comparisons() {
            }

            private static Pattern compile(String regex) {
                return Pattern.compile(regex, 34);
            }
        }

        private static final class Proto {
            private static final String INIT = "%TESTC  ";
            private static final String TREE = "%TSTTREE";
            private static final String TEST = "%TESTS  ";
            private static final String ERROR = "%ERROR  ";
            private static final String FAILED = "%FAILED ";
            private static final String TRACE = "%TRACES ";
            private static final String TRACE_END = "%TRACEE ";
            private static final String TEST_END = "%TESTE  ";
            private static final String DONE = "%RUNTIME";

            private Proto() {
            }
        }
    }

    private static class MyTestConsoleProperties
    extends SMTRunnerConsoleProperties
    implements SMCustomMessagesParsing {
        private final ServerSocket mySocket;

        public MyTestConsoleProperties(@NotNull BndTestState runProfile, @NotNull Executor executor) {
            if (runProfile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runProfile", "org/jetbrains/osgi/bnd/run/BndTestState$MyTestConsoleProperties", "<init>"));
            }
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/osgi/bnd/run/BndTestState$MyTestConsoleProperties", "<init>"));
            }
            super((RunConfiguration)runProfile.myConfiguration, BndTestState.TEST_FRAMEWORK_NAME, executor);
            this.mySocket = runProfile.mySocket;
            this.setPrintTestingStartedTime(false);
        }

        @NotNull
        public OutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
            if (testFrameworkName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "org/jetbrains/osgi/bnd/run/BndTestState$MyTestConsoleProperties", "createTestEventsConverter"));
            }
            if (consoleProperties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleProperties", "org/jetbrains/osgi/bnd/run/BndTestState$MyTestConsoleProperties", "createTestEventsConverter"));
            }
            MyProcessOutputConsumer myProcessOutputConsumer = new MyProcessOutputConsumer(testFrameworkName, consoleProperties, this.mySocket);
            if (myProcessOutputConsumer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/bnd/run/BndTestState$MyTestConsoleProperties", "createTestEventsConverter"));
            }
            return myProcessOutputConsumer;
        }

        public SMTestLocator getTestLocator() {
            return JavaTestLocator.INSTANCE;
        }
    }
}

