/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.bnd.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.bnd.run.BndLaunchState;
import org.jetbrains.osgi.bnd.run.BndRunConfigurationEditor;
import org.jetbrains.osgi.bnd.run.BndTestState;
import org.osmorc.i18n.OsmorcBundle;

public abstract class BndRunConfigurationBase
extends LocatableConfigurationBase
implements ModuleRunProfile {
    public String bndRunFile;
    public boolean useAlternativeJre;
    public String alternativeJrePath;

    public BndRunConfigurationBase(Project project, @NotNull ConfigurationFactory factory, String name) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/osgi/bnd/run/BndRunConfigurationBase", "<init>"));
        }
        super(project, factory, name);
        this.bndRunFile = "";
        this.useAlternativeJre = false;
        this.alternativeJrePath = "";
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)((Object)this), (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        RunConfiguration template = this.getFactory().createTemplateConfiguration(this.getProject());
        XmlSerializer.serializeInto((Object)((Object)this), (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters(new Object[]{template}));
    }

    protected boolean isNewSerializationUsed() {
        return true;
    }

    @NotNull
    public SettingsEditor<? extends BndRunConfigurationBase> getConfigurationEditor() {
        BndRunConfigurationEditor bndRunConfigurationEditor = new BndRunConfigurationEditor(this.getProject());
        if (bndRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/bnd/run/BndRunConfigurationBase", "getConfigurationEditor"));
        }
        return bndRunConfigurationEditor;
    }

    @Nullable
    public abstract RunProfileState getState(@NotNull Executor var1, @NotNull ExecutionEnvironment var2) throws ExecutionException;

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (!new File(this.bndRunFile).isFile()) {
            throw new RuntimeConfigurationException(OsmorcBundle.message("bnd.run.configuration.invalid", this.bndRunFile));
        }
        if (this.useAlternativeJre) {
            JavaParametersUtil.checkAlternativeJRE((String)this.alternativeJrePath);
        }
    }

    @NotNull
    public Module[] getModules() {
        if (Module.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/bnd/run/BndRunConfigurationBase", "getModules"));
        }
        return Module.EMPTY_ARRAY;
    }

    public static class Test
    extends BndRunConfigurationBase {
        public Test(Project project, @NotNull ConfigurationFactory factory, String name) {
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/osgi/bnd/run/BndRunConfigurationBase$Test", "<init>"));
            }
            super(project, factory, name);
        }

        @Nullable
        public BndTestState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/osgi/bnd/run/BndRunConfigurationBase$Test", "getState"));
            }
            if (environment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/osgi/bnd/run/BndRunConfigurationBase$Test", "getState"));
            }
            return new BndTestState(environment, this);
        }
    }

    public static class Launch
    extends BndRunConfigurationBase {
        public Launch(Project project, @NotNull ConfigurationFactory factory, String name) {
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/osgi/bnd/run/BndRunConfigurationBase$Launch", "<init>"));
            }
            super(project, factory, name);
        }

        @Nullable
        public BndLaunchState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/osgi/bnd/run/BndRunConfigurationBase$Launch", "getState"));
            }
            if (environment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/osgi/bnd/run/BndRunConfigurationBase$Launch", "getState"));
            }
            return new BndLaunchState(environment, this);
        }
    }
}

