/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.openapi.util.Comparing;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.CallFrameBaseKt;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Variable;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.wip.WipEvaluateContextBase;
import org.jetbrains.wip.WipSuspendContextManagerKt;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.protocol.WipRequest;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.EvaluateOnCallFrameResult;
import org.jetbrains.wip.protocol.debugger.ScopeValue;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001DB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010C\u001a\u00020\tH\u0016R\"\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0016\u0010#\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0013R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R(\u0010*\u001a\u0004\u0018\u00010\t2\b\u0010)\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0013\"\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010(R\u0014\u0010/\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0017R\u001c\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u000103028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R0\u00107\u001a\b\u0012\u0004\u0012\u0002060\f2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002060\f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u000f\"\u0004\b9\u0010\u0011R(\u0010:\u001a\u0004\u0018\u00010\t2\b\u0010)\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\u0013\"\u0004\b<\u0010-R\u0010\u0010=\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010>\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u000f\u00a8\u0006E"}, d2={"Lorg/jetbrains/wip/WipCallFrame;", "Lorg/jetbrains/debugger/CallFrame;", "valueManager", "Lorg/jetbrains/wip/WipValueManager;", "cf", "Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;", "(Lorg/jetbrains/wip/WipValueManager;Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;)V", "Lorg/jetbrains/wip/protocol/runtime/CallFrameValue;", "asyncFunctionName", "", "(Lorg/jetbrains/wip/WipValueManager;Lorg/jetbrains/wip/protocol/runtime/CallFrameValue;Ljava/lang/String;)V", "_variableScopes", "", "Lorg/jetbrains/debugger/Scope;", "get_variableScopes", "()Ljava/util/List;", "set_variableScopes", "(Ljava/util/List;)V", "getAsyncFunctionName", "()Ljava/lang/String;", "column", "", "getColumn", "()I", "equalityObject", "", "getEqualityObject", "()Ljava/lang/Object;", "evaluateContext", "Lorg/jetbrains/wip/WipEvaluateContextBase;", "Lorg/jetbrains/wip/protocol/debugger/EvaluateOnCallFrameResult;", "getEvaluateContext", "()Lorg/jetbrains/wip/WipEvaluateContextBase;", "setEvaluateContext", "(Lorg/jetbrains/wip/WipEvaluateContextBase;)V", "functionName", "getFunctionName", "hasOnlyGlobalScope", "", "getHasOnlyGlobalScope", "()Z", "<set-?>", "id", "getId", "setId", "(Ljava/lang/String;)V", "isFromAsyncStack", "line", "getLine", "receiverVariable", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/Variable;", "getReceiverVariable", "()Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/wip/protocol/debugger/ScopeValue;", "scopesData", "getScopesData", "setScopesData", "scriptId", "getScriptId", "setScriptId", "thisObject", "variableScopes", "getVariableScopes", "reinit", "", "frameData", "toString", "WipCallFrameEvaluateContext", "wip-backend"})
public final class WipCallFrame
implements CallFrame {
    private final WipValueManager valueManager;
    private final int line;
    private final int column;
    @Nullable
    private final String functionName;
    @Nullable
    private final String asyncFunctionName;
    private final boolean isFromAsyncStack;
    @NotNull
    private WipEvaluateContextBase<EvaluateOnCallFrameResult> evaluateContext;
    @Nullable
    private String id;
    private Variable thisObject;
    @Nullable
    private String scriptId;
    @NotNull
    private List<? extends ScopeValue> scopesData;
    @Nullable
    private List<? extends Scope> _variableScopes;

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    @Nullable
    public String getFunctionName() {
        return this.functionName;
    }

    @Nullable
    public String getAsyncFunctionName() {
        return this.asyncFunctionName;
    }

    public boolean isFromAsyncStack() {
        return this.isFromAsyncStack;
    }

    @NotNull
    public WipEvaluateContextBase<EvaluateOnCallFrameResult> getEvaluateContext() {
        return this.evaluateContext;
    }

    public void setEvaluateContext(@NotNull WipEvaluateContextBase<EvaluateOnCallFrameResult> wipEvaluateContextBase) {
        Intrinsics.checkParameterIsNotNull(wipEvaluateContextBase, (String)"<set-?>");
        this.evaluateContext = wipEvaluateContextBase;
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    private final void setId(String string) {
        this.id = string;
    }

    @Nullable
    public final String getScriptId() {
        return this.scriptId;
    }

    private final void setScriptId(String string) {
        this.scriptId = string;
    }

    @NotNull
    public final List<ScopeValue> getScopesData() {
        return this.scopesData;
    }

    private final void setScopesData(List<? extends ScopeValue> list) {
        this.scopesData = list;
    }

    @NotNull
    public Promise<Variable> getReceiverVariable() {
        return Promises.resolvedPromise((Object)this.thisObject);
    }

    @NotNull
    public Object getEqualityObject() {
        return this.scriptId + "#" + this.getFunctionName();
    }

    public boolean getHasOnlyGlobalScope() {
        return this.scopesData.size() == 1 && Intrinsics.areEqual((Object)((Object)((ScopeValue)CollectionsKt.first(this.scopesData)).type()), (Object)((Object)ScopeValue.Type.GLOBAL));
    }

    @Nullable
    public final List<Scope> get_variableScopes() {
        return this._variableScopes;
    }

    public final void set_variableScopes(@Nullable List<? extends Scope> list) {
        this._variableScopes = list;
    }

    @NotNull
    public List<Scope> getVariableScopes() {
        if (this._variableScopes == null) {
            this._variableScopes = ArraysKt.asList((Object[])WipSuspendContextManagerKt.createScopes(this.scopesData, this.id, null, this.valueManager));
        }
        List<Scope> list = this._variableScopes;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list;
    }

    public final void reinit(@NotNull org.jetbrains.wip.protocol.debugger.CallFrameValue frameData, @NotNull WipValueManager valueManager) {
        Intrinsics.checkParameterIsNotNull((Object)frameData, (String)"frameData");
        Intrinsics.checkParameterIsNotNull((Object)((Object)valueManager), (String)"valueManager");
        CommandProcessorKt.getLOG().assertTrue(Comparing.strEqual((String)frameData.functionName(), (String)this.getFunctionName()));
        CommandProcessorKt.getLOG().assertTrue(this.getLine() == frameData.location().getLineNumber());
        this.scopesData = frameData.scopeChain();
        this._variableScopes = null;
        this.id = frameData.callFrameId();
        this.scriptId = frameData.location().scriptId();
        RemoteObjectValue thisObjectData = frameData.getThis();
        this.thisObject = (Variable)valueManager.createVariable(CallFrameBaseKt.RECEIVER_NAME, thisObjectData, null);
    }

    @NotNull
    public String toString() {
        return this.scriptId + " " + this.getFunctionName() + " " + this.getLine() + ":" + this.getColumn();
    }

    public WipCallFrame(@NotNull WipValueManager valueManager, @NotNull org.jetbrains.wip.protocol.debugger.CallFrameValue cf) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)valueManager), (String)"valueManager");
        Intrinsics.checkParameterIsNotNull((Object)cf, (String)"cf");
        this.scopesData = CollectionsKt.emptyList();
        this.valueManager = valueManager;
        this.setEvaluateContext(new WipCallFrameEvaluateContext(valueManager));
        this.line = cf.location().getLineNumber();
        this.column = cf.location().getColumnNumber();
        this.functionName = cf.functionName();
        this.asyncFunctionName = null;
        this.isFromAsyncStack = false;
        this.reinit(cf, valueManager);
    }

    public WipCallFrame(@NotNull WipValueManager valueManager, @NotNull CallFrameValue cf, @Nullable String asyncFunctionName) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)valueManager), (String)"valueManager");
        Intrinsics.checkParameterIsNotNull((Object)cf, (String)"cf");
        this.scopesData = CollectionsKt.emptyList();
        this.valueManager = valueManager;
        this.setEvaluateContext(new WipCallFrameEvaluateContext(valueManager));
        this.line = cf.getLineNumber();
        this.column = cf.getColumnNumber();
        this.functionName = cf.functionName();
        this.asyncFunctionName = asyncFunctionName;
        this.isFromAsyncStack = true;
        this.scriptId = cf.scriptId();
    }

    @Nullable
    public static final /* synthetic */ String access$getId$p(WipCallFrame $this) {
        return $this.id;
    }

    public static final /* synthetic */ void access$setId$p(WipCallFrame $this, @Nullable String string) {
        $this.id = string;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0014\u0010\u000f\u001a\u00060\u0000R\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/wip/WipCallFrame$WipCallFrameEvaluateContext;", "Lorg/jetbrains/wip/WipEvaluateContextBase;", "Lorg/jetbrains/wip/protocol/debugger/EvaluateOnCallFrameResult;", "valueManager", "Lorg/jetbrains/wip/WipValueManager;", "(Lorg/jetbrains/wip/WipCallFrame;Lorg/jetbrains/wip/WipValueManager;)V", "createRequest", "Lorg/jetbrains/wip/protocol/WipRequest;", "expression", "", "getRemoteObjectValue", "Lorg/jetbrains/wip/protocol/runtime/RemoteObjectValue;", "data", "getWasThrown", "", "withValueManager", "Lorg/jetbrains/wip/WipCallFrame;", "objectGroup", "wip-backend"})
    private final class WipCallFrameEvaluateContext
    extends WipEvaluateContextBase<EvaluateOnCallFrameResult> {
        @Override
        @NotNull
        public WipRequest<EvaluateOnCallFrameResult> createRequest(@NotNull String expression, @NotNull WipValueManager valueManager) {
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)((Object)valueManager), (String)"valueManager");
            String string = WipCallFrame.this.getId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return DebuggerKt.EvaluateOnCallFrame$default(string, expression, valueManager.getObjectGroupId$wip_backend(), false, false, false, false, 120, null);
        }

        @Override
        @NotNull
        protected RemoteObjectValue getRemoteObjectValue(@NotNull EvaluateOnCallFrameResult data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return data.result();
        }

        @Override
        protected boolean getWasThrown(@NotNull EvaluateOnCallFrameResult data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return data.getWasThrown();
        }

        @NotNull
        public WipCallFrameEvaluateContext withValueManager(@NotNull String objectGroup) {
            Intrinsics.checkParameterIsNotNull((Object)objectGroup, (String)"objectGroup");
            return new WipCallFrameEvaluateContext(new WipValueManager(((WipValueManager)this.getValueManager()).getVm(), objectGroup, null, 4, null));
        }

        public WipCallFrameEvaluateContext(WipValueManager valueManager) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)valueManager), (String)"valueManager");
            super(valueManager);
        }
    }
}

