/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip.extension;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.jetbrains.browserConnection.BrowserConnectionManager;
import com.jetbrains.browserConnection.WebBrowserConnectorBundle;
import com.jetbrains.debugger.wip.ChromeExtensionUtil;
import com.jetbrains.debugger.wip.WipVmBootstrap;
import com.jetbrains.debugger.wip.extension.DebuggerServiceKt;
import com.jetbrains.debugger.wip.extension.ExtBackedChromeConnection;
import com.jetbrains.debugger.wip.extension.JbWipVm;
import com.jetbrains.debugger.wip.extension.RemoteDebugger;
import javax.swing.Icon;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientListener;
import org.jetbrains.io.jsonRpc.ClientListenerAdapter;
import org.jetbrains.io.jsonRpc.JsonRpcServer;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\nJ\n\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0002J\u001e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/debugger/wip/extension/ExtBackedChromeConnection;", "Lorg/jetbrains/debugger/connection/VmConnection;", "Lcom/jetbrains/debugger/wip/extension/JbWipVm;", "Lcom/intellij/openapi/Disposable;", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "(Lcom/intellij/ide/browsers/WebBrowser;)V", "getBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "connect", "", "browserConnection", "Lorg/jetbrains/io/jsonRpc/Client;", "tabId", "", "url", "Lcom/intellij/util/Url;", "usePreliminaryPage", "", "externallyDetached", "getJbVm", "open", "project", "Lcom/intellij/openapi/project/Project;", "ChromeConnector"})
public final class ExtBackedChromeConnection
extends VmConnection<JbWipVm>
implements Disposable {
    @NotNull
    private final WebBrowser browser;

    private final JbWipVm getJbVm() {
        return (JbWipVm)this.getVm();
    }

    public final void open(@NotNull Url url, @NotNull Project project, boolean usePreliminaryPage) {
        Object errorBalloonShown;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        int builtInServerPort = BuiltInServerManager.getInstance().getPort();
        this.setState(ConnectionStatus.WAITING_FOR_CONNECTION, WebBrowserConnectorBundle.message((String)"chrome.waiting.for.connection", (Object[])new Object[]{this.getBrowser().getName(), builtInServerPort}), (HyperlinkListener)((Object)new ChromeExtensionUtil.ExtLinkListener(this.getBrowser(), project)));
        BrowserConnectionManager.getInstance().addWebSocketServerListener((ClientListener)new ClientListenerAdapter(this){
            final /* synthetic */ ExtBackedChromeConnection this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void disconnected(@NotNull Client client) {
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
                    JbWipVm jbWipVm = ExtBackedChromeConnection.access$getJbVm(this.this$0);
                    if (jbWipVm == null) break block4;
                    JbWipVm jbWipVm2 = jbWipVm;
                    JbWipVm it = jbWipVm2;
                    if (Intrinsics.areEqual((Object)it.getRemoteDebugger().getClient(), (Object)client)) {
                        try {
                            it.clientDisconnected();
                        }
                        finally {
                            this.this$0.close(ConnectionStatus.DISCONNECTED.getStatusText() + " (browser disconnected)", ConnectionStatus.DISCONNECTED);
                        }
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        }, (Disposable)this);
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Alarm errorBalloonAlarm = new Alarm((Disposable)this);
        errorBalloonAlarm.addRequest(new Runnable(this, errorBalloonShown, project, builtInServerPort){
            final /* synthetic */ ExtBackedChromeConnection this$0;
            final /* synthetic */ Ref.BooleanRef $errorBalloonShown;
            final /* synthetic */ Project $project;
            final /* synthetic */ int $builtInServerPort;

            public final void run() {
                this.$errorBalloonShown.element = true;
                ToolWindowManager.getInstance((Project)this.$project).notifyByBalloon(ToolWindowId.DEBUG, MessageType.ERROR, WebBrowserConnectorBundle.message((String)"chrome.balloon.waiting.for.connection", (Object[])new Object[]{this.this$0.getBrowser().getName(), this.$builtInServerPort}), (Icon)null, (HyperlinkListener)((Object)new ChromeExtensionUtil.ExtLinkListener(this.this$0.getBrowser(), this.$project)));
            }
            {
                this.this$0 = extBackedChromeConnection;
                this.$errorBalloonShown = booleanRef;
                this.$project = project;
                this.$builtInServerPort = n;
            }
        }, 10000, ModalityState.NON_MODAL);
        BrowserConnectionManager.getInstance().getConnectedBrowser(this.getBrowser(), (Disposable)this).done((Consumer)new Consumer<Client>(this, url, usePreliminaryPage, project, errorBalloonAlarm, errorBalloonShown){
            final /* synthetic */ ExtBackedChromeConnection this$0;
            final /* synthetic */ Url $url;
            final /* synthetic */ boolean $usePreliminaryPage;
            final /* synthetic */ Project $project;
            final /* synthetic */ Alarm $errorBalloonAlarm;
            final /* synthetic */ Ref.BooleanRef $errorBalloonShown;

            public final void consume(Client browserConnection) {
                BrowserConnectionManager.getInstance().attachInspector(browserConnection, (CharSequence)this.$url.toExternalForm(), this.$usePreliminaryPage).done((Consumer)new Consumer<Double>(this, browserConnection){
                    final /* synthetic */ open.3 this$0;
                    final /* synthetic */ Client $browserConnection;

                    public final void consume(Double it) {
                        ExtBackedChromeConnection extBackedChromeConnection = this.this$0.this$0;
                        Client client = this.$browserConnection;
                        Intrinsics.checkExpressionValueIsNotNull((Object)client, (String)"browserConnection");
                        extBackedChromeConnection.connect(client, (int)((Number)it).doubleValue(), this.this$0.$url, this.this$0.$usePreliminaryPage);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$browserConnection = client;
                    }
                }).rejected((Consumer)new Consumer<Throwable>(this){
                    final /* synthetic */ open.3 this$0;

                    public final void consume(Throwable it) {
                        ExtBackedChromeConnection.access$setState(this.this$0.this$0, ConnectionStatus.CONNECTION_FAILED, WebBrowserConnectorBundle.message((String)"chrome.cannot.connect", (Object[])new Object[0]), (HyperlinkListener)((Object)new ChromeExtensionUtil.ExtLinkListener(this.this$0.this$0.getBrowser(), this.this$0.$project)));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).processed((Consumer)new Consumer<Double>(this){
                    final /* synthetic */ open.3 this$0;

                    public final void consume(Double it) {
                        Disposer.dispose((Disposable)((Disposable)this.this$0.$errorBalloonAlarm));
                        if (this.this$0.$errorBalloonShown.element) {
                            AppUIUtil.hideToolWindowBalloon((String)ToolWindowId.DEBUG, (Project)this.this$0.$project);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = extBackedChromeConnection;
                this.$url = url;
                this.$usePreliminaryPage = bl;
                this.$project = project;
                this.$errorBalloonAlarm = alarm2;
                this.$errorBalloonShown = booleanRef;
            }
        });
        errorBalloonShown = null;
    }

    /*
     * WARNING - void declaration
     */
    public final void connect(@NotNull Client browserConnection, int tabId, @NotNull Url url, boolean usePreliminaryPage) {
        Intrinsics.checkParameterIsNotNull((Object)browserConnection, (String)"browserConnection");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        DebugEventListener debugEventListener = this.getDebugEventListener();
        JsonRpcServer jsonRpcServer = BrowserConnectionManager.getInstance().getRpcServer();
        if (jsonRpcServer == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonRpcServer, (String)"BrowserConnectionManager.getInstance().rpcServer!!");
        JbWipVm vm = new JbWipVm(this, debugEventListener, new RemoteDebugger(jsonRpcServer, browserConnection, tabId));
        this.setVm((Vm)vm);
        Disposer.register((Disposable)this, (Disposable)vm);
        DebuggerServiceKt.getDebuggerService().registerConnection(browserConnection, tabId, vm);
        vm.enableDebugger();
        VmConnection.setState$default((VmConnection)this, (ConnectionStatus)ConnectionStatus.CONNECTED, (String)"Connected to JetBrains Chrome Extension", null, (int)4, null);
        if (usePreliminaryPage) {
            void $receiver$iv;
            Promise<?> promise2 = new WipVmBootstrap(vm).init(url);
            $receiver$iv.done((Consumer)new Consumer<Object>(this){
                final /* synthetic */ ExtBackedChromeConnection this$0;

                public final void consume(Object it) {
                    ExtBackedChromeConnection.access$startProcessing(this.this$0);
                }
                {
                    this.this$0 = extBackedChromeConnection;
                }
            });
        } else {
            this.startProcessing();
        }
    }

    public final void externallyDetached() {
        Disposer.dispose((Disposable)this);
        this.close(ConnectionStatus.DISCONNECTED.getStatusText() + " (tab was closed or Web Inspector was opened or explicitly detached via Chrome info bar)", ConnectionStatus.DETACHED);
    }

    @NotNull
    public WebBrowser getBrowser() {
        return this.browser;
    }

    public ExtBackedChromeConnection(@NotNull WebBrowser browser) {
        Intrinsics.checkParameterIsNotNull((Object)browser, (String)"browser");
        this.browser = browser;
    }

    @Nullable
    public static final /* synthetic */ JbWipVm access$getJbVm(ExtBackedChromeConnection $this) {
        return $this.getJbVm();
    }

    public static final /* synthetic */ void access$setState(ExtBackedChromeConnection $this, @NotNull ConnectionStatus status, @Nullable String message, @Nullable HyperlinkListener messageLinkListener) {
        $this.setState(status, message, messageLinkListener);
    }

    public static final /* synthetic */ void access$startProcessing(ExtBackedChromeConnection $this) {
        $this.startProcessing();
    }
}

